/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The image scanning configuration for a repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageScanningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageScanningConfiguration.Builder, ImageScanningConfiguration> {
    private static final SdkField<Boolean> SCAN_ON_PUSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("scanOnPush").getter(getter(ImageScanningConfiguration::scanOnPush)).setter(setter(Builder::scanOnPush))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanOnPush").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_ON_PUSH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean scanOnPush;

    private ImageScanningConfiguration(BuilderImpl builder) {
        this.scanOnPush = builder.scanOnPush;
    }

    /**
     * <p>
     * The setting that determines whether images are scanned after being pushed to a repository. If set to
     * <code>true</code>, images will be scanned after being pushed. If this parameter is not specified, it will default
     * to <code>false</code> and images will not be scanned unless a scan is manually started with the <a
     * href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_StartImageScan.html">API_StartImageScan</a>
     * API.
     * </p>
     * 
     * @return The setting that determines whether images are scanned after being pushed to a repository. If set to
     *         <code>true</code>, images will be scanned after being pushed. If this parameter is not specified, it will
     *         default to <code>false</code> and images will not be scanned unless a scan is manually started with the
     *         <a href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_StartImageScan.html">
     *         API_StartImageScan</a> API.
     */
    public final Boolean scanOnPush() {
        return scanOnPush;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scanOnPush());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanningConfiguration)) {
            return false;
        }
        ImageScanningConfiguration other = (ImageScanningConfiguration) obj;
        return Objects.equals(scanOnPush(), other.scanOnPush());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageScanningConfiguration").add("ScanOnPush", scanOnPush()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scanOnPush":
            return Optional.ofNullable(clazz.cast(scanOnPush()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scanOnPush", SCAN_ON_PUSH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageScanningConfiguration, T> g) {
        return obj -> g.apply((ImageScanningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageScanningConfiguration> {
        /**
         * <p>
         * The setting that determines whether images are scanned after being pushed to a repository. If set to
         * <code>true</code>, images will be scanned after being pushed. If this parameter is not specified, it will
         * default to <code>false</code> and images will not be scanned unless a scan is manually started with the <a
         * href
         * ="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_StartImageScan.html">API_StartImageScan</a>
         * API.
         * </p>
         * 
         * @param scanOnPush
         *        The setting that determines whether images are scanned after being pushed to a repository. If set to
         *        <code>true</code>, images will be scanned after being pushed. If this parameter is not specified, it
         *        will default to <code>false</code> and images will not be scanned unless a scan is manually started
         *        with the <a href="https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_StartImageScan.html">
         *        API_StartImageScan</a> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanOnPush(Boolean scanOnPush);
    }

    static final class BuilderImpl implements Builder {
        private Boolean scanOnPush;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanningConfiguration model) {
            scanOnPush(model.scanOnPush);
        }

        public final Boolean getScanOnPush() {
            return scanOnPush;
        }

        public final void setScanOnPush(Boolean scanOnPush) {
            this.scanOnPush = scanOnPush;
        }

        @Override
        public final Builder scanOnPush(Boolean scanOnPush) {
            this.scanOnPush = scanOnPush;
            return this;
        }

        @Override
        public ImageScanningConfiguration build() {
            return new ImageScanningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
