/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FindingSeverity {
    INFORMATIONAL("INFORMATIONAL"),
    LOW("LOW"),
    MEDIUM("MEDIUM"),
    HIGH("HIGH"),
    CRITICAL("CRITICAL"),
    UNDEFINED("UNDEFINED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FindingSeverity> VALUE_MAP;
    private final String value;

    private FindingSeverity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingSeverity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingSeverity> knownValues() {
        EnumSet<FindingSeverity> knownValues = EnumSet.allOf(FindingSeverity.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FindingSeverity.class, FindingSeverity::toString);
    }
}

