/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecr.EcrAsyncClient;
import software.amazon.awssdk.services.ecr.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesRequest;
import software.amazon.awssdk.services.ecr.model.DescribePullThroughCacheRulesResponse;
import software.amazon.awssdk.services.ecr.model.PullThroughCacheRule;

public class DescribePullThroughCacheRulesPublisher
implements SdkPublisher<DescribePullThroughCacheRulesResponse> {
    private final EcrAsyncClient client;
    private final DescribePullThroughCacheRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribePullThroughCacheRulesPublisher(EcrAsyncClient client, DescribePullThroughCacheRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribePullThroughCacheRulesPublisher(EcrAsyncClient client, DescribePullThroughCacheRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribePullThroughCacheRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribePullThroughCacheRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PullThroughCacheRule> pullThroughCacheRules() {
        Function<DescribePullThroughCacheRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.pullThroughCacheRules() != null) {
                return response.pullThroughCacheRules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribePullThroughCacheRulesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribePullThroughCacheRulesResponseFetcher
    implements AsyncPageFetcher<DescribePullThroughCacheRulesResponse> {
        private DescribePullThroughCacheRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribePullThroughCacheRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribePullThroughCacheRulesResponse> nextPage(DescribePullThroughCacheRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribePullThroughCacheRulesPublisher.this.client.describePullThroughCacheRules(DescribePullThroughCacheRulesPublisher.this.firstRequest);
            }
            return DescribePullThroughCacheRulesPublisher.this.client.describePullThroughCacheRules((DescribePullThroughCacheRulesRequest)((Object)DescribePullThroughCacheRulesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

