/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewResult;

public class GetLifecyclePolicyPreviewIterable
implements SdkIterable<GetLifecyclePolicyPreviewResponse> {
    private final EcrClient client;
    private final GetLifecyclePolicyPreviewRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetLifecyclePolicyPreviewIterable(EcrClient client, GetLifecyclePolicyPreviewRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetLifecyclePolicyPreviewResponseFetcher();
    }

    public Iterator<GetLifecyclePolicyPreviewResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LifecyclePolicyPreviewResult> previewResults() {
        Function<GetLifecyclePolicyPreviewResponse, Iterator> getIterator = response -> {
            if (response != null && response.previewResults() != null) {
                return response.previewResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetLifecyclePolicyPreviewResponseFetcher
    implements SyncPageFetcher<GetLifecyclePolicyPreviewResponse> {
        private GetLifecyclePolicyPreviewResponseFetcher() {
        }

        public boolean hasNextPage(GetLifecyclePolicyPreviewResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetLifecyclePolicyPreviewResponse nextPage(GetLifecyclePolicyPreviewResponse previousPage) {
            if (previousPage == null) {
                return GetLifecyclePolicyPreviewIterable.this.client.getLifecyclePolicyPreview(GetLifecyclePolicyPreviewIterable.this.firstRequest);
            }
            return GetLifecyclePolicyPreviewIterable.this.client.getLifecyclePolicyPreview((GetLifecyclePolicyPreviewRequest)((Object)GetLifecyclePolicyPreviewIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

