/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAuthorizationTokenResponse extends EcrPublicResponse implements
        ToCopyableBuilder<GetAuthorizationTokenResponse.Builder, GetAuthorizationTokenResponse> {
    private static final SdkField<AuthorizationData> AUTHORIZATION_DATA_FIELD = SdkField
            .<AuthorizationData> builder(MarshallingType.SDK_POJO).memberName("authorizationData")
            .getter(getter(GetAuthorizationTokenResponse::authorizationData)).setter(setter(Builder::authorizationData))
            .constructor(AuthorizationData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_DATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AuthorizationData authorizationData;

    private GetAuthorizationTokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationData = builder.authorizationData;
    }

    /**
     * <p>
     * An authorization token data object that corresponds to a public registry.
     * </p>
     * 
     * @return An authorization token data object that corresponds to a public registry.
     */
    public final AuthorizationData authorizationData() {
        return authorizationData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authorizationData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenResponse)) {
            return false;
        }
        GetAuthorizationTokenResponse other = (GetAuthorizationTokenResponse) obj;
        return Objects.equals(authorizationData(), other.authorizationData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAuthorizationTokenResponse").add("AuthorizationData", authorizationData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationData":
            return Optional.ofNullable(clazz.cast(authorizationData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("authorizationData", AUTHORIZATION_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenResponse, T> g) {
        return obj -> g.apply((GetAuthorizationTokenResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcrPublicResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAuthorizationTokenResponse> {
        /**
         * <p>
         * An authorization token data object that corresponds to a public registry.
         * </p>
         * 
         * @param authorizationData
         *        An authorization token data object that corresponds to a public registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizationData(AuthorizationData authorizationData);

        /**
         * <p>
         * An authorization token data object that corresponds to a public registry.
         * </p>
         * This is a convenience method that creates an instance of the {@link AuthorizationData.Builder} avoiding the
         * need to create one manually via {@link AuthorizationData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AuthorizationData.Builder#build()} is called immediately and its
         * result is passed to {@link #authorizationData(AuthorizationData)}.
         * 
         * @param authorizationData
         *        a consumer that will call methods on {@link AuthorizationData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizationData(AuthorizationData)
         */
        default Builder authorizationData(Consumer<AuthorizationData.Builder> authorizationData) {
            return authorizationData(AuthorizationData.builder().applyMutation(authorizationData).build());
        }
    }

    static final class BuilderImpl extends EcrPublicResponse.BuilderImpl implements Builder {
        private AuthorizationData authorizationData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenResponse model) {
            super(model);
            authorizationData(model.authorizationData);
        }

        public final AuthorizationData.Builder getAuthorizationData() {
            return authorizationData != null ? authorizationData.toBuilder() : null;
        }

        public final void setAuthorizationData(AuthorizationData.BuilderImpl authorizationData) {
            this.authorizationData = authorizationData != null ? authorizationData.build() : null;
        }

        @Override
        public final Builder authorizationData(AuthorizationData authorizationData) {
            this.authorizationData = authorizationData;
            return this;
        }

        @Override
        public GetAuthorizationTokenResponse build() {
            return new GetAuthorizationTokenResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
