/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of the Auto Scaling group capacity provider to update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutoScalingGroupProviderUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<AutoScalingGroupProviderUpdate.Builder, AutoScalingGroupProviderUpdate> {
    private static final SdkField<ManagedScaling> MANAGED_SCALING_FIELD = SdkField
            .<ManagedScaling> builder(MarshallingType.SDK_POJO).memberName("managedScaling")
            .getter(getter(AutoScalingGroupProviderUpdate::managedScaling)).setter(setter(Builder::managedScaling))
            .constructor(ManagedScaling::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedScaling").build()).build();

    private static final SdkField<String> MANAGED_TERMINATION_PROTECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("managedTerminationProtection")
            .getter(getter(AutoScalingGroupProviderUpdate::managedTerminationProtectionAsString))
            .setter(setter(Builder::managedTerminationProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedTerminationProtection")
                    .build()).build();

    private static final SdkField<String> MANAGED_DRAINING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedDraining").getter(getter(AutoScalingGroupProviderUpdate::managedDrainingAsString))
            .setter(setter(Builder::managedDraining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedDraining").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_SCALING_FIELD,
            MANAGED_TERMINATION_PROTECTION_FIELD, MANAGED_DRAINING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ManagedScaling managedScaling;

    private final String managedTerminationProtection;

    private final String managedDraining;

    private AutoScalingGroupProviderUpdate(BuilderImpl builder) {
        this.managedScaling = builder.managedScaling;
        this.managedTerminationProtection = builder.managedTerminationProtection;
        this.managedDraining = builder.managedDraining;
    }

    /**
     * <p>
     * The managed scaling settings for the Auto Scaling group capacity provider.
     * </p>
     * 
     * @return The managed scaling settings for the Auto Scaling group capacity provider.
     */
    public final ManagedScaling managedScaling() {
        return managedScaling;
    }

    /**
     * <p>
     * The managed termination protection setting to use for the Auto Scaling group capacity provider. This determines
     * whether the Auto Scaling group has managed termination protection.
     * </p>
     * <important>
     * <p>
     * When using managed termination protection, managed scaling must also be used otherwise managed termination
     * protection doesn't work.
     * </p>
     * </important>
     * <p>
     * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group
     * that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in
     * the Auto Scaling group must have instance protection from scale-in actions on. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     * >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the
     * Auto Scaling group scales in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedTerminationProtection} will return {@link ManagedTerminationProtection#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #managedTerminationProtectionAsString}.
     * </p>
     * 
     * @return The managed termination protection setting to use for the Auto Scaling group capacity provider. This
     *         determines whether the Auto Scaling group has managed termination protection.</p> <important>
     *         <p>
     *         When using managed termination protection, managed scaling must also be used otherwise managed
     *         termination protection doesn't work.
     *         </p>
     *         </important>
     *         <p>
     *         When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto
     *         Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group
     *         and each instance in the Auto Scaling group must have instance protection from scale-in actions on. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     *         >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
     *         </p>
     *         <p>
     *         When managed termination protection is off, your Amazon EC2 instances aren't protected from termination
     *         when the Auto Scaling group scales in.
     * @see ManagedTerminationProtection
     */
    public final ManagedTerminationProtection managedTerminationProtection() {
        return ManagedTerminationProtection.fromValue(managedTerminationProtection);
    }

    /**
     * <p>
     * The managed termination protection setting to use for the Auto Scaling group capacity provider. This determines
     * whether the Auto Scaling group has managed termination protection.
     * </p>
     * <important>
     * <p>
     * When using managed termination protection, managed scaling must also be used otherwise managed termination
     * protection doesn't work.
     * </p>
     * </important>
     * <p>
     * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling group
     * that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each instance in
     * the Auto Scaling group must have instance protection from scale-in actions on. For more information, see <a
     * href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     * >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * <p>
     * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when the
     * Auto Scaling group scales in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #managedTerminationProtection} will return {@link ManagedTerminationProtection#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #managedTerminationProtectionAsString}.
     * </p>
     * 
     * @return The managed termination protection setting to use for the Auto Scaling group capacity provider. This
     *         determines whether the Auto Scaling group has managed termination protection.</p> <important>
     *         <p>
     *         When using managed termination protection, managed scaling must also be used otherwise managed
     *         termination protection doesn't work.
     *         </p>
     *         </important>
     *         <p>
     *         When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto
     *         Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling group
     *         and each instance in the Auto Scaling group must have instance protection from scale-in actions on. For
     *         more information, see <a href=
     *         "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
     *         >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
     *         </p>
     *         <p>
     *         When managed termination protection is off, your Amazon EC2 instances aren't protected from termination
     *         when the Auto Scaling group scales in.
     * @see ManagedTerminationProtection
     */
    public final String managedTerminationProtectionAsString() {
        return managedTerminationProtection;
    }

    /**
     * <p>
     * The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon ECS
     * manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedDraining}
     * will return {@link ManagedDraining#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managedDrainingAsString}.
     * </p>
     * 
     * @return The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon
     *         ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity
     *         provider.
     * @see ManagedDraining
     */
    public final ManagedDraining managedDraining() {
        return ManagedDraining.fromValue(managedDraining);
    }

    /**
     * <p>
     * The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon ECS
     * manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity provider.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #managedDraining}
     * will return {@link ManagedDraining#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #managedDrainingAsString}.
     * </p>
     * 
     * @return The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon
     *         ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity
     *         provider.
     * @see ManagedDraining
     */
    public final String managedDrainingAsString() {
        return managedDraining;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(managedScaling());
        hashCode = 31 * hashCode + Objects.hashCode(managedTerminationProtectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(managedDrainingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoScalingGroupProviderUpdate)) {
            return false;
        }
        AutoScalingGroupProviderUpdate other = (AutoScalingGroupProviderUpdate) obj;
        return Objects.equals(managedScaling(), other.managedScaling())
                && Objects.equals(managedTerminationProtectionAsString(), other.managedTerminationProtectionAsString())
                && Objects.equals(managedDrainingAsString(), other.managedDrainingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutoScalingGroupProviderUpdate").add("ManagedScaling", managedScaling())
                .add("ManagedTerminationProtection", managedTerminationProtectionAsString())
                .add("ManagedDraining", managedDrainingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "managedScaling":
            return Optional.ofNullable(clazz.cast(managedScaling()));
        case "managedTerminationProtection":
            return Optional.ofNullable(clazz.cast(managedTerminationProtectionAsString()));
        case "managedDraining":
            return Optional.ofNullable(clazz.cast(managedDrainingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("managedScaling", MANAGED_SCALING_FIELD);
        map.put("managedTerminationProtection", MANAGED_TERMINATION_PROTECTION_FIELD);
        map.put("managedDraining", MANAGED_DRAINING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutoScalingGroupProviderUpdate, T> g) {
        return obj -> g.apply((AutoScalingGroupProviderUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutoScalingGroupProviderUpdate> {
        /**
         * <p>
         * The managed scaling settings for the Auto Scaling group capacity provider.
         * </p>
         * 
         * @param managedScaling
         *        The managed scaling settings for the Auto Scaling group capacity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedScaling(ManagedScaling managedScaling);

        /**
         * <p>
         * The managed scaling settings for the Auto Scaling group capacity provider.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedScaling.Builder} avoiding the need
         * to create one manually via {@link ManagedScaling#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedScaling.Builder#build()} is called immediately and its
         * result is passed to {@link #managedScaling(ManagedScaling)}.
         * 
         * @param managedScaling
         *        a consumer that will call methods on {@link ManagedScaling.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedScaling(ManagedScaling)
         */
        default Builder managedScaling(Consumer<ManagedScaling.Builder> managedScaling) {
            return managedScaling(ManagedScaling.builder().applyMutation(managedScaling).build());
        }

        /**
         * <p>
         * The managed termination protection setting to use for the Auto Scaling group capacity provider. This
         * determines whether the Auto Scaling group has managed termination protection.
         * </p>
         * <important>
         * <p>
         * When using managed termination protection, managed scaling must also be used otherwise managed termination
         * protection doesn't work.
         * </p>
         * </important>
         * <p>
         * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling
         * group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each
         * instance in the Auto Scaling group must have instance protection from scale-in actions on. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
         * >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when
         * the Auto Scaling group scales in.
         * </p>
         * 
         * @param managedTerminationProtection
         *        The managed termination protection setting to use for the Auto Scaling group capacity provider. This
         *        determines whether the Auto Scaling group has managed termination protection.</p> <important>
         *        <p>
         *        When using managed termination protection, managed scaling must also be used otherwise managed
         *        termination protection doesn't work.
         *        </p>
         *        </important>
         *        <p>
         *        When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto
         *        Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling
         *        group and each instance in the Auto Scaling group must have instance protection from scale-in actions
         *        on. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
         *        >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
         *        </p>
         *        <p>
         *        When managed termination protection is off, your Amazon EC2 instances aren't protected from
         *        termination when the Auto Scaling group scales in.
         * @see ManagedTerminationProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedTerminationProtection
         */
        Builder managedTerminationProtection(String managedTerminationProtection);

        /**
         * <p>
         * The managed termination protection setting to use for the Auto Scaling group capacity provider. This
         * determines whether the Auto Scaling group has managed termination protection.
         * </p>
         * <important>
         * <p>
         * When using managed termination protection, managed scaling must also be used otherwise managed termination
         * protection doesn't work.
         * </p>
         * </important>
         * <p>
         * When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto Scaling
         * group that contain tasks from being terminated during a scale-in action. The Auto Scaling group and each
         * instance in the Auto Scaling group must have instance protection from scale-in actions on. For more
         * information, see <a href=
         * "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
         * >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
         * </p>
         * <p>
         * When managed termination protection is off, your Amazon EC2 instances aren't protected from termination when
         * the Auto Scaling group scales in.
         * </p>
         * 
         * @param managedTerminationProtection
         *        The managed termination protection setting to use for the Auto Scaling group capacity provider. This
         *        determines whether the Auto Scaling group has managed termination protection.</p> <important>
         *        <p>
         *        When using managed termination protection, managed scaling must also be used otherwise managed
         *        termination protection doesn't work.
         *        </p>
         *        </important>
         *        <p>
         *        When managed termination protection is on, Amazon ECS prevents the Amazon EC2 instances in an Auto
         *        Scaling group that contain tasks from being terminated during a scale-in action. The Auto Scaling
         *        group and each instance in the Auto Scaling group must have instance protection from scale-in actions
         *        on. For more information, see <a href=
         *        "https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection"
         *        >Instance Protection</a> in the <i>Auto Scaling User Guide</i>.
         *        </p>
         *        <p>
         *        When managed termination protection is off, your Amazon EC2 instances aren't protected from
         *        termination when the Auto Scaling group scales in.
         * @see ManagedTerminationProtection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedTerminationProtection
         */
        Builder managedTerminationProtection(ManagedTerminationProtection managedTerminationProtection);

        /**
         * <p>
         * The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon ECS
         * manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity
         * provider.
         * </p>
         * 
         * @param managedDraining
         *        The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon
         *        ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group
         *        capacity provider.
         * @see ManagedDraining
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedDraining
         */
        Builder managedDraining(String managedDraining);

        /**
         * <p>
         * The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon ECS
         * manages and gracefully drains the EC2 container instances that are in the Auto Scaling group capacity
         * provider.
         * </p>
         * 
         * @param managedDraining
         *        The managed draining option for the Auto Scaling group capacity provider. When you enable this, Amazon
         *        ECS manages and gracefully drains the EC2 container instances that are in the Auto Scaling group
         *        capacity provider.
         * @see ManagedDraining
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedDraining
         */
        Builder managedDraining(ManagedDraining managedDraining);
    }

    static final class BuilderImpl implements Builder {
        private ManagedScaling managedScaling;

        private String managedTerminationProtection;

        private String managedDraining;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoScalingGroupProviderUpdate model) {
            managedScaling(model.managedScaling);
            managedTerminationProtection(model.managedTerminationProtection);
            managedDraining(model.managedDraining);
        }

        public final ManagedScaling.Builder getManagedScaling() {
            return managedScaling != null ? managedScaling.toBuilder() : null;
        }

        public final void setManagedScaling(ManagedScaling.BuilderImpl managedScaling) {
            this.managedScaling = managedScaling != null ? managedScaling.build() : null;
        }

        @Override
        public final Builder managedScaling(ManagedScaling managedScaling) {
            this.managedScaling = managedScaling;
            return this;
        }

        public final String getManagedTerminationProtection() {
            return managedTerminationProtection;
        }

        public final void setManagedTerminationProtection(String managedTerminationProtection) {
            this.managedTerminationProtection = managedTerminationProtection;
        }

        @Override
        public final Builder managedTerminationProtection(String managedTerminationProtection) {
            this.managedTerminationProtection = managedTerminationProtection;
            return this;
        }

        @Override
        public final Builder managedTerminationProtection(ManagedTerminationProtection managedTerminationProtection) {
            this.managedTerminationProtection(managedTerminationProtection == null ? null : managedTerminationProtection
                    .toString());
            return this;
        }

        public final String getManagedDraining() {
            return managedDraining;
        }

        public final void setManagedDraining(String managedDraining) {
            this.managedDraining = managedDraining;
        }

        @Override
        public final Builder managedDraining(String managedDraining) {
            this.managedDraining = managedDraining;
            return this;
        }

        @Override
        public final Builder managedDraining(ManagedDraining managedDraining) {
            this.managedDraining(managedDraining == null ? null : managedDraining.toString());
            return this;
        }

        @Override
        public AutoScalingGroupProviderUpdate build() {
            return new AutoScalingGroupProviderUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
