/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServiceResponse extends EcsResponse implements
        ToCopyableBuilder<CreateServiceResponse.Builder, CreateServiceResponse> {
    private static final SdkField<Service> SERVICE_FIELD = SdkField.<Service> builder(MarshallingType.SDK_POJO)
            .memberName("service").getter(getter(CreateServiceResponse::service)).setter(setter(Builder::service))
            .constructor(Service::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Service service;

    private CreateServiceResponse(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
    }

    /**
     * <p>
     * The full description of your service following the create call.
     * </p>
     * <p>
     * A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code> parameter, but
     * not both, depending where one was specified when it was created.
     * </p>
     * <p>
     * If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code> and
     * <code>taskSets</code> parameters will not be returned.
     * </p>
     * <p>
     * if the service uses the <code>CODE_DEPLOY</code> deployment controller, the <code>deploymentController</code>,
     * <code>taskSets</code> and <code>deployments</code> parameters will be returned, however the
     * <code>deployments</code> parameter will be an empty list.
     * </p>
     * 
     * @return The full description of your service following the create call.</p>
     *         <p>
     *         A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code>
     *         parameter, but not both, depending where one was specified when it was created.
     *         </p>
     *         <p>
     *         If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code>
     *         and <code>taskSets</code> parameters will not be returned.
     *         </p>
     *         <p>
     *         if the service uses the <code>CODE_DEPLOY</code> deployment controller, the
     *         <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will be
     *         returned, however the <code>deployments</code> parameter will be an empty list.
     */
    public final Service service() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(service());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServiceResponse)) {
            return false;
        }
        CreateServiceResponse other = (CreateServiceResponse) obj;
        return Objects.equals(service(), other.service());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateServiceResponse").add("Service", service()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("service", SERVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateServiceResponse, T> g) {
        return obj -> g.apply((CreateServiceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateServiceResponse> {
        /**
         * <p>
         * The full description of your service following the create call.
         * </p>
         * <p>
         * A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code> parameter,
         * but not both, depending where one was specified when it was created.
         * </p>
         * <p>
         * If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code> and
         * <code>taskSets</code> parameters will not be returned.
         * </p>
         * <p>
         * if the service uses the <code>CODE_DEPLOY</code> deployment controller, the <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will be returned, however the
         * <code>deployments</code> parameter will be an empty list.
         * </p>
         * 
         * @param service
         *        The full description of your service following the create call.</p>
         *        <p>
         *        A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code>
         *        parameter, but not both, depending where one was specified when it was created.
         *        </p>
         *        <p>
         *        If a service is using the <code>ECS</code> deployment controller, the
         *        <code>deploymentController</code> and <code>taskSets</code> parameters will not be returned.
         *        </p>
         *        <p>
         *        if the service uses the <code>CODE_DEPLOY</code> deployment controller, the
         *        <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will
         *        be returned, however the <code>deployments</code> parameter will be an empty list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Service service);

        /**
         * <p>
         * The full description of your service following the create call.
         * </p>
         * <p>
         * A service will return either a <code>capacityProviderStrategy</code> or <code>launchType</code> parameter,
         * but not both, depending where one was specified when it was created.
         * </p>
         * <p>
         * If a service is using the <code>ECS</code> deployment controller, the <code>deploymentController</code> and
         * <code>taskSets</code> parameters will not be returned.
         * </p>
         * <p>
         * if the service uses the <code>CODE_DEPLOY</code> deployment controller, the <code>deploymentController</code>, <code>taskSets</code> and <code>deployments</code> parameters will be returned, however the
         * <code>deployments</code> parameter will be an empty list.
         * </p>
         * This is a convenience method that creates an instance of the {@link Service.Builder} avoiding the need to
         * create one manually via {@link Service#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Service.Builder#build()} is called immediately and its result is
         * passed to {@link #service(Service)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link Service.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(Service)
         */
        default Builder service(Consumer<Service.Builder> service) {
            return service(Service.builder().applyMutation(service).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private Service service;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServiceResponse model) {
            super(model);
            service(model.service);
        }

        public final Service.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        @Override
        public CreateServiceResponse build() {
            return new CreateServiceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
