/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTaskSetResponse extends EcsResponse implements
        ToCopyableBuilder<CreateTaskSetResponse.Builder, CreateTaskSetResponse> {
    private static final SdkField<TaskSet> TASK_SET_FIELD = SdkField.<TaskSet> builder(MarshallingType.SDK_POJO)
            .memberName("taskSet").getter(getter(CreateTaskSetResponse::taskSet)).setter(setter(Builder::taskSet))
            .constructor(TaskSet::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSet").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_SET_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TaskSet taskSet;

    private CreateTaskSetResponse(BuilderImpl builder) {
        super(builder);
        this.taskSet = builder.taskSet;
    }

    /**
     * <p>
     * Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. A
     * task set includes details such as the desired number of tasks, how many tasks are running, and whether the task
     * set serves production traffic.
     * </p>
     * 
     * @return Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
     *         deployment. A task set includes details such as the desired number of tasks, how many tasks are running,
     *         and whether the task set serves production traffic.
     */
    public final TaskSet taskSet() {
        return taskSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskSet());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTaskSetResponse)) {
            return false;
        }
        CreateTaskSetResponse other = (CreateTaskSetResponse) obj;
        return Objects.equals(taskSet(), other.taskSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTaskSetResponse").add("TaskSet", taskSet()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskSet":
            return Optional.ofNullable(clazz.cast(taskSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskSet", TASK_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTaskSetResponse, T> g) {
        return obj -> g.apply((CreateTaskSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateTaskSetResponse> {
        /**
         * <p>
         * Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. A
         * task set includes details such as the desired number of tasks, how many tasks are running, and whether the
         * task set serves production traffic.
         * </p>
         * 
         * @param taskSet
         *        Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code>
         *        deployment. A task set includes details such as the desired number of tasks, how many tasks are
         *        running, and whether the task set serves production traffic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSet(TaskSet taskSet);

        /**
         * <p>
         * Information about a set of Amazon ECS tasks in either an CodeDeploy or an <code>EXTERNAL</code> deployment. A
         * task set includes details such as the desired number of tasks, how many tasks are running, and whether the
         * task set serves production traffic.
         * </p>
         * This is a convenience method that creates an instance of the {@link TaskSet.Builder} avoiding the need to
         * create one manually via {@link TaskSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TaskSet.Builder#build()} is called immediately and its result is
         * passed to {@link #taskSet(TaskSet)}.
         * 
         * @param taskSet
         *        a consumer that will call methods on {@link TaskSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSet(TaskSet)
         */
        default Builder taskSet(Consumer<TaskSet.Builder> taskSet) {
            return taskSet(TaskSet.builder().applyMutation(taskSet).build());
        }
    }

    static final class BuilderImpl extends EcsResponse.BuilderImpl implements Builder {
        private TaskSet taskSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTaskSetResponse model) {
            super(model);
            taskSet(model.taskSet);
        }

        public final TaskSet.Builder getTaskSet() {
            return taskSet != null ? taskSet.toBuilder() : null;
        }

        public final void setTaskSet(TaskSet.BuilderImpl taskSet) {
            this.taskSet = taskSet != null ? taskSet.build() : null;
        }

        @Override
        public final Builder taskSet(TaskSet taskSet) {
            this.taskSet = taskSet;
            return this;
        }

        @Override
        public CreateTaskSetResponse build() {
            return new CreateTaskSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
