/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Each alias ("endpoint") is a fully-qualified name and port number that other tasks ("clients") can use to connect to
 * this service.
 * </p>
 * <p>
 * Each name and port mapping must be unique within the namespace.
 * </p>
 * <p>
 * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to
 * services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects
 * logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service
 * Connect. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the
 * <i>Amazon Elastic Container Service Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConnectClientAlias implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConnectClientAlias.Builder, ServiceConnectClientAlias> {
    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(ServiceConnectClientAlias::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dnsName").getter(getter(ServiceConnectClientAlias::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORT_FIELD, DNS_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer port;

    private final String dnsName;

    private ServiceConnectClientAlias(BuilderImpl builder) {
        this.port = builder.port;
        this.dnsName = builder.dnsName;
    }

    /**
     * <p>
     * The listening port number for the Service Connect proxy. This port is available inside of all of the tasks within
     * the same namespace.
     * </p>
     * <p>
     * To avoid changing your applications in client Amazon ECS services, set this to the same port that the client
     * application uses by default. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The listening port number for the Service Connect proxy. This port is available inside of all of the
     *         tasks within the same namespace.</p>
     *         <p>
     *         To avoid changing your applications in client Amazon ECS services, set this to the same port that the
     *         client application uses by default. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
     *         Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The <code>dnsName</code> is the name that you use in the applications of client tasks to connect to this service.
     * The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include up to 127
     * characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and periods (.). The
     * name can't start with a hyphen.
     * </p>
     * <p>
     * If this parameter isn't specified, the default value of <code>discoveryName.namespace</code> is used. If the
     * <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in
     * <code>portName.namespace</code>.
     * </p>
     * <p>
     * To avoid changing your applications in client Amazon ECS services, set this to the same name that the client
     * application uses by default. For example, a few common names are <code>database</code>, <code>db</code>, or the
     * lowercase name of a database, such as <code>mysql</code> or <code>redis</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in
     * the <i>Amazon Elastic Container Service Developer Guide</i>.
     * </p>
     * 
     * @return The <code>dnsName</code> is the name that you use in the applications of client tasks to connect to this
     *         service. The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include
     *         up to 127 characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and
     *         periods (.). The name can't start with a hyphen.</p>
     *         <p>
     *         If this parameter isn't specified, the default value of <code>discoveryName.namespace</code> is used. If
     *         the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in
     *         <code>portName.namespace</code>.
     *         </p>
     *         <p>
     *         To avoid changing your applications in client Amazon ECS services, set this to the same name that the
     *         client application uses by default. For example, a few common names are <code>database</code>,
     *         <code>db</code>, or the lowercase name of a database, such as <code>mysql</code> or <code>redis</code>.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
     *         Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
     */
    public final String dnsName() {
        return dnsName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectClientAlias)) {
            return false;
        }
        ServiceConnectClientAlias other = (ServiceConnectClientAlias) obj;
        return Objects.equals(port(), other.port()) && Objects.equals(dnsName(), other.dnsName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConnectClientAlias").add("Port", port()).add("DnsName", dnsName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "dnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("port", PORT_FIELD);
        map.put("dnsName", DNS_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectClientAlias, T> g) {
        return obj -> g.apply((ServiceConnectClientAlias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConnectClientAlias> {
        /**
         * <p>
         * The listening port number for the Service Connect proxy. This port is available inside of all of the tasks
         * within the same namespace.
         * </p>
         * <p>
         * To avoid changing your applications in client Amazon ECS services, set this to the same port that the client
         * application uses by default. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a>
         * in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param port
         *        The listening port number for the Service Connect proxy. This port is available inside of all of the
         *        tasks within the same namespace.</p>
         *        <p>
         *        To avoid changing your applications in client Amazon ECS services, set this to the same port that the
         *        client application uses by default. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
         *        Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The <code>dnsName</code> is the name that you use in the applications of client tasks to connect to this
         * service. The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include up to
         * 127 characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and periods
         * (.). The name can't start with a hyphen.
         * </p>
         * <p>
         * If this parameter isn't specified, the default value of <code>discoveryName.namespace</code> is used. If the
         * <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in
         * <code>portName.namespace</code>.
         * </p>
         * <p>
         * To avoid changing your applications in client Amazon ECS services, set this to the same name that the client
         * application uses by default. For example, a few common names are <code>database</code>, <code>db</code>, or
         * the lowercase name of a database, such as <code>mysql</code> or <code>redis</code>. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
         * Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * </p>
         * 
         * @param dnsName
         *        The <code>dnsName</code> is the name that you use in the applications of client tasks to connect to
         *        this service. The name must be a valid DNS name but doesn't need to be fully-qualified. The name can
         *        include up to 127 characters. The name can include lowercase letters, numbers, underscores (_),
         *        hyphens (-), and periods (.). The name can't start with a hyphen.</p>
         *        <p>
         *        If this parameter isn't specified, the default value of <code>discoveryName.namespace</code> is used.
         *        If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is
         *        used in <code>portName.namespace</code>.
         *        </p>
         *        <p>
         *        To avoid changing your applications in client Amazon ECS services, set this to the same name that the
         *        client application uses by default. For example, a few common names are <code>database</code>,
         *        <code>db</code>, or the lowercase name of a database, such as <code>mysql</code> or <code>redis</code>
         *        . For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service
         *        Connect</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);
    }

    static final class BuilderImpl implements Builder {
        private Integer port;

        private String dnsName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectClientAlias model) {
            port(model.port);
            dnsName(model.dnsName);
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        @Override
        public ServiceConnectClientAlias build() {
            return new ServiceConnectClientAlias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
