/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Service Connect resource. Each configuration maps a discovery name to a Cloud Map service name. The data is
 * stored in Cloud Map as part of the Service Connect configuration for each discovery name of this Amazon ECS service.
 * </p>
 * <p>
 * A task can resolve the <code>dnsName</code> for each of the <code>clientAliases</code> of a service. However a task
 * can't resolve the discovery names. If you want to connect to a service, refer to the
 * <code>ServiceConnectConfiguration</code> of that service for the list of <code>clientAliases</code> that you can use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceConnectServiceResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceConnectServiceResource.Builder, ServiceConnectServiceResource> {
    private static final SdkField<String> DISCOVERY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("discoveryName").getter(getter(ServiceConnectServiceResource::discoveryName))
            .setter(setter(Builder::discoveryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryName").build()).build();

    private static final SdkField<String> DISCOVERY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("discoveryArn").getter(getter(ServiceConnectServiceResource::discoveryArn))
            .setter(setter(Builder::discoveryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("discoveryArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISCOVERY_NAME_FIELD,
            DISCOVERY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String discoveryName;

    private final String discoveryArn;

    private ServiceConnectServiceResource(BuilderImpl builder) {
        this.discoveryName = builder.discoveryName;
        this.discoveryArn = builder.discoveryArn;
    }

    /**
     * <p>
     * The discovery name of this Service Connect resource.
     * </p>
     * <p>
     * The <code>discoveryName</code> is the name of the new Cloud Map service that Amazon ECS creates for this Amazon
     * ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64 characters. The
     * name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a
     * hyphen.
     * </p>
     * <p>
     * If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in
     * <code>portName.namespace</code>.
     * </p>
     * 
     * @return The discovery name of this Service Connect resource.</p>
     *         <p>
     *         The <code>discoveryName</code> is the name of the new Cloud Map service that Amazon ECS creates for this
     *         Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64
     *         characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name
     *         can't start with a hyphen.
     *         </p>
     *         <p>
     *         If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used
     *         in <code>portName.namespace</code>.
     */
    public final String discoveryName() {
        return discoveryName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the namespace in Cloud Map that matches the discovery name for this Service
     * Connect resource. You can use this ARN in other integrations with Cloud Map. However, Service Connect can't
     * ensure connectivity outside of Amazon ECS.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the namespace in Cloud Map that matches the discovery name for this
     *         Service Connect resource. You can use this ARN in other integrations with Cloud Map. However, Service
     *         Connect can't ensure connectivity outside of Amazon ECS.
     */
    public final String discoveryArn() {
        return discoveryArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(discoveryName());
        hashCode = 31 * hashCode + Objects.hashCode(discoveryArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectServiceResource)) {
            return false;
        }
        ServiceConnectServiceResource other = (ServiceConnectServiceResource) obj;
        return Objects.equals(discoveryName(), other.discoveryName()) && Objects.equals(discoveryArn(), other.discoveryArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceConnectServiceResource").add("DiscoveryName", discoveryName())
                .add("DiscoveryArn", discoveryArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "discoveryName":
            return Optional.ofNullable(clazz.cast(discoveryName()));
        case "discoveryArn":
            return Optional.ofNullable(clazz.cast(discoveryArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("discoveryName", DISCOVERY_NAME_FIELD);
        map.put("discoveryArn", DISCOVERY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceConnectServiceResource, T> g) {
        return obj -> g.apply((ServiceConnectServiceResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceConnectServiceResource> {
        /**
         * <p>
         * The discovery name of this Service Connect resource.
         * </p>
         * <p>
         * The <code>discoveryName</code> is the name of the new Cloud Map service that Amazon ECS creates for this
         * Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up to 64
         * characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't
         * start with a hyphen.
         * </p>
         * <p>
         * If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in
         * <code>portName.namespace</code>.
         * </p>
         * 
         * @param discoveryName
         *        The discovery name of this Service Connect resource.</p>
         *        <p>
         *        The <code>discoveryName</code> is the name of the new Cloud Map service that Amazon ECS creates for
         *        this Amazon ECS service. This must be unique within the Cloud Map namespace. The name can contain up
         *        to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-).
         *        The name can't start with a hyphen.
         *        </p>
         *        <p>
         *        If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is
         *        used in <code>portName.namespace</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryName(String discoveryName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the namespace in Cloud Map that matches the discovery name for this
         * Service Connect resource. You can use this ARN in other integrations with Cloud Map. However, Service Connect
         * can't ensure connectivity outside of Amazon ECS.
         * </p>
         * 
         * @param discoveryArn
         *        The Amazon Resource Name (ARN) for the namespace in Cloud Map that matches the discovery name for this
         *        Service Connect resource. You can use this ARN in other integrations with Cloud Map. However, Service
         *        Connect can't ensure connectivity outside of Amazon ECS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder discoveryArn(String discoveryArn);
    }

    static final class BuilderImpl implements Builder {
        private String discoveryName;

        private String discoveryArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceConnectServiceResource model) {
            discoveryName(model.discoveryName);
            discoveryArn(model.discoveryArn);
        }

        public final String getDiscoveryName() {
            return discoveryName;
        }

        public final void setDiscoveryName(String discoveryName) {
            this.discoveryName = discoveryName;
        }

        @Override
        public final Builder discoveryName(String discoveryName) {
            this.discoveryName = discoveryName;
            return this;
        }

        public final String getDiscoveryArn() {
            return discoveryArn;
        }

        public final void setDiscoveryArn(String discoveryArn) {
            this.discoveryArn = discoveryArn;
        }

        @Override
        public final Builder discoveryArn(String discoveryArn) {
            this.discoveryArn = discoveryArn;
            return this;
        }

        @Override
        public ServiceConnectServiceResource build() {
            return new ServiceConnectServiceResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
