/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateClusterSettingsRequest extends EcsRequest implements
        ToCopyableBuilder<UpdateClusterSettingsRequest.Builder, UpdateClusterSettingsRequest> {
    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cluster")
            .getter(getter(UpdateClusterSettingsRequest::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cluster").build()).build();

    private static final SdkField<List<ClusterSetting>> SETTINGS_FIELD = SdkField
            .<List<ClusterSetting>> builder(MarshallingType.LIST)
            .memberName("settings")
            .getter(getter(UpdateClusterSettingsRequest::settings))
            .setter(setter(Builder::settings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterSetting> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterSetting::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLUSTER_FIELD, SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cluster;

    private final List<ClusterSetting> settings;

    private UpdateClusterSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.cluster = builder.cluster;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The name of the cluster to modify the settings for.
     * </p>
     * 
     * @return The name of the cluster to modify the settings for.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * For responses, this returns true if the service returned a value for the Settings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSettings() {
        return settings != null && !(settings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container Insights for
     * a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <a
     * href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a>
     * or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">
     * PutAccountSettingDefault</a>.
     * </p>
     * <important>
     * <p>
     * Currently, if you delete an existing cluster that does not have Container Insights turned on, and then create a
     * new cluster with the same name with Container Insights tuned on, Container Insights will not actually be turned
     * on. If you want to preserve the same name for your existing cluster and turn on Container Insights, you must wait
     * 7 days before you can re-create it.
     * </p>
     * </important>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSettings} method.
     * </p>
     * 
     * @return The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container
     *         Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value
     *         set with <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">
     *         PutAccountSetting</a> or <a
     *         href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html"
     *         >PutAccountSettingDefault</a>.</p> <important>
     *         <p>
     *         Currently, if you delete an existing cluster that does not have Container Insights turned on, and then
     *         create a new cluster with the same name with Container Insights tuned on, Container Insights will not
     *         actually be turned on. If you want to preserve the same name for your existing cluster and turn on
     *         Container Insights, you must wait 7 days before you can re-create it.
     *         </p>
     */
    public final List<ClusterSetting> settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(hasSettings() ? settings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterSettingsRequest)) {
            return false;
        }
        UpdateClusterSettingsRequest other = (UpdateClusterSettingsRequest) obj;
        return Objects.equals(cluster(), other.cluster()) && hasSettings() == other.hasSettings()
                && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateClusterSettingsRequest").add("Cluster", cluster())
                .add("Settings", hasSettings() ? settings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cluster", CLUSTER_FIELD);
        map.put("settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterSettingsRequest, T> g) {
        return obj -> g.apply((UpdateClusterSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EcsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateClusterSettingsRequest> {
        /**
         * <p>
         * The name of the cluster to modify the settings for.
         * </p>
         * 
         * @param cluster
         *        The name of the cluster to modify the settings for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container Insights
         * for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <a
         * href
         * ="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a>
         * or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">
         * PutAccountSettingDefault</a>.
         * </p>
         * <important>
         * <p>
         * Currently, if you delete an existing cluster that does not have Container Insights turned on, and then create
         * a new cluster with the same name with Container Insights tuned on, Container Insights will not actually be
         * turned on. If you want to preserve the same name for your existing cluster and turn on Container Insights,
         * you must wait 7 days before you can re-create it.
         * </p>
         * </important>
         * 
         * @param settings
         *        The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container
         *        Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code>
         *        value set with <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html"
         *        >PutAccountSetting</a> or <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html"
         *        >PutAccountSettingDefault</a>.</p> <important>
         *        <p>
         *        Currently, if you delete an existing cluster that does not have Container Insights turned on, and then
         *        create a new cluster with the same name with Container Insights tuned on, Container Insights will not
         *        actually be turned on. If you want to preserve the same name for your existing cluster and turn on
         *        Container Insights, you must wait 7 days before you can re-create it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(Collection<ClusterSetting> settings);

        /**
         * <p>
         * The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container Insights
         * for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <a
         * href
         * ="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a>
         * or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">
         * PutAccountSettingDefault</a>.
         * </p>
         * <important>
         * <p>
         * Currently, if you delete an existing cluster that does not have Container Insights turned on, and then create
         * a new cluster with the same name with Container Insights tuned on, Container Insights will not actually be
         * turned on. If you want to preserve the same name for your existing cluster and turn on Container Insights,
         * you must wait 7 days before you can re-create it.
         * </p>
         * </important>
         * 
         * @param settings
         *        The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container
         *        Insights for a cluster. If this value is specified, it overrides the <code>containerInsights</code>
         *        value set with <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html"
         *        >PutAccountSetting</a> or <a
         *        href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html"
         *        >PutAccountSettingDefault</a>.</p> <important>
         *        <p>
         *        Currently, if you delete an existing cluster that does not have Container Insights turned on, and then
         *        create a new cluster with the same name with Container Insights tuned on, Container Insights will not
         *        actually be turned on. If you want to preserve the same name for your existing cluster and turn on
         *        Container Insights, you must wait 7 days before you can re-create it.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(ClusterSetting... settings);

        /**
         * <p>
         * The setting to use by default for a cluster. This parameter is used to turn on CloudWatch Container Insights
         * for a cluster. If this value is specified, it overrides the <code>containerInsights</code> value set with <a
         * href
         * ="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSetting.html">PutAccountSetting</a>
         * or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutAccountSettingDefault.html">
         * PutAccountSettingDefault</a>.
         * </p>
         * <important>
         * <p>
         * Currently, if you delete an existing cluster that does not have Container Insights turned on, and then create
         * a new cluster with the same name with Container Insights tuned on, Container Insights will not actually be
         * turned on. If you want to preserve the same name for your existing cluster and turn on Container Insights,
         * you must wait 7 days before you can re-create it.
         * </p>
         * </important> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecs.model.ClusterSetting.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecs.model.ClusterSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecs.model.ClusterSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(List<ClusterSetting>)}.
         * 
         * @param settings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecs.model.ClusterSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(java.util.Collection<ClusterSetting>)
         */
        Builder settings(Consumer<ClusterSetting.Builder>... settings);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcsRequest.BuilderImpl implements Builder {
        private String cluster;

        private List<ClusterSetting> settings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterSettingsRequest model) {
            super(model);
            cluster(model.cluster);
            settings(model.settings);
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final List<ClusterSetting.Builder> getSettings() {
            List<ClusterSetting.Builder> result = ClusterSettingsCopier.copyToBuilder(this.settings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettings(Collection<ClusterSetting.BuilderImpl> settings) {
            this.settings = ClusterSettingsCopier.copyFromBuilder(settings);
        }

        @Override
        @Transient
        public final Builder settings(Collection<ClusterSetting> settings) {
            this.settings = ClusterSettingsCopier.copy(settings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(ClusterSetting... settings) {
            settings(Arrays.asList(settings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settings(Consumer<ClusterSetting.Builder>... settings) {
            settings(Stream.of(settings).map(c -> ClusterSetting.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterSettingsRequest build() {
            return new UpdateClusterSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
