/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The VPC Lattice configuration for your service that holds the information for the target group(s) Amazon ECS tasks
 * will be registered to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcLatticeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcLatticeConfiguration.Builder, VpcLatticeConfiguration> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(VpcLatticeConfiguration::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> TARGET_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetGroupArn").getter(getter(VpcLatticeConfiguration::targetGroupArn))
            .setter(setter(Builder::targetGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupArn").build()).build();

    private static final SdkField<String> PORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portName").getter(getter(VpcLatticeConfiguration::portName)).setter(setter(Builder::portName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            TARGET_GROUP_ARN_FIELD, PORT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String targetGroupArn;

    private final String portName;

    private VpcLatticeConfiguration(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.targetGroupArn = builder.targetGroupArn;
        this.portName = builder.portName;
    }

    /**
     * <p>
     * The ARN of the IAM role to associate with this VPC Lattice configuration. This is the Amazon ECS&#x2028;
     * infrastructure IAM role that is used to manage your VPC Lattice infrastructure.
     * </p>
     * 
     * @return The ARN of the IAM role to associate with this VPC Lattice configuration. This is the Amazon ECS&#x2028;
     *         infrastructure IAM role that is used to manage your VPC Lattice infrastructure.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The full Amazon Resource Name (ARN) of the target group or groups associated with the VPC Lattice configuration
     * that the Amazon ECS tasks will be registered to.
     * </p>
     * 
     * @return The full Amazon Resource Name (ARN) of the target group or groups associated with the VPC Lattice
     *         configuration that the Amazon ECS tasks will be registered to.
     */
    public final String targetGroupArn() {
        return targetGroupArn;
    }

    /**
     * <p>
     * The name of the port mapping to register in the VPC Lattice target group. This is the name of the
     * <code>portMapping</code> you defined in your task definition.
     * </p>
     * 
     * @return The name of the port mapping to register in the VPC Lattice target group. This is the name of the
     *         <code>portMapping</code> you defined in your task definition.
     */
    public final String portName() {
        return portName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(portName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcLatticeConfiguration)) {
            return false;
        }
        VpcLatticeConfiguration other = (VpcLatticeConfiguration) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(targetGroupArn(), other.targetGroupArn())
                && Objects.equals(portName(), other.portName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcLatticeConfiguration").add("RoleArn", roleArn()).add("TargetGroupArn", targetGroupArn())
                .add("PortName", portName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "targetGroupArn":
            return Optional.ofNullable(clazz.cast(targetGroupArn()));
        case "portName":
            return Optional.ofNullable(clazz.cast(portName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("targetGroupArn", TARGET_GROUP_ARN_FIELD);
        map.put("portName", PORT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcLatticeConfiguration, T> g) {
        return obj -> g.apply((VpcLatticeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcLatticeConfiguration> {
        /**
         * <p>
         * The ARN of the IAM role to associate with this VPC Lattice configuration. This is the Amazon ECS&#x2028;
         * infrastructure IAM role that is used to manage your VPC Lattice infrastructure.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role to associate with this VPC Lattice configuration. This is the Amazon
         *        ECS&#x2028; infrastructure IAM role that is used to manage your VPC Lattice infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The full Amazon Resource Name (ARN) of the target group or groups associated with the VPC Lattice
         * configuration that the Amazon ECS tasks will be registered to.
         * </p>
         * 
         * @param targetGroupArn
         *        The full Amazon Resource Name (ARN) of the target group or groups associated with the VPC Lattice
         *        configuration that the Amazon ECS tasks will be registered to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetGroupArn(String targetGroupArn);

        /**
         * <p>
         * The name of the port mapping to register in the VPC Lattice target group. This is the name of the
         * <code>portMapping</code> you defined in your task definition.
         * </p>
         * 
         * @param portName
         *        The name of the port mapping to register in the VPC Lattice target group. This is the name of the
         *        <code>portMapping</code> you defined in your task definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portName(String portName);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String targetGroupArn;

        private String portName;

        private BuilderImpl() {
        }

        private BuilderImpl(VpcLatticeConfiguration model) {
            roleArn(model.roleArn);
            targetGroupArn(model.targetGroupArn);
            portName(model.portName);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTargetGroupArn() {
            return targetGroupArn;
        }

        public final void setTargetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
        }

        @Override
        public final Builder targetGroupArn(String targetGroupArn) {
            this.targetGroupArn = targetGroupArn;
            return this;
        }

        public final String getPortName() {
            return portName;
        }

        public final void setPortName(String portName) {
            this.portName = portName;
        }

        @Override
        public final Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        @Override
        public VpcLatticeConfiguration build() {
            return new VpcLatticeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
