/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MountPoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MountPoint> {
    private static final SdkField<String> SOURCE_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVolume").getter(MountPoint.getter(MountPoint::sourceVolume)).setter(MountPoint.setter(Builder::sourceVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVolume").build()}).build();
    private static final SdkField<String> CONTAINER_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("containerPath").getter(MountPoint.getter(MountPoint::containerPath)).setter(MountPoint.setter(Builder::containerPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerPath").build()}).build();
    private static final SdkField<Boolean> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("readOnly").getter(MountPoint.getter(MountPoint::readOnly)).setter(MountPoint.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOnly").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_VOLUME_FIELD, CONTAINER_PATH_FIELD, READ_ONLY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MountPoint.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceVolume;
    private final String containerPath;
    private final Boolean readOnly;

    private MountPoint(BuilderImpl builder) {
        this.sourceVolume = builder.sourceVolume;
        this.containerPath = builder.containerPath;
        this.readOnly = builder.readOnly;
    }

    public final String sourceVolume() {
        return this.sourceVolume;
    }

    public final String containerPath() {
        return this.containerPath;
    }

    public final Boolean readOnly() {
        return this.readOnly;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountPoint)) {
            return false;
        }
        MountPoint other = (MountPoint)obj;
        return Objects.equals(this.sourceVolume(), other.sourceVolume()) && Objects.equals(this.containerPath(), other.containerPath()) && Objects.equals(this.readOnly(), other.readOnly());
    }

    public final String toString() {
        return ToString.builder((String)"MountPoint").add("SourceVolume", (Object)this.sourceVolume()).add("ContainerPath", (Object)this.containerPath()).add("ReadOnly", (Object)this.readOnly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceVolume": {
                return Optional.ofNullable(clazz.cast(this.sourceVolume()));
            }
            case "containerPath": {
                return Optional.ofNullable(clazz.cast(this.containerPath()));
            }
            case "readOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceVolume", SOURCE_VOLUME_FIELD);
        map.put("containerPath", CONTAINER_PATH_FIELD);
        map.put("readOnly", READ_ONLY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MountPoint, T> g) {
        return obj -> g.apply((MountPoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceVolume;
        private String containerPath;
        private Boolean readOnly;

        private BuilderImpl() {
        }

        private BuilderImpl(MountPoint model) {
            this.sourceVolume(model.sourceVolume);
            this.containerPath(model.containerPath);
            this.readOnly(model.readOnly);
        }

        public final String getSourceVolume() {
            return this.sourceVolume;
        }

        public final void setSourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
        }

        @Override
        public final Builder sourceVolume(String sourceVolume) {
            this.sourceVolume = sourceVolume;
            return this;
        }

        public final String getContainerPath() {
            return this.containerPath;
        }

        public final void setContainerPath(String containerPath) {
            this.containerPath = containerPath;
        }

        @Override
        public final Builder containerPath(String containerPath) {
            this.containerPath = containerPath;
            return this;
        }

        public final Boolean getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        public final Builder readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public MountPoint build() {
            return new MountPoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MountPoint> {
        public Builder sourceVolume(String var1);

        public Builder containerPath(String var1);

        public Builder readOnly(Boolean var1);
    }
}

