/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a description of a mount target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MountTargetDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<MountTargetDescription.Builder, MountTargetDescription> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(MountTargetDescription::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<String> MOUNT_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MountTargetId").getter(getter(MountTargetDescription::mountTargetId))
            .setter(setter(Builder::mountTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountTargetId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(MountTargetDescription::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(MountTargetDescription::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> LIFE_CYCLE_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LifeCycleState").getter(getter(MountTargetDescription::lifeCycleStateAsString))
            .setter(setter(Builder::lifeCycleState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleState").build()).build();

    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddress").getter(getter(MountTargetDescription::ipAddress)).setter(setter(Builder::ipAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId").getter(getter(MountTargetDescription::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId").getter(getter(MountTargetDescription::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneName").getter(getter(MountTargetDescription::availabilityZoneName))
            .setter(setter(Builder::availabilityZoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneName").build())
            .build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(MountTargetDescription::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            MOUNT_TARGET_ID_FIELD, FILE_SYSTEM_ID_FIELD, SUBNET_ID_FIELD, LIFE_CYCLE_STATE_FIELD, IP_ADDRESS_FIELD,
            NETWORK_INTERFACE_ID_FIELD, AVAILABILITY_ZONE_ID_FIELD, AVAILABILITY_ZONE_NAME_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ownerId;

    private final String mountTargetId;

    private final String fileSystemId;

    private final String subnetId;

    private final String lifeCycleState;

    private final String ipAddress;

    private final String networkInterfaceId;

    private final String availabilityZoneId;

    private final String availabilityZoneName;

    private final String vpcId;

    private MountTargetDescription(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.mountTargetId = builder.mountTargetId;
        this.fileSystemId = builder.fileSystemId;
        this.subnetId = builder.subnetId;
        this.lifeCycleState = builder.lifeCycleState;
        this.ipAddress = builder.ipAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.availabilityZoneName = builder.availabilityZoneName;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Amazon Web Services account ID that owns the resource.
     * </p>
     * 
     * @return Amazon Web Services account ID that owns the resource.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * System-assigned mount target ID.
     * </p>
     * 
     * @return System-assigned mount target ID.
     */
    public final String mountTargetId() {
        return mountTargetId;
    }

    /**
     * <p>
     * The ID of the file system for which the mount target is intended.
     * </p>
     * 
     * @return The ID of the file system for which the mount target is intended.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The ID of the mount target's subnet.
     * </p>
     * 
     * @return The ID of the mount target's subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * Lifecycle state of the mount target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return Lifecycle state of the mount target.
     * @see LifeCycleState
     */
    public final LifeCycleState lifeCycleState() {
        return LifeCycleState.fromValue(lifeCycleState);
    }

    /**
     * <p>
     * Lifecycle state of the mount target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifeCycleState}
     * will return {@link LifeCycleState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #lifeCycleStateAsString}.
     * </p>
     * 
     * @return Lifecycle state of the mount target.
     * @see LifeCycleState
     */
    public final String lifeCycleStateAsString() {
        return lifeCycleState;
    }

    /**
     * <p>
     * Address at which the file system can be mounted by using the mount target.
     * </p>
     * 
     * @return Address at which the file system can be mounted by using the mount target.
     */
    public final String ipAddress() {
        return ipAddress;
    }

    /**
     * <p>
     * The ID of the network interface that Amazon EFS created when it created the mount target.
     * </p>
     * 
     * @return The ID of the network interface that Amazon EFS created when it created the mount target.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The unique and consistent identifier of the Availability Zone that the mount target resides in. For example,
     * <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web
     * Services account.
     * </p>
     * 
     * @return The unique and consistent identifier of the Availability Zone that the mount target resides in. For
     *         example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every
     *         Amazon Web Services account.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The name of the Availability Zone in which the mount target is located. Availability Zones are independently
     * mapped to names for each Amazon Web Services account. For example, the Availability Zone <code>us-east-1a</code>
     * for your Amazon Web Services account might not be the same location as <code>us-east-1a</code> for another Amazon
     * Web Services account.
     * </p>
     * 
     * @return The name of the Availability Zone in which the mount target is located. Availability Zones are
     *         independently mapped to names for each Amazon Web Services account. For example, the Availability Zone
     *         <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as
     *         <code>us-east-1a</code> for another Amazon Web Services account.
     */
    public final String availabilityZoneName() {
        return availabilityZoneName;
    }

    /**
     * <p>
     * The virtual private cloud (VPC) ID that the mount target is configured in.
     * </p>
     * 
     * @return The virtual private cloud (VPC) ID that the mount target is configured in.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(mountTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MountTargetDescription)) {
            return false;
        }
        MountTargetDescription other = (MountTargetDescription) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(mountTargetId(), other.mountTargetId())
                && Objects.equals(fileSystemId(), other.fileSystemId()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(lifeCycleStateAsString(), other.lifeCycleStateAsString())
                && Objects.equals(ipAddress(), other.ipAddress())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(availabilityZoneName(), other.availabilityZoneName()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MountTargetDescription").add("OwnerId", ownerId()).add("MountTargetId", mountTargetId())
                .add("FileSystemId", fileSystemId()).add("SubnetId", subnetId()).add("LifeCycleState", lifeCycleStateAsString())
                .add("IpAddress", ipAddress()).add("NetworkInterfaceId", networkInterfaceId())
                .add("AvailabilityZoneId", availabilityZoneId()).add("AvailabilityZoneName", availabilityZoneName())
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "MountTargetId":
            return Optional.ofNullable(clazz.cast(mountTargetId()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "LifeCycleState":
            return Optional.ofNullable(clazz.cast(lifeCycleStateAsString()));
        case "IpAddress":
            return Optional.ofNullable(clazz.cast(ipAddress()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "AvailabilityZoneName":
            return Optional.ofNullable(clazz.cast(availabilityZoneName()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("MountTargetId", MOUNT_TARGET_ID_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("LifeCycleState", LIFE_CYCLE_STATE_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("AvailabilityZoneName", AVAILABILITY_ZONE_NAME_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MountTargetDescription, T> g) {
        return obj -> g.apply((MountTargetDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MountTargetDescription> {
        /**
         * <p>
         * Amazon Web Services account ID that owns the resource.
         * </p>
         * 
         * @param ownerId
         *        Amazon Web Services account ID that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * System-assigned mount target ID.
         * </p>
         * 
         * @param mountTargetId
         *        System-assigned mount target ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountTargetId(String mountTargetId);

        /**
         * <p>
         * The ID of the file system for which the mount target is intended.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the file system for which the mount target is intended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The ID of the mount target's subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the mount target's subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * Lifecycle state of the mount target.
         * </p>
         * 
         * @param lifeCycleState
         *        Lifecycle state of the mount target.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(String lifeCycleState);

        /**
         * <p>
         * Lifecycle state of the mount target.
         * </p>
         * 
         * @param lifeCycleState
         *        Lifecycle state of the mount target.
         * @see LifeCycleState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifeCycleState
         */
        Builder lifeCycleState(LifeCycleState lifeCycleState);

        /**
         * <p>
         * Address at which the file system can be mounted by using the mount target.
         * </p>
         * 
         * @param ipAddress
         *        Address at which the file system can be mounted by using the mount target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddress(String ipAddress);

        /**
         * <p>
         * The ID of the network interface that Amazon EFS created when it created the mount target.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface that Amazon EFS created when it created the mount target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The unique and consistent identifier of the Availability Zone that the mount target resides in. For example,
         * <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web
         * Services account.
         * </p>
         * 
         * @param availabilityZoneId
         *        The unique and consistent identifier of the Availability Zone that the mount target resides in. For
         *        example, <code>use1-az1</code> is an AZ ID for the us-east-1 Region and it has the same location in
         *        every Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The name of the Availability Zone in which the mount target is located. Availability Zones are independently
         * mapped to names for each Amazon Web Services account. For example, the Availability Zone
         * <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as
         * <code>us-east-1a</code> for another Amazon Web Services account.
         * </p>
         * 
         * @param availabilityZoneName
         *        The name of the Availability Zone in which the mount target is located. Availability Zones are
         *        independently mapped to names for each Amazon Web Services account. For example, the Availability Zone
         *        <code>us-east-1a</code> for your Amazon Web Services account might not be the same location as
         *        <code>us-east-1a</code> for another Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneName(String availabilityZoneName);

        /**
         * <p>
         * The virtual private cloud (VPC) ID that the mount target is configured in.
         * </p>
         * 
         * @param vpcId
         *        The virtual private cloud (VPC) ID that the mount target is configured in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String ownerId;

        private String mountTargetId;

        private String fileSystemId;

        private String subnetId;

        private String lifeCycleState;

        private String ipAddress;

        private String networkInterfaceId;

        private String availabilityZoneId;

        private String availabilityZoneName;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(MountTargetDescription model) {
            ownerId(model.ownerId);
            mountTargetId(model.mountTargetId);
            fileSystemId(model.fileSystemId);
            subnetId(model.subnetId);
            lifeCycleState(model.lifeCycleState);
            ipAddress(model.ipAddress);
            networkInterfaceId(model.networkInterfaceId);
            availabilityZoneId(model.availabilityZoneId);
            availabilityZoneName(model.availabilityZoneName);
            vpcId(model.vpcId);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getMountTargetId() {
            return mountTargetId;
        }

        public final void setMountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
        }

        @Override
        public final Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getLifeCycleState() {
            return lifeCycleState;
        }

        public final void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        @Override
        public final Builder lifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
            return this;
        }

        @Override
        public final Builder lifeCycleState(LifeCycleState lifeCycleState) {
            this.lifeCycleState(lifeCycleState == null ? null : lifeCycleState.toString());
            return this;
        }

        public final String getIpAddress() {
            return ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getAvailabilityZoneName() {
            return availabilityZoneName;
        }

        public final void setAvailabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
        }

        @Override
        public final Builder availabilityZoneName(String availabilityZoneName) {
            this.availabilityZoneName = availabilityZoneName;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public MountTargetDescription build() {
            return new MountTargetDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
