/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.efs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the resource type and its ID preference for the user's Amazon Web Services account, in the current Amazon
 * Web Services Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceIdPreference implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceIdPreference.Builder, ResourceIdPreference> {
    private static final SdkField<String> RESOURCE_ID_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdType").getter(getter(ResourceIdPreference::resourceIdTypeAsString))
            .setter(setter(Builder::resourceIdType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdType").build()).build();

    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Resources")
            .getter(getter(ResourceIdPreference::resourcesAsStrings))
            .setter(setter(Builder::resourcesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_TYPE_FIELD,
            RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceIdType;

    private final List<String> resources;

    private ResourceIdPreference(BuilderImpl builder) {
        this.resourceIdType = builder.resourceIdType;
        this.resources = builder.resources;
    }

    /**
     * <p>
     * Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or <code>SHORT_ID</code>
     * (8 characters).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceIdType}
     * will return {@link ResourceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceIdTypeAsString}.
     * </p>
     * 
     * @return Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or
     *         <code>SHORT_ID</code> (8 characters).
     * @see ResourceIdType
     */
    public final ResourceIdType resourceIdType() {
        return ResourceIdType.fromValue(resourceIdType);
    }

    /**
     * <p>
     * Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or <code>SHORT_ID</code>
     * (8 characters).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceIdType}
     * will return {@link ResourceIdType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceIdTypeAsString}.
     * </p>
     * 
     * @return Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or
     *         <code>SHORT_ID</code> (8 characters).
     * @see ResourceIdType
     */
    public final String resourceIdTypeAsString() {
        return resourceIdType;
    }

    /**
     * <p>
     * Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and
     * <code>MOUNT_TARGET</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code>
     *         and <code>MOUNT_TARGET</code>.
     */
    public final List<Resource> resources() {
        return ResourcesCopier.copyStringToEnum(resources);
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and
     * <code>MOUNT_TARGET</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code>
     *         and <code>MOUNT_TARGET</code>.
     */
    public final List<String> resourcesAsStrings() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resourcesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceIdPreference)) {
            return false;
        }
        ResourceIdPreference other = (ResourceIdPreference) obj;
        return Objects.equals(resourceIdTypeAsString(), other.resourceIdTypeAsString()) && hasResources() == other.hasResources()
                && Objects.equals(resourcesAsStrings(), other.resourcesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceIdPreference").add("ResourceIdType", resourceIdTypeAsString())
                .add("Resources", hasResources() ? resourcesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceIdType":
            return Optional.ofNullable(clazz.cast(resourceIdTypeAsString()));
        case "Resources":
            return Optional.ofNullable(clazz.cast(resourcesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceIdType", RESOURCE_ID_TYPE_FIELD);
        map.put("Resources", RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceIdPreference, T> g) {
        return obj -> g.apply((ResourceIdPreference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceIdPreference> {
        /**
         * <p>
         * Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or
         * <code>SHORT_ID</code> (8 characters).
         * </p>
         * 
         * @param resourceIdType
         *        Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or
         *        <code>SHORT_ID</code> (8 characters).
         * @see ResourceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceIdType
         */
        Builder resourceIdType(String resourceIdType);

        /**
         * <p>
         * Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or
         * <code>SHORT_ID</code> (8 characters).
         * </p>
         * 
         * @param resourceIdType
         *        Identifies the EFS resource ID preference, either <code>LONG_ID</code> (17 characters) or
         *        <code>SHORT_ID</code> (8 characters).
         * @see ResourceIdType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceIdType
         */
        Builder resourceIdType(ResourceIdType resourceIdType);

        /**
         * <p>
         * Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and
         * <code>MOUNT_TARGET</code>.
         * </p>
         * 
         * @param resources
         *        Identifies the Amazon EFS resources to which the ID preference setting applies,
         *        <code>FILE_SYSTEM</code> and <code>MOUNT_TARGET</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesWithStrings(Collection<String> resources);

        /**
         * <p>
         * Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and
         * <code>MOUNT_TARGET</code>.
         * </p>
         * 
         * @param resources
         *        Identifies the Amazon EFS resources to which the ID preference setting applies,
         *        <code>FILE_SYSTEM</code> and <code>MOUNT_TARGET</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesWithStrings(String... resources);

        /**
         * <p>
         * Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and
         * <code>MOUNT_TARGET</code>.
         * </p>
         * 
         * @param resources
         *        Identifies the Amazon EFS resources to which the ID preference setting applies,
         *        <code>FILE_SYSTEM</code> and <code>MOUNT_TARGET</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<Resource> resources);

        /**
         * <p>
         * Identifies the Amazon EFS resources to which the ID preference setting applies, <code>FILE_SYSTEM</code> and
         * <code>MOUNT_TARGET</code>.
         * </p>
         * 
         * @param resources
         *        Identifies the Amazon EFS resources to which the ID preference setting applies,
         *        <code>FILE_SYSTEM</code> and <code>MOUNT_TARGET</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Resource... resources);
    }

    static final class BuilderImpl implements Builder {
        private String resourceIdType;

        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceIdPreference model) {
            resourceIdType(model.resourceIdType);
            resourcesWithStrings(model.resources);
        }

        public final String getResourceIdType() {
            return resourceIdType;
        }

        public final void setResourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
        }

        @Override
        public final Builder resourceIdType(String resourceIdType) {
            this.resourceIdType = resourceIdType;
            return this;
        }

        @Override
        public final Builder resourceIdType(ResourceIdType resourceIdType) {
            this.resourceIdType(resourceIdType == null ? null : resourceIdType.toString());
            return this;
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
        }

        @Override
        public final Builder resourcesWithStrings(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourcesWithStrings(String... resources) {
            resourcesWithStrings(Arrays.asList(resources));
            return this;
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourcesCopier.copyEnumToString(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        public ResourceIdPreference build() {
            return new ResourceIdPreference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
