/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkAsyncClient;
import software.amazon.awssdk.services.elasticbeanstalk.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentsResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ElasticBeanstalkRequest;
import software.amazon.awssdk.services.elasticbeanstalk.waiters.ElasticBeanstalkAsyncWaiter;
import software.amazon.awssdk.services.elasticbeanstalk.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultElasticBeanstalkAsyncWaiter
implements ElasticBeanstalkAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final ElasticBeanstalkAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeEnvironmentsResponse> environmentExistsWaiter;
    private final AsyncWaiter<DescribeEnvironmentsResponse> environmentUpdatedWaiter;
    private final AsyncWaiter<DescribeEnvironmentsResponse> environmentTerminatedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultElasticBeanstalkAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ElasticBeanstalkAsyncClient)ElasticBeanstalkAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.environmentExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeEnvironmentsResponse.class).acceptors(DefaultElasticBeanstalkAsyncWaiter.environmentExistsWaiterAcceptors())).overrideConfiguration(DefaultElasticBeanstalkAsyncWaiter.environmentExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.environmentUpdatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeEnvironmentsResponse.class).acceptors(DefaultElasticBeanstalkAsyncWaiter.environmentUpdatedWaiterAcceptors())).overrideConfiguration(DefaultElasticBeanstalkAsyncWaiter.environmentUpdatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.environmentTerminatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeEnvironmentsResponse.class).acceptors(DefaultElasticBeanstalkAsyncWaiter.environmentTerminatedWaiterAcceptors())).overrideConfiguration(DefaultElasticBeanstalkAsyncWaiter.environmentTerminatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEnvironmentsResponse>> waitUntilEnvironmentExists(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        return this.environmentExistsWaiter.runAsync(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEnvironmentsResponse>> waitUntilEnvironmentExists(DescribeEnvironmentsRequest describeEnvironmentsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentExistsWaiter.runAsync(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)), DefaultElasticBeanstalkAsyncWaiter.environmentExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEnvironmentsResponse>> waitUntilEnvironmentTerminated(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        return this.environmentTerminatedWaiter.runAsync(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEnvironmentsResponse>> waitUntilEnvironmentTerminated(DescribeEnvironmentsRequest describeEnvironmentsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentTerminatedWaiter.runAsync(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)), DefaultElasticBeanstalkAsyncWaiter.environmentTerminatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEnvironmentsResponse>> waitUntilEnvironmentUpdated(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        return this.environmentUpdatedWaiter.runAsync(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeEnvironmentsResponse>> waitUntilEnvironmentUpdated(DescribeEnvironmentsRequest describeEnvironmentsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.environmentUpdatedWaiter.runAsync(() -> this.client.describeEnvironments(this.applyWaitersUserAgent(describeEnvironmentsRequest)), DefaultElasticBeanstalkAsyncWaiter.environmentUpdatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeEnvironmentsResponse>> environmentExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Ready"));
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Launching"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEnvironmentsResponse>> environmentUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Ready"));
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Updating"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeEnvironmentsResponse>> environmentTerminatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeEnvironmentsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Terminated"));
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Environments").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Terminating"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration environmentExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration environmentUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration environmentTerminatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ElasticBeanstalkAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ElasticBeanstalkRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticBeanstalkRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ElasticBeanstalkAsyncWaiter.Builder {
        private ElasticBeanstalkAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public ElasticBeanstalkAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ElasticBeanstalkAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ElasticBeanstalkAsyncWaiter.Builder client(ElasticBeanstalkAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ElasticBeanstalkAsyncWaiter build() {
            return new DefaultElasticBeanstalkAsyncWaiter(this);
        }
    }
}

