/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticbeanstalk.ElasticBeanstalkAsyncClient;
import software.amazon.awssdk.services.elasticbeanstalk.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryRequest;
import software.amazon.awssdk.services.elasticbeanstalk.model.DescribeEnvironmentManagedActionHistoryResponse;
import software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem;

public class DescribeEnvironmentManagedActionHistoryPublisher
implements SdkPublisher<DescribeEnvironmentManagedActionHistoryResponse> {
    private final ElasticBeanstalkAsyncClient client;
    private final DescribeEnvironmentManagedActionHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEnvironmentManagedActionHistoryPublisher(ElasticBeanstalkAsyncClient client, DescribeEnvironmentManagedActionHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEnvironmentManagedActionHistoryPublisher(ElasticBeanstalkAsyncClient client, DescribeEnvironmentManagedActionHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEnvironmentManagedActionHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEnvironmentManagedActionHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedActionHistoryItem> managedActionHistoryItems() {
        Function<DescribeEnvironmentManagedActionHistoryResponse, Iterator> getIterator = response -> {
            if (response != null && response.managedActionHistoryItems() != null) {
                return response.managedActionHistoryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEnvironmentManagedActionHistoryResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEnvironmentManagedActionHistoryResponseFetcher
    implements AsyncPageFetcher<DescribeEnvironmentManagedActionHistoryResponse> {
        private DescribeEnvironmentManagedActionHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEnvironmentManagedActionHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEnvironmentManagedActionHistoryResponse> nextPage(DescribeEnvironmentManagedActionHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeEnvironmentManagedActionHistoryPublisher.this.client.describeEnvironmentManagedActionHistory(DescribeEnvironmentManagedActionHistoryPublisher.this.firstRequest);
            }
            return DescribeEnvironmentManagedActionHistoryPublisher.this.client.describeEnvironmentManagedActionHistory((DescribeEnvironmentManagedActionHistoryRequest)((Object)DescribeEnvironmentManagedActionHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

