/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.EventSeverity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventDescription> {
    private static final SdkField<Instant> EVENT_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventDate").getter(EventDescription.getter(EventDescription::eventDate)).setter(EventDescription.setter(Builder::eventDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDate").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(EventDescription.getter(EventDescription::message)).setter(EventDescription.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationName").getter(EventDescription.getter(EventDescription::applicationName)).setter(EventDescription.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationName").build()}).build();
    private static final SdkField<String> VERSION_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VersionLabel").getter(EventDescription.getter(EventDescription::versionLabel)).setter(EventDescription.setter(Builder::versionLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionLabel").build()}).build();
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(EventDescription.getter(EventDescription::templateName)).setter(EventDescription.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<String> ENVIRONMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnvironmentName").getter(EventDescription.getter(EventDescription::environmentName)).setter(EventDescription.setter(Builder::environmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentName").build()}).build();
    private static final SdkField<String> PLATFORM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformArn").getter(EventDescription.getter(EventDescription::platformArn)).setter(EventDescription.setter(Builder::platformArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformArn").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(EventDescription.getter(EventDescription::requestId)).setter(EventDescription.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(EventDescription.getter(EventDescription::severityAsString)).setter(EventDescription.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATE_FIELD, MESSAGE_FIELD, APPLICATION_NAME_FIELD, VERSION_LABEL_FIELD, TEMPLATE_NAME_FIELD, ENVIRONMENT_NAME_FIELD, PLATFORM_ARN_FIELD, REQUEST_ID_FIELD, SEVERITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EventDate", EVENT_DATE_FIELD);
            this.put("Message", MESSAGE_FIELD);
            this.put("ApplicationName", APPLICATION_NAME_FIELD);
            this.put("VersionLabel", VERSION_LABEL_FIELD);
            this.put("TemplateName", TEMPLATE_NAME_FIELD);
            this.put("EnvironmentName", ENVIRONMENT_NAME_FIELD);
            this.put("PlatformArn", PLATFORM_ARN_FIELD);
            this.put("RequestId", REQUEST_ID_FIELD);
            this.put("Severity", SEVERITY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant eventDate;
    private final String message;
    private final String applicationName;
    private final String versionLabel;
    private final String templateName;
    private final String environmentName;
    private final String platformArn;
    private final String requestId;
    private final String severity;

    private EventDescription(BuilderImpl builder) {
        this.eventDate = builder.eventDate;
        this.message = builder.message;
        this.applicationName = builder.applicationName;
        this.versionLabel = builder.versionLabel;
        this.templateName = builder.templateName;
        this.environmentName = builder.environmentName;
        this.platformArn = builder.platformArn;
        this.requestId = builder.requestId;
        this.severity = builder.severity;
    }

    public final Instant eventDate() {
        return this.eventDate;
    }

    public final String message() {
        return this.message;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String versionLabel() {
        return this.versionLabel;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final String environmentName() {
        return this.environmentName;
    }

    public final String platformArn() {
        return this.platformArn;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final EventSeverity severity() {
        return EventSeverity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventDescription)) {
            return false;
        }
        EventDescription other = (EventDescription)obj;
        return Objects.equals(this.eventDate(), other.eventDate()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.versionLabel(), other.versionLabel()) && Objects.equals(this.templateName(), other.templateName()) && Objects.equals(this.environmentName(), other.environmentName()) && Objects.equals(this.platformArn(), other.platformArn()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.severityAsString(), other.severityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EventDescription").add("EventDate", (Object)this.eventDate()).add("Message", (Object)this.message()).add("ApplicationName", (Object)this.applicationName()).add("VersionLabel", (Object)this.versionLabel()).add("TemplateName", (Object)this.templateName()).add("EnvironmentName", (Object)this.environmentName()).add("PlatformArn", (Object)this.platformArn()).add("RequestId", (Object)this.requestId()).add("Severity", (Object)this.severityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDate": {
                return Optional.ofNullable(clazz.cast(this.eventDate()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "ApplicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "VersionLabel": {
                return Optional.ofNullable(clazz.cast(this.versionLabel()));
            }
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "EnvironmentName": {
                return Optional.ofNullable(clazz.cast(this.environmentName()));
            }
            case "PlatformArn": {
                return Optional.ofNullable(clazz.cast(this.platformArn()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EventDescription, T> g) {
        return obj -> g.apply((EventDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant eventDate;
        private String message;
        private String applicationName;
        private String versionLabel;
        private String templateName;
        private String environmentName;
        private String platformArn;
        private String requestId;
        private String severity;

        private BuilderImpl() {
        }

        private BuilderImpl(EventDescription model) {
            this.eventDate(model.eventDate);
            this.message(model.message);
            this.applicationName(model.applicationName);
            this.versionLabel(model.versionLabel);
            this.templateName(model.templateName);
            this.environmentName(model.environmentName);
            this.platformArn(model.platformArn);
            this.requestId(model.requestId);
            this.severity(model.severity);
        }

        public final Instant getEventDate() {
            return this.eventDate;
        }

        public final void setEventDate(Instant eventDate) {
            this.eventDate = eventDate;
        }

        @Override
        public final Builder eventDate(Instant eventDate) {
            this.eventDate = eventDate;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getVersionLabel() {
            return this.versionLabel;
        }

        public final void setVersionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
        }

        @Override
        public final Builder versionLabel(String versionLabel) {
            this.versionLabel = versionLabel;
            return this;
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final String getEnvironmentName() {
            return this.environmentName;
        }

        public final void setEnvironmentName(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public final Builder environmentName(String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        public final String getPlatformArn() {
            return this.platformArn;
        }

        public final void setPlatformArn(String platformArn) {
            this.platformArn = platformArn;
        }

        @Override
        public final Builder platformArn(String platformArn) {
            this.platformArn = platformArn;
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(EventSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public EventDescription build() {
            return new EventDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventDescription> {
        public Builder eventDate(Instant var1);

        public Builder message(String var1);

        public Builder applicationName(String var1);

        public Builder versionLabel(String var1);

        public Builder templateName(String var1);

        public Builder environmentName(String var1);

        public Builder platformArn(String var1);

        public Builder requestId(String var1);

        public Builder severity(String var1);

        public Builder severity(EventSeverity var1);
    }
}

