/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticbeanstalk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentInfoDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentInfoDescription> {
    private static final SdkField<String> INFO_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InfoType").getter(EnvironmentInfoDescription.getter(EnvironmentInfoDescription::infoTypeAsString)).setter(EnvironmentInfoDescription.setter(Builder::infoType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfoType").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ec2InstanceId").getter(EnvironmentInfoDescription.getter(EnvironmentInfoDescription::ec2InstanceId)).setter(EnvironmentInfoDescription.setter(Builder::ec2InstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()}).build();
    private static final SdkField<Instant> SAMPLE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("SampleTimestamp").getter(EnvironmentInfoDescription.getter(EnvironmentInfoDescription::sampleTimestamp)).setter(EnvironmentInfoDescription.setter(Builder::sampleTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleTimestamp").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(EnvironmentInfoDescription.getter(EnvironmentInfoDescription::message)).setter(EnvironmentInfoDescription.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFO_TYPE_FIELD, EC2_INSTANCE_ID_FIELD, SAMPLE_TIMESTAMP_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InfoType", INFO_TYPE_FIELD);
            this.put("Ec2InstanceId", EC2_INSTANCE_ID_FIELD);
            this.put("SampleTimestamp", SAMPLE_TIMESTAMP_FIELD);
            this.put("Message", MESSAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String infoType;
    private final String ec2InstanceId;
    private final Instant sampleTimestamp;
    private final String message;

    private EnvironmentInfoDescription(BuilderImpl builder) {
        this.infoType = builder.infoType;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.sampleTimestamp = builder.sampleTimestamp;
        this.message = builder.message;
    }

    public final EnvironmentInfoType infoType() {
        return EnvironmentInfoType.fromValue(this.infoType);
    }

    public final String infoTypeAsString() {
        return this.infoType;
    }

    public final String ec2InstanceId() {
        return this.ec2InstanceId;
    }

    public final Instant sampleTimestamp() {
        return this.sampleTimestamp;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.infoTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentInfoDescription)) {
            return false;
        }
        EnvironmentInfoDescription other = (EnvironmentInfoDescription)obj;
        return Objects.equals(this.infoTypeAsString(), other.infoTypeAsString()) && Objects.equals(this.ec2InstanceId(), other.ec2InstanceId()) && Objects.equals(this.sampleTimestamp(), other.sampleTimestamp()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentInfoDescription").add("InfoType", (Object)this.infoTypeAsString()).add("Ec2InstanceId", (Object)this.ec2InstanceId()).add("SampleTimestamp", (Object)this.sampleTimestamp()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InfoType": {
                return Optional.ofNullable(clazz.cast(this.infoTypeAsString()));
            }
            case "Ec2InstanceId": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceId()));
            }
            case "SampleTimestamp": {
                return Optional.ofNullable(clazz.cast(this.sampleTimestamp()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentInfoDescription, T> g) {
        return obj -> g.apply((EnvironmentInfoDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String infoType;
        private String ec2InstanceId;
        private Instant sampleTimestamp;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentInfoDescription model) {
            this.infoType(model.infoType);
            this.ec2InstanceId(model.ec2InstanceId);
            this.sampleTimestamp(model.sampleTimestamp);
            this.message(model.message);
        }

        public final String getInfoType() {
            return this.infoType;
        }

        public final void setInfoType(String infoType) {
            this.infoType = infoType;
        }

        @Override
        public final Builder infoType(String infoType) {
            this.infoType = infoType;
            return this;
        }

        @Override
        public final Builder infoType(EnvironmentInfoType infoType) {
            this.infoType(infoType == null ? null : infoType.toString());
            return this;
        }

        public final String getEc2InstanceId() {
            return this.ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final Instant getSampleTimestamp() {
            return this.sampleTimestamp;
        }

        public final void setSampleTimestamp(Instant sampleTimestamp) {
            this.sampleTimestamp = sampleTimestamp;
        }

        @Override
        public final Builder sampleTimestamp(Instant sampleTimestamp) {
            this.sampleTimestamp = sampleTimestamp;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public EnvironmentInfoDescription build() {
            return new EnvironmentInfoDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentInfoDescription> {
        public Builder infoType(String var1);

        public Builder infoType(EnvironmentInfoType var1);

        public Builder ec2InstanceId(String var1);

        public Builder sampleTimestamp(Instant var1);

        public Builder message(String var1);
    }
}

