/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.entityresolution.model.IntermediateSourceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProviderProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProviderProperties> {
    private static final SdkField<IntermediateSourceConfiguration> INTERMEDIATE_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("intermediateSourceConfiguration").getter(ProviderProperties.getter(ProviderProperties::intermediateSourceConfiguration)).setter(ProviderProperties.setter(Builder::intermediateSourceConfiguration)).constructor(IntermediateSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intermediateSourceConfiguration").build()}).build();
    private static final SdkField<Document> PROVIDER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("providerConfiguration").getter(ProviderProperties.getter(ProviderProperties::providerConfiguration)).setter(ProviderProperties.setter(Builder::providerConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerConfiguration").build()}).build();
    private static final SdkField<String> PROVIDER_SERVICE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerServiceArn").getter(ProviderProperties.getter(ProviderProperties::providerServiceArn)).setter(ProviderProperties.setter(Builder::providerServiceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERMEDIATE_SOURCE_CONFIGURATION_FIELD, PROVIDER_CONFIGURATION_FIELD, PROVIDER_SERVICE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final IntermediateSourceConfiguration intermediateSourceConfiguration;
    private final Document providerConfiguration;
    private final String providerServiceArn;

    private ProviderProperties(BuilderImpl builder) {
        this.intermediateSourceConfiguration = builder.intermediateSourceConfiguration;
        this.providerConfiguration = builder.providerConfiguration;
        this.providerServiceArn = builder.providerServiceArn;
    }

    public final IntermediateSourceConfiguration intermediateSourceConfiguration() {
        return this.intermediateSourceConfiguration;
    }

    public final Document providerConfiguration() {
        return this.providerConfiguration;
    }

    public final String providerServiceArn() {
        return this.providerServiceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.intermediateSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerServiceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderProperties)) {
            return false;
        }
        ProviderProperties other = (ProviderProperties)obj;
        return Objects.equals(this.intermediateSourceConfiguration(), other.intermediateSourceConfiguration()) && Objects.equals(this.providerConfiguration(), other.providerConfiguration()) && Objects.equals(this.providerServiceArn(), other.providerServiceArn());
    }

    public final String toString() {
        return ToString.builder((String)"ProviderProperties").add("IntermediateSourceConfiguration", (Object)this.intermediateSourceConfiguration()).add("ProviderConfiguration", (Object)this.providerConfiguration()).add("ProviderServiceArn", (Object)this.providerServiceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "intermediateSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.intermediateSourceConfiguration()));
            }
            case "providerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.providerConfiguration()));
            }
            case "providerServiceArn": {
                return Optional.ofNullable(clazz.cast(this.providerServiceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProviderProperties, T> g) {
        return obj -> g.apply((ProviderProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IntermediateSourceConfiguration intermediateSourceConfiguration;
        private Document providerConfiguration;
        private String providerServiceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderProperties model) {
            this.intermediateSourceConfiguration(model.intermediateSourceConfiguration);
            this.providerConfiguration(model.providerConfiguration);
            this.providerServiceArn(model.providerServiceArn);
        }

        public final IntermediateSourceConfiguration.Builder getIntermediateSourceConfiguration() {
            return this.intermediateSourceConfiguration != null ? this.intermediateSourceConfiguration.toBuilder() : null;
        }

        public final void setIntermediateSourceConfiguration(IntermediateSourceConfiguration.BuilderImpl intermediateSourceConfiguration) {
            this.intermediateSourceConfiguration = intermediateSourceConfiguration != null ? intermediateSourceConfiguration.build() : null;
        }

        @Override
        public final Builder intermediateSourceConfiguration(IntermediateSourceConfiguration intermediateSourceConfiguration) {
            this.intermediateSourceConfiguration = intermediateSourceConfiguration;
            return this;
        }

        public final Document getProviderConfiguration() {
            return this.providerConfiguration;
        }

        public final void setProviderConfiguration(Document providerConfiguration) {
            this.providerConfiguration = providerConfiguration;
        }

        @Override
        public final Builder providerConfiguration(Document providerConfiguration) {
            this.providerConfiguration = providerConfiguration;
            return this;
        }

        public final String getProviderServiceArn() {
            return this.providerServiceArn;
        }

        public final void setProviderServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
        }

        @Override
        public final Builder providerServiceArn(String providerServiceArn) {
            this.providerServiceArn = providerServiceArn;
            return this;
        }

        public ProviderProperties build() {
            return new ProviderProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProviderProperties> {
        public Builder intermediateSourceConfiguration(IntermediateSourceConfiguration var1);

        default public Builder intermediateSourceConfiguration(Consumer<IntermediateSourceConfiguration.Builder> intermediateSourceConfiguration) {
            return this.intermediateSourceConfiguration((IntermediateSourceConfiguration)((IntermediateSourceConfiguration.Builder)IntermediateSourceConfiguration.builder().applyMutation(intermediateSourceConfiguration)).build());
        }

        public Builder providerConfiguration(Document var1);

        public Builder providerServiceArn(String var1);
    }
}

