/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.entityresolution.EntityResolutionAsyncClient;
import software.amazon.awssdk.services.entityresolution.internal.UserAgentUtils;
import software.amazon.awssdk.services.entityresolution.model.JobSummary;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsRequest;
import software.amazon.awssdk.services.entityresolution.model.ListMatchingJobsResponse;

public class ListMatchingJobsPublisher
implements SdkPublisher<ListMatchingJobsResponse> {
    private final EntityResolutionAsyncClient client;
    private final ListMatchingJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMatchingJobsPublisher(EntityResolutionAsyncClient client, ListMatchingJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMatchingJobsPublisher(EntityResolutionAsyncClient client, ListMatchingJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMatchingJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMatchingJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobSummary> jobs() {
        Function<ListMatchingJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobs() != null) {
                return response.jobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMatchingJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMatchingJobsResponseFetcher
    implements AsyncPageFetcher<ListMatchingJobsResponse> {
        private ListMatchingJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMatchingJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMatchingJobsResponse> nextPage(ListMatchingJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMatchingJobsPublisher.this.client.listMatchingJobs(ListMatchingJobsPublisher.this.firstRequest);
            }
            return ListMatchingJobsPublisher.this.client.listMatchingJobs((ListMatchingJobsRequest)((Object)ListMatchingJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

