/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.ErrorDetails;
import software.amazon.awssdk.services.entityresolution.model.IdMappingJobMetrics;
import software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSource;
import software.amazon.awssdk.services.entityresolution.model.IdMappingJobOutputSourceConfigCopier;
import software.amazon.awssdk.services.entityresolution.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIdMappingJobResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, GetIdMappingJobResponse> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(GetIdMappingJobResponse.getter(GetIdMappingJobResponse::endTime)).setter(GetIdMappingJobResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorDetails").getter(GetIdMappingJobResponse.getter(GetIdMappingJobResponse::errorDetails)).setter(GetIdMappingJobResponse.setter(Builder::errorDetails)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(GetIdMappingJobResponse.getter(GetIdMappingJobResponse::jobId)).setter(GetIdMappingJobResponse.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<IdMappingJobMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metrics").getter(GetIdMappingJobResponse.getter(GetIdMappingJobResponse::metrics)).setter(GetIdMappingJobResponse.setter(Builder::metrics)).constructor(IdMappingJobMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build()}).build();
    private static final SdkField<List<IdMappingJobOutputSource>> OUTPUT_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputSourceConfig").getter(GetIdMappingJobResponse.getter(GetIdMappingJobResponse::outputSourceConfig)).setter(GetIdMappingJobResponse.setter(Builder::outputSourceConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSourceConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IdMappingJobOutputSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(GetIdMappingJobResponse.getter(GetIdMappingJobResponse::startTime)).setter(GetIdMappingJobResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetIdMappingJobResponse.getter(GetIdMappingJobResponse::statusAsString)).setter(GetIdMappingJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD, ERROR_DETAILS_FIELD, JOB_ID_FIELD, METRICS_FIELD, OUTPUT_SOURCE_CONFIG_FIELD, START_TIME_FIELD, STATUS_FIELD));
    private final Instant endTime;
    private final ErrorDetails errorDetails;
    private final String jobId;
    private final IdMappingJobMetrics metrics;
    private final List<IdMappingJobOutputSource> outputSourceConfig;
    private final Instant startTime;
    private final String status;

    private GetIdMappingJobResponse(BuilderImpl builder) {
        super(builder);
        this.endTime = builder.endTime;
        this.errorDetails = builder.errorDetails;
        this.jobId = builder.jobId;
        this.metrics = builder.metrics;
        this.outputSourceConfig = builder.outputSourceConfig;
        this.startTime = builder.startTime;
        this.status = builder.status;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final IdMappingJobMetrics metrics() {
        return this.metrics;
    }

    public final boolean hasOutputSourceConfig() {
        return this.outputSourceConfig != null && !(this.outputSourceConfig instanceof SdkAutoConstructList);
    }

    public final List<IdMappingJobOutputSource> outputSourceConfig() {
        return this.outputSourceConfig;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputSourceConfig() ? this.outputSourceConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdMappingJobResponse)) {
            return false;
        }
        GetIdMappingJobResponse other = (GetIdMappingJobResponse)((Object)obj);
        return Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorDetails(), other.errorDetails()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.metrics(), other.metrics()) && this.hasOutputSourceConfig() == other.hasOutputSourceConfig() && Objects.equals(this.outputSourceConfig(), other.outputSourceConfig()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetIdMappingJobResponse").add("EndTime", (Object)this.endTime()).add("ErrorDetails", (Object)this.errorDetails()).add("JobId", (Object)this.jobId()).add("Metrics", (Object)this.metrics()).add("OutputSourceConfig", this.hasOutputSourceConfig() ? this.outputSourceConfig() : null).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "errorDetails": {
                return Optional.ofNullable(clazz.cast(this.errorDetails()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "outputSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.outputSourceConfig()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdMappingJobResponse, T> g) {
        return obj -> g.apply((GetIdMappingJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private Instant endTime;
        private ErrorDetails errorDetails;
        private String jobId;
        private IdMappingJobMetrics metrics;
        private List<IdMappingJobOutputSource> outputSourceConfig = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdMappingJobResponse model) {
            super(model);
            this.endTime(model.endTime);
            this.errorDetails(model.errorDetails);
            this.jobId(model.jobId);
            this.metrics(model.metrics);
            this.outputSourceConfig(model.outputSourceConfig);
            this.startTime(model.startTime);
            this.status(model.status);
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return this.errorDetails != null ? this.errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final IdMappingJobMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(IdMappingJobMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(IdMappingJobMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final List<IdMappingJobOutputSource.Builder> getOutputSourceConfig() {
            List<IdMappingJobOutputSource.Builder> result = IdMappingJobOutputSourceConfigCopier.copyToBuilder(this.outputSourceConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputSourceConfig(Collection<IdMappingJobOutputSource.BuilderImpl> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copyFromBuilder(outputSourceConfig);
        }

        @Override
        public final Builder outputSourceConfig(Collection<IdMappingJobOutputSource> outputSourceConfig) {
            this.outputSourceConfig = IdMappingJobOutputSourceConfigCopier.copy(outputSourceConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(IdMappingJobOutputSource ... outputSourceConfig) {
            this.outputSourceConfig(Arrays.asList(outputSourceConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder> ... outputSourceConfig) {
            this.outputSourceConfig(Stream.of(outputSourceConfig).map(c -> (IdMappingJobOutputSource)((IdMappingJobOutputSource.Builder)IdMappingJobOutputSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetIdMappingJobResponse build() {
            return new GetIdMappingJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIdMappingJobResponse> {
        public Builder endTime(Instant var1);

        public Builder errorDetails(ErrorDetails var1);

        default public Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return this.errorDetails((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(errorDetails)).build());
        }

        public Builder jobId(String var1);

        public Builder metrics(IdMappingJobMetrics var1);

        default public Builder metrics(Consumer<IdMappingJobMetrics.Builder> metrics) {
            return this.metrics((IdMappingJobMetrics)((IdMappingJobMetrics.Builder)IdMappingJobMetrics.builder().applyMutation(metrics)).build());
        }

        public Builder outputSourceConfig(Collection<IdMappingJobOutputSource> var1);

        public Builder outputSourceConfig(IdMappingJobOutputSource ... var1);

        public Builder outputSourceConfig(Consumer<IdMappingJobOutputSource.Builder> ... var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);
    }
}

