/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.AttributeMatchingModel;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowRuleDefinitionType;
import software.amazon.awssdk.services.entityresolution.model.IdMappingWorkflowRuleDefinitionTypeListCopier;
import software.amazon.awssdk.services.entityresolution.model.NamespaceRuleBasedPropertiesRulesListCopier;
import software.amazon.awssdk.services.entityresolution.model.RecordMatchingModel;
import software.amazon.awssdk.services.entityresolution.model.RecordMatchingModelListCopier;
import software.amazon.awssdk.services.entityresolution.model.Rule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NamespaceRuleBasedProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NamespaceRuleBasedProperties> {
    private static final SdkField<String> ATTRIBUTE_MATCHING_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeMatchingModel").getter(NamespaceRuleBasedProperties.getter(NamespaceRuleBasedProperties::attributeMatchingModelAsString)).setter(NamespaceRuleBasedProperties.setter(Builder::attributeMatchingModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMatchingModel").build()}).build();
    private static final SdkField<List<String>> RECORD_MATCHING_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recordMatchingModels").getter(NamespaceRuleBasedProperties.getter(NamespaceRuleBasedProperties::recordMatchingModelsAsStrings)).setter(NamespaceRuleBasedProperties.setter(Builder::recordMatchingModelsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordMatchingModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RULE_DEFINITION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleDefinitionTypes").getter(NamespaceRuleBasedProperties.getter(NamespaceRuleBasedProperties::ruleDefinitionTypesAsStrings)).setter(NamespaceRuleBasedProperties.setter(Builder::ruleDefinitionTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleDefinitionTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(NamespaceRuleBasedProperties.getter(NamespaceRuleBasedProperties::rules)).setter(NamespaceRuleBasedProperties.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_MATCHING_MODEL_FIELD, RECORD_MATCHING_MODELS_FIELD, RULE_DEFINITION_TYPES_FIELD, RULES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attributeMatchingModel;
    private final List<String> recordMatchingModels;
    private final List<String> ruleDefinitionTypes;
    private final List<Rule> rules;

    private NamespaceRuleBasedProperties(BuilderImpl builder) {
        this.attributeMatchingModel = builder.attributeMatchingModel;
        this.recordMatchingModels = builder.recordMatchingModels;
        this.ruleDefinitionTypes = builder.ruleDefinitionTypes;
        this.rules = builder.rules;
    }

    public final AttributeMatchingModel attributeMatchingModel() {
        return AttributeMatchingModel.fromValue(this.attributeMatchingModel);
    }

    public final String attributeMatchingModelAsString() {
        return this.attributeMatchingModel;
    }

    public final List<RecordMatchingModel> recordMatchingModels() {
        return RecordMatchingModelListCopier.copyStringToEnum(this.recordMatchingModels);
    }

    public final boolean hasRecordMatchingModels() {
        return this.recordMatchingModels != null && !(this.recordMatchingModels instanceof SdkAutoConstructList);
    }

    public final List<String> recordMatchingModelsAsStrings() {
        return this.recordMatchingModels;
    }

    public final List<IdMappingWorkflowRuleDefinitionType> ruleDefinitionTypes() {
        return IdMappingWorkflowRuleDefinitionTypeListCopier.copyStringToEnum(this.ruleDefinitionTypes);
    }

    public final boolean hasRuleDefinitionTypes() {
        return this.ruleDefinitionTypes != null && !(this.ruleDefinitionTypes instanceof SdkAutoConstructList);
    }

    public final List<String> ruleDefinitionTypesAsStrings() {
        return this.ruleDefinitionTypes;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeMatchingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecordMatchingModels() ? this.recordMatchingModelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleDefinitionTypes() ? this.ruleDefinitionTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceRuleBasedProperties)) {
            return false;
        }
        NamespaceRuleBasedProperties other = (NamespaceRuleBasedProperties)obj;
        return Objects.equals(this.attributeMatchingModelAsString(), other.attributeMatchingModelAsString()) && this.hasRecordMatchingModels() == other.hasRecordMatchingModels() && Objects.equals(this.recordMatchingModelsAsStrings(), other.recordMatchingModelsAsStrings()) && this.hasRuleDefinitionTypes() == other.hasRuleDefinitionTypes() && Objects.equals(this.ruleDefinitionTypesAsStrings(), other.ruleDefinitionTypesAsStrings()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"NamespaceRuleBasedProperties").add("AttributeMatchingModel", (Object)this.attributeMatchingModelAsString()).add("RecordMatchingModels", this.hasRecordMatchingModels() ? this.recordMatchingModelsAsStrings() : null).add("RuleDefinitionTypes", this.hasRuleDefinitionTypes() ? this.ruleDefinitionTypesAsStrings() : null).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributeMatchingModel": {
                return Optional.ofNullable(clazz.cast(this.attributeMatchingModelAsString()));
            }
            case "recordMatchingModels": {
                return Optional.ofNullable(clazz.cast(this.recordMatchingModelsAsStrings()));
            }
            case "ruleDefinitionTypes": {
                return Optional.ofNullable(clazz.cast(this.ruleDefinitionTypesAsStrings()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamespaceRuleBasedProperties, T> g) {
        return obj -> g.apply((NamespaceRuleBasedProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attributeMatchingModel;
        private List<String> recordMatchingModels = DefaultSdkAutoConstructList.getInstance();
        private List<String> ruleDefinitionTypes = DefaultSdkAutoConstructList.getInstance();
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceRuleBasedProperties model) {
            this.attributeMatchingModel(model.attributeMatchingModel);
            this.recordMatchingModelsWithStrings(model.recordMatchingModels);
            this.ruleDefinitionTypesWithStrings(model.ruleDefinitionTypes);
            this.rules(model.rules);
        }

        public final String getAttributeMatchingModel() {
            return this.attributeMatchingModel;
        }

        public final void setAttributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
        }

        @Override
        public final Builder attributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
            return this;
        }

        @Override
        public final Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel) {
            this.attributeMatchingModel(attributeMatchingModel == null ? null : attributeMatchingModel.toString());
            return this;
        }

        public final Collection<String> getRecordMatchingModels() {
            if (this.recordMatchingModels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.recordMatchingModels;
        }

        public final void setRecordMatchingModels(Collection<String> recordMatchingModels) {
            this.recordMatchingModels = RecordMatchingModelListCopier.copy(recordMatchingModels);
        }

        @Override
        public final Builder recordMatchingModelsWithStrings(Collection<String> recordMatchingModels) {
            this.recordMatchingModels = RecordMatchingModelListCopier.copy(recordMatchingModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordMatchingModelsWithStrings(String ... recordMatchingModels) {
            this.recordMatchingModelsWithStrings(Arrays.asList(recordMatchingModels));
            return this;
        }

        @Override
        public final Builder recordMatchingModels(Collection<RecordMatchingModel> recordMatchingModels) {
            this.recordMatchingModels = RecordMatchingModelListCopier.copyEnumToString(recordMatchingModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordMatchingModels(RecordMatchingModel ... recordMatchingModels) {
            this.recordMatchingModels(Arrays.asList(recordMatchingModels));
            return this;
        }

        public final Collection<String> getRuleDefinitionTypes() {
            if (this.ruleDefinitionTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleDefinitionTypes;
        }

        public final void setRuleDefinitionTypes(Collection<String> ruleDefinitionTypes) {
            this.ruleDefinitionTypes = IdMappingWorkflowRuleDefinitionTypeListCopier.copy(ruleDefinitionTypes);
        }

        @Override
        public final Builder ruleDefinitionTypesWithStrings(Collection<String> ruleDefinitionTypes) {
            this.ruleDefinitionTypes = IdMappingWorkflowRuleDefinitionTypeListCopier.copy(ruleDefinitionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleDefinitionTypesWithStrings(String ... ruleDefinitionTypes) {
            this.ruleDefinitionTypesWithStrings(Arrays.asList(ruleDefinitionTypes));
            return this;
        }

        @Override
        public final Builder ruleDefinitionTypes(Collection<IdMappingWorkflowRuleDefinitionType> ruleDefinitionTypes) {
            this.ruleDefinitionTypes = IdMappingWorkflowRuleDefinitionTypeListCopier.copyEnumToString(ruleDefinitionTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleDefinitionTypes(IdMappingWorkflowRuleDefinitionType ... ruleDefinitionTypes) {
            this.ruleDefinitionTypes(Arrays.asList(ruleDefinitionTypes));
            return this;
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = NamespaceRuleBasedPropertiesRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = NamespaceRuleBasedPropertiesRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = NamespaceRuleBasedPropertiesRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public NamespaceRuleBasedProperties build() {
            return new NamespaceRuleBasedProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NamespaceRuleBasedProperties> {
        public Builder attributeMatchingModel(String var1);

        public Builder attributeMatchingModel(AttributeMatchingModel var1);

        public Builder recordMatchingModelsWithStrings(Collection<String> var1);

        public Builder recordMatchingModelsWithStrings(String ... var1);

        public Builder recordMatchingModels(Collection<RecordMatchingModel> var1);

        public Builder recordMatchingModels(RecordMatchingModel ... var1);

        public Builder ruleDefinitionTypesWithStrings(Collection<String> var1);

        public Builder ruleDefinitionTypesWithStrings(String ... var1);

        public Builder ruleDefinitionTypes(Collection<IdMappingWorkflowRuleDefinitionType> var1);

        public Builder ruleDefinitionTypes(IdMappingWorkflowRuleDefinitionType ... var1);

        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);
    }
}

