/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.finspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.finspace.model.NetworkACLConfigurationCopier;
import software.amazon.awssdk.services.finspace.model.NetworkACLEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransitGatewayConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransitGatewayConfiguration> {
    private static final SdkField<String> TRANSIT_GATEWAY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transitGatewayID").getter(TransitGatewayConfiguration.getter(TransitGatewayConfiguration::transitGatewayID)).setter(TransitGatewayConfiguration.setter(Builder::transitGatewayID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitGatewayID").build()}).build();
    private static final SdkField<String> ROUTABLE_CIDR_SPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("routableCIDRSpace").getter(TransitGatewayConfiguration.getter(TransitGatewayConfiguration::routableCIDRSpace)).setter(TransitGatewayConfiguration.setter(Builder::routableCIDRSpace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routableCIDRSpace").build()}).build();
    private static final SdkField<List<NetworkACLEntry>> ATTACHMENT_NETWORK_ACL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attachmentNetworkAclConfiguration").getter(TransitGatewayConfiguration.getter(TransitGatewayConfiguration::attachmentNetworkAclConfiguration)).setter(TransitGatewayConfiguration.setter(Builder::attachmentNetworkAclConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentNetworkAclConfiguration").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkACLEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSIT_GATEWAY_ID_FIELD, ROUTABLE_CIDR_SPACE_FIELD, ATTACHMENT_NETWORK_ACL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransitGatewayConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transitGatewayID;
    private final String routableCIDRSpace;
    private final List<NetworkACLEntry> attachmentNetworkAclConfiguration;

    private TransitGatewayConfiguration(BuilderImpl builder) {
        this.transitGatewayID = builder.transitGatewayID;
        this.routableCIDRSpace = builder.routableCIDRSpace;
        this.attachmentNetworkAclConfiguration = builder.attachmentNetworkAclConfiguration;
    }

    public final String transitGatewayID() {
        return this.transitGatewayID;
    }

    public final String routableCIDRSpace() {
        return this.routableCIDRSpace;
    }

    public final boolean hasAttachmentNetworkAclConfiguration() {
        return this.attachmentNetworkAclConfiguration != null && !(this.attachmentNetworkAclConfiguration instanceof SdkAutoConstructList);
    }

    public final List<NetworkACLEntry> attachmentNetworkAclConfiguration() {
        return this.attachmentNetworkAclConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayID());
        hashCode = 31 * hashCode + Objects.hashCode(this.routableCIDRSpace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachmentNetworkAclConfiguration() ? this.attachmentNetworkAclConfiguration() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitGatewayConfiguration)) {
            return false;
        }
        TransitGatewayConfiguration other = (TransitGatewayConfiguration)obj;
        return Objects.equals(this.transitGatewayID(), other.transitGatewayID()) && Objects.equals(this.routableCIDRSpace(), other.routableCIDRSpace()) && this.hasAttachmentNetworkAclConfiguration() == other.hasAttachmentNetworkAclConfiguration() && Objects.equals(this.attachmentNetworkAclConfiguration(), other.attachmentNetworkAclConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TransitGatewayConfiguration").add("TransitGatewayID", (Object)this.transitGatewayID()).add("RoutableCIDRSpace", (Object)this.routableCIDRSpace()).add("AttachmentNetworkAclConfiguration", this.hasAttachmentNetworkAclConfiguration() ? this.attachmentNetworkAclConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transitGatewayID": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayID()));
            }
            case "routableCIDRSpace": {
                return Optional.ofNullable(clazz.cast(this.routableCIDRSpace()));
            }
            case "attachmentNetworkAclConfiguration": {
                return Optional.ofNullable(clazz.cast(this.attachmentNetworkAclConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("transitGatewayID", TRANSIT_GATEWAY_ID_FIELD);
        map.put("routableCIDRSpace", ROUTABLE_CIDR_SPACE_FIELD);
        map.put("attachmentNetworkAclConfiguration", ATTACHMENT_NETWORK_ACL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitGatewayConfiguration, T> g) {
        return obj -> g.apply((TransitGatewayConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transitGatewayID;
        private String routableCIDRSpace;
        private List<NetworkACLEntry> attachmentNetworkAclConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TransitGatewayConfiguration model) {
            this.transitGatewayID(model.transitGatewayID);
            this.routableCIDRSpace(model.routableCIDRSpace);
            this.attachmentNetworkAclConfiguration(model.attachmentNetworkAclConfiguration);
        }

        public final String getTransitGatewayID() {
            return this.transitGatewayID;
        }

        public final void setTransitGatewayID(String transitGatewayID) {
            this.transitGatewayID = transitGatewayID;
        }

        @Override
        public final Builder transitGatewayID(String transitGatewayID) {
            this.transitGatewayID = transitGatewayID;
            return this;
        }

        public final String getRoutableCIDRSpace() {
            return this.routableCIDRSpace;
        }

        public final void setRoutableCIDRSpace(String routableCIDRSpace) {
            this.routableCIDRSpace = routableCIDRSpace;
        }

        @Override
        public final Builder routableCIDRSpace(String routableCIDRSpace) {
            this.routableCIDRSpace = routableCIDRSpace;
            return this;
        }

        public final List<NetworkACLEntry.Builder> getAttachmentNetworkAclConfiguration() {
            List<NetworkACLEntry.Builder> result = NetworkACLConfigurationCopier.copyToBuilder(this.attachmentNetworkAclConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachmentNetworkAclConfiguration(Collection<NetworkACLEntry.BuilderImpl> attachmentNetworkAclConfiguration) {
            this.attachmentNetworkAclConfiguration = NetworkACLConfigurationCopier.copyFromBuilder(attachmentNetworkAclConfiguration);
        }

        @Override
        public final Builder attachmentNetworkAclConfiguration(Collection<NetworkACLEntry> attachmentNetworkAclConfiguration) {
            this.attachmentNetworkAclConfiguration = NetworkACLConfigurationCopier.copy(attachmentNetworkAclConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentNetworkAclConfiguration(NetworkACLEntry ... attachmentNetworkAclConfiguration) {
            this.attachmentNetworkAclConfiguration(Arrays.asList(attachmentNetworkAclConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentNetworkAclConfiguration(Consumer<NetworkACLEntry.Builder> ... attachmentNetworkAclConfiguration) {
            this.attachmentNetworkAclConfiguration(Stream.of(attachmentNetworkAclConfiguration).map(c -> (NetworkACLEntry)((NetworkACLEntry.Builder)NetworkACLEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TransitGatewayConfiguration build() {
            return new TransitGatewayConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransitGatewayConfiguration> {
        public Builder transitGatewayID(String var1);

        public Builder routableCIDRSpace(String var1);

        public Builder attachmentNetworkAclConfiguration(Collection<NetworkACLEntry> var1);

        public Builder attachmentNetworkAclConfiguration(NetworkACLEntry ... var1);

        public Builder attachmentNetworkAclConfiguration(Consumer<NetworkACLEntry.Builder> ... var1);
    }
}

