/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.firehose.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a Kinesis data stream used as the source for a Firehose stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KinesisStreamSourceDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<KinesisStreamSourceDescription.Builder, KinesisStreamSourceDescription> {
    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KinesisStreamARN").getter(getter(KinesisStreamSourceDescription::kinesisStreamARN))
            .setter(setter(Builder::kinesisStreamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamARN").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleARN").getter(getter(KinesisStreamSourceDescription::roleARN)).setter(setter(Builder::roleARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleARN").build()).build();

    private static final SdkField<Instant> DELIVERY_START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeliveryStartTimestamp").getter(getter(KinesisStreamSourceDescription::deliveryStartTimestamp))
            .setter(setter(Builder::deliveryStartTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryStartTimestamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KINESIS_STREAM_ARN_FIELD,
            ROLE_ARN_FIELD, DELIVERY_START_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String kinesisStreamARN;

    private final String roleARN;

    private final Instant deliveryStartTimestamp;

    private KinesisStreamSourceDescription(BuilderImpl builder) {
        this.kinesisStreamARN = builder.kinesisStreamARN;
        this.roleARN = builder.roleARN;
        this.deliveryStartTimestamp = builder.deliveryStartTimestamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source Kinesis data stream. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     * >Amazon Kinesis Data Streams ARN Format</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source Kinesis data stream. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
     *         >Amazon Kinesis Data Streams ARN Format</a>.
     */
    public final String kinesisStreamARN() {
        return kinesisStreamARN;
    }

    /**
     * <p>
     * The ARN of the role used by the source Kinesis data stream. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web
     * Services Identity and Access Management (IAM) ARN Format</a>.
     * </p>
     * 
     * @return The ARN of the role used by the source Kinesis data stream. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon
     *         Web Services Identity and Access Management (IAM) ARN Format</a>.
     */
    public final String roleARN() {
        return roleARN;
    }

    /**
     * <p>
     * Firehose starts retrieving records from the Kinesis data stream starting with this timestamp.
     * </p>
     * 
     * @return Firehose starts retrieving records from the Kinesis data stream starting with this timestamp.
     */
    public final Instant deliveryStartTimestamp() {
        return deliveryStartTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kinesisStreamARN());
        hashCode = 31 * hashCode + Objects.hashCode(roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStartTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisStreamSourceDescription)) {
            return false;
        }
        KinesisStreamSourceDescription other = (KinesisStreamSourceDescription) obj;
        return Objects.equals(kinesisStreamARN(), other.kinesisStreamARN()) && Objects.equals(roleARN(), other.roleARN())
                && Objects.equals(deliveryStartTimestamp(), other.deliveryStartTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KinesisStreamSourceDescription").add("KinesisStreamARN", kinesisStreamARN())
                .add("RoleARN", roleARN()).add("DeliveryStartTimestamp", deliveryStartTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KinesisStreamARN":
            return Optional.ofNullable(clazz.cast(kinesisStreamARN()));
        case "RoleARN":
            return Optional.ofNullable(clazz.cast(roleARN()));
        case "DeliveryStartTimestamp":
            return Optional.ofNullable(clazz.cast(deliveryStartTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KinesisStreamARN", KINESIS_STREAM_ARN_FIELD);
        map.put("RoleARN", ROLE_ARN_FIELD);
        map.put("DeliveryStartTimestamp", DELIVERY_START_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KinesisStreamSourceDescription, T> g) {
        return obj -> g.apply((KinesisStreamSourceDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KinesisStreamSourceDescription> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source Kinesis data stream. For more information, see <a href=
         * "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         * >Amazon Kinesis Data Streams ARN Format</a>.
         * </p>
         * 
         * @param kinesisStreamARN
         *        The Amazon Resource Name (ARN) of the source Kinesis data stream. For more information, see <a href=
         *        "https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams"
         *        >Amazon Kinesis Data Streams ARN Format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisStreamARN(String kinesisStreamARN);

        /**
         * <p>
         * The ARN of the role used by the source Kinesis data stream. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam">Amazon Web
         * Services Identity and Access Management (IAM) ARN Format</a>.
         * </p>
         * 
         * @param roleARN
         *        The ARN of the role used by the source Kinesis data stream. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam"
         *        >Amazon Web Services Identity and Access Management (IAM) ARN Format</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleARN(String roleARN);

        /**
         * <p>
         * Firehose starts retrieving records from the Kinesis data stream starting with this timestamp.
         * </p>
         * 
         * @param deliveryStartTimestamp
         *        Firehose starts retrieving records from the Kinesis data stream starting with this timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStartTimestamp(Instant deliveryStartTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String kinesisStreamARN;

        private String roleARN;

        private Instant deliveryStartTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisStreamSourceDescription model) {
            kinesisStreamARN(model.kinesisStreamARN);
            roleARN(model.roleARN);
            deliveryStartTimestamp(model.deliveryStartTimestamp);
        }

        public final String getKinesisStreamARN() {
            return kinesisStreamARN;
        }

        public final void setKinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
        }

        @Override
        public final Builder kinesisStreamARN(String kinesisStreamARN) {
            this.kinesisStreamARN = kinesisStreamARN;
            return this;
        }

        public final String getRoleARN() {
            return roleARN;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final Instant getDeliveryStartTimestamp() {
            return deliveryStartTimestamp;
        }

        public final void setDeliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
        }

        @Override
        public final Builder deliveryStartTimestamp(Instant deliveryStartTimestamp) {
            this.deliveryStartTimestamp = deliveryStartTimestamp;
            return this;
        }

        @Override
        public KinesisStreamSourceDescription build() {
            return new KinesisStreamSourceDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
