/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.freetier.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Consists of a Amazon Web Services Free Tier offer’s metadata and your data usage for the offer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FreeTierUsage implements SdkPojo, Serializable, ToCopyableBuilder<FreeTierUsage.Builder, FreeTierUsage> {
    private static final SdkField<Double> ACTUAL_USAGE_AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("actualUsageAmount").getter(getter(FreeTierUsage::actualUsageAmount))
            .setter(setter(Builder::actualUsageAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualUsageAmount").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(FreeTierUsage::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Double> FORECASTED_USAGE_AMOUNT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("forecastedUsageAmount").getter(getter(FreeTierUsage::forecastedUsageAmount))
            .setter(setter(Builder::forecastedUsageAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forecastedUsageAmount").build())
            .build();

    private static final SdkField<String> FREE_TIER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("freeTierType").getter(getter(FreeTierUsage::freeTierType)).setter(setter(Builder::freeTierType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTierType").build()).build();

    private static final SdkField<Double> LIMIT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("limit")
            .getter(getter(FreeTierUsage::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limit").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operation").getter(getter(FreeTierUsage::operation)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(FreeTierUsage::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("service")
            .getter(getter(FreeTierUsage::service)).setter(setter(Builder::service))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("service").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("unit")
            .getter(getter(FreeTierUsage::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(FreeTierUsage::usageType)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTUAL_USAGE_AMOUNT_FIELD,
            DESCRIPTION_FIELD, FORECASTED_USAGE_AMOUNT_FIELD, FREE_TIER_TYPE_FIELD, LIMIT_FIELD, OPERATION_FIELD, REGION_FIELD,
            SERVICE_FIELD, UNIT_FIELD, USAGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double actualUsageAmount;

    private final String description;

    private final Double forecastedUsageAmount;

    private final String freeTierType;

    private final Double limit;

    private final String operation;

    private final String region;

    private final String service;

    private final String unit;

    private final String usageType;

    private FreeTierUsage(BuilderImpl builder) {
        this.actualUsageAmount = builder.actualUsageAmount;
        this.description = builder.description;
        this.forecastedUsageAmount = builder.forecastedUsageAmount;
        this.freeTierType = builder.freeTierType;
        this.limit = builder.limit;
        this.operation = builder.operation;
        this.region = builder.region;
        this.service = builder.service;
        this.unit = builder.unit;
        this.usageType = builder.usageType;
    }

    /**
     * <p>
     * Describes the actual usage accrued month-to-day (MTD) that you've used so far.
     * </p>
     * 
     * @return Describes the actual usage accrued month-to-day (MTD) that you've used so far.
     */
    public final Double actualUsageAmount() {
        return actualUsageAmount;
    }

    /**
     * <p>
     * The description of the Free Tier offer.
     * </p>
     * 
     * @return The description of the Free Tier offer.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Describes the forecasted usage by the month that you're expected to use.
     * </p>
     * 
     * @return Describes the forecasted usage by the month that you're expected to use.
     */
    public final Double forecastedUsageAmount() {
        return forecastedUsageAmount;
    }

    /**
     * <p>
     * Describes the type of the Free Tier offer. For example, the offer can be <code>"12 Months Free"</code>,
     * <code>"Always Free"</code>, and <code>"Free Trial"</code>.
     * </p>
     * 
     * @return Describes the type of the Free Tier offer. For example, the offer can be <code>"12 Months Free"</code>,
     *         <code>"Always Free"</code>, and <code>"Free Trial"</code>.
     */
    public final String freeTierType() {
        return freeTierType;
    }

    /**
     * <p>
     * Describes the maximum usage allowed in Free Tier.
     * </p>
     * 
     * @return Describes the maximum usage allowed in Free Tier.
     */
    public final Double limit() {
        return limit;
    }

    /**
     * <p>
     * Describes <code>usageType</code> more granularly with the specific Amazon Web Service API operation. For example,
     * this can be the <code>RunInstances</code> API operation for Amazon Elastic Compute Cloud.
     * </p>
     * 
     * @return Describes <code>usageType</code> more granularly with the specific Amazon Web Service API operation. For
     *         example, this can be the <code>RunInstances</code> API operation for Amazon Elastic Compute Cloud.
     */
    public final String operation() {
        return operation;
    }

    /**
     * <p>
     * Describes the Amazon Web Services Region for which this offer is applicable
     * </p>
     * 
     * @return Describes the Amazon Web Services Region for which this offer is applicable
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The name of the Amazon Web Service providing the Free Tier offer. For example, this can be Amazon Elastic Compute
     * Cloud.
     * </p>
     * 
     * @return The name of the Amazon Web Service providing the Free Tier offer. For example, this can be Amazon Elastic
     *         Compute Cloud.
     */
    public final String service() {
        return service;
    }

    /**
     * <p>
     * Describes the unit of the <code>usageType</code>, such as <code>Hrs</code>.
     * </p>
     * 
     * @return Describes the unit of the <code>usageType</code>, such as <code>Hrs</code>.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * Describes the usage details of the offer. For example, this might be <code>Global-BoxUsage:freetrial</code>.
     * </p>
     * 
     * @return Describes the usage details of the offer. For example, this might be
     *         <code>Global-BoxUsage:freetrial</code>.
     */
    public final String usageType() {
        return usageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actualUsageAmount());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(forecastedUsageAmount());
        hashCode = 31 * hashCode + Objects.hashCode(freeTierType());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        hashCode = 31 * hashCode + Objects.hashCode(operation());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(usageType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeTierUsage)) {
            return false;
        }
        FreeTierUsage other = (FreeTierUsage) obj;
        return Objects.equals(actualUsageAmount(), other.actualUsageAmount())
                && Objects.equals(description(), other.description())
                && Objects.equals(forecastedUsageAmount(), other.forecastedUsageAmount())
                && Objects.equals(freeTierType(), other.freeTierType()) && Objects.equals(limit(), other.limit())
                && Objects.equals(operation(), other.operation()) && Objects.equals(region(), other.region())
                && Objects.equals(service(), other.service()) && Objects.equals(unit(), other.unit())
                && Objects.equals(usageType(), other.usageType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FreeTierUsage").add("ActualUsageAmount", actualUsageAmount()).add("Description", description())
                .add("ForecastedUsageAmount", forecastedUsageAmount()).add("FreeTierType", freeTierType()).add("Limit", limit())
                .add("Operation", operation()).add("Region", region()).add("Service", service()).add("Unit", unit())
                .add("UsageType", usageType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actualUsageAmount":
            return Optional.ofNullable(clazz.cast(actualUsageAmount()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "forecastedUsageAmount":
            return Optional.ofNullable(clazz.cast(forecastedUsageAmount()));
        case "freeTierType":
            return Optional.ofNullable(clazz.cast(freeTierType()));
        case "limit":
            return Optional.ofNullable(clazz.cast(limit()));
        case "operation":
            return Optional.ofNullable(clazz.cast(operation()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "service":
            return Optional.ofNullable(clazz.cast(service()));
        case "unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actualUsageAmount", ACTUAL_USAGE_AMOUNT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("forecastedUsageAmount", FORECASTED_USAGE_AMOUNT_FIELD);
        map.put("freeTierType", FREE_TIER_TYPE_FIELD);
        map.put("limit", LIMIT_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("region", REGION_FIELD);
        map.put("service", SERVICE_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FreeTierUsage, T> g) {
        return obj -> g.apply((FreeTierUsage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FreeTierUsage> {
        /**
         * <p>
         * Describes the actual usage accrued month-to-day (MTD) that you've used so far.
         * </p>
         * 
         * @param actualUsageAmount
         *        Describes the actual usage accrued month-to-day (MTD) that you've used so far.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualUsageAmount(Double actualUsageAmount);

        /**
         * <p>
         * The description of the Free Tier offer.
         * </p>
         * 
         * @param description
         *        The description of the Free Tier offer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Describes the forecasted usage by the month that you're expected to use.
         * </p>
         * 
         * @param forecastedUsageAmount
         *        Describes the forecasted usage by the month that you're expected to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forecastedUsageAmount(Double forecastedUsageAmount);

        /**
         * <p>
         * Describes the type of the Free Tier offer. For example, the offer can be <code>"12 Months Free"</code>,
         * <code>"Always Free"</code>, and <code>"Free Trial"</code>.
         * </p>
         * 
         * @param freeTierType
         *        Describes the type of the Free Tier offer. For example, the offer can be <code>"12 Months Free"</code>
         *        , <code>"Always Free"</code>, and <code>"Free Trial"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeTierType(String freeTierType);

        /**
         * <p>
         * Describes the maximum usage allowed in Free Tier.
         * </p>
         * 
         * @param limit
         *        Describes the maximum usage allowed in Free Tier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Double limit);

        /**
         * <p>
         * Describes <code>usageType</code> more granularly with the specific Amazon Web Service API operation. For
         * example, this can be the <code>RunInstances</code> API operation for Amazon Elastic Compute Cloud.
         * </p>
         * 
         * @param operation
         *        Describes <code>usageType</code> more granularly with the specific Amazon Web Service API operation.
         *        For example, this can be the <code>RunInstances</code> API operation for Amazon Elastic Compute Cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operation(String operation);

        /**
         * <p>
         * Describes the Amazon Web Services Region for which this offer is applicable
         * </p>
         * 
         * @param region
         *        Describes the Amazon Web Services Region for which this offer is applicable
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The name of the Amazon Web Service providing the Free Tier offer. For example, this can be Amazon Elastic
         * Compute Cloud.
         * </p>
         * 
         * @param service
         *        The name of the Amazon Web Service providing the Free Tier offer. For example, this can be Amazon
         *        Elastic Compute Cloud.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(String service);

        /**
         * <p>
         * Describes the unit of the <code>usageType</code>, such as <code>Hrs</code>.
         * </p>
         * 
         * @param unit
         *        Describes the unit of the <code>usageType</code>, such as <code>Hrs</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * Describes the usage details of the offer. For example, this might be <code>Global-BoxUsage:freetrial</code>.
         * </p>
         * 
         * @param usageType
         *        Describes the usage details of the offer. For example, this might be
         *        <code>Global-BoxUsage:freetrial</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageType(String usageType);
    }

    static final class BuilderImpl implements Builder {
        private Double actualUsageAmount;

        private String description;

        private Double forecastedUsageAmount;

        private String freeTierType;

        private Double limit;

        private String operation;

        private String region;

        private String service;

        private String unit;

        private String usageType;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeTierUsage model) {
            actualUsageAmount(model.actualUsageAmount);
            description(model.description);
            forecastedUsageAmount(model.forecastedUsageAmount);
            freeTierType(model.freeTierType);
            limit(model.limit);
            operation(model.operation);
            region(model.region);
            service(model.service);
            unit(model.unit);
            usageType(model.usageType);
        }

        public final Double getActualUsageAmount() {
            return actualUsageAmount;
        }

        public final void setActualUsageAmount(Double actualUsageAmount) {
            this.actualUsageAmount = actualUsageAmount;
        }

        @Override
        public final Builder actualUsageAmount(Double actualUsageAmount) {
            this.actualUsageAmount = actualUsageAmount;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Double getForecastedUsageAmount() {
            return forecastedUsageAmount;
        }

        public final void setForecastedUsageAmount(Double forecastedUsageAmount) {
            this.forecastedUsageAmount = forecastedUsageAmount;
        }

        @Override
        public final Builder forecastedUsageAmount(Double forecastedUsageAmount) {
            this.forecastedUsageAmount = forecastedUsageAmount;
            return this;
        }

        public final String getFreeTierType() {
            return freeTierType;
        }

        public final void setFreeTierType(String freeTierType) {
            this.freeTierType = freeTierType;
        }

        @Override
        public final Builder freeTierType(String freeTierType) {
            this.freeTierType = freeTierType;
            return this;
        }

        public final Double getLimit() {
            return limit;
        }

        public final void setLimit(Double limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Double limit) {
            this.limit = limit;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getService() {
            return service;
        }

        public final void setService(String service) {
            this.service = service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        @Override
        public FreeTierUsage build() {
            return new FreeTierUsage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
