/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An Active Directory error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveDirectoryErrorException extends FSxException implements
        ToCopyableBuilder<ActiveDirectoryErrorException.Builder, ActiveDirectoryErrorException> {
    private static final SdkField<String> ACTIVE_DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveDirectoryId").getter(getter(ActiveDirectoryErrorException::activeDirectoryId))
            .setter(setter(Builder::activeDirectoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ActiveDirectoryErrorException::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_DIRECTORY_ID_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String activeDirectoryId;

    private final String type;

    private ActiveDirectoryErrorException(BuilderImpl builder) {
        super(builder);
        this.activeDirectoryId = builder.activeDirectoryId;
        this.type = builder.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The directory ID of the directory that an error pertains to.
     * </p>
     * 
     * @return The directory ID of the directory that an error pertains to.
     */
    public String activeDirectoryId() {
        return activeDirectoryId;
    }

    /**
     * <p>
     * The type of Active Directory error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActiveDirectoryErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Active Directory error.
     * @see ActiveDirectoryErrorType
     */
    public ActiveDirectoryErrorType type() {
        return ActiveDirectoryErrorType.fromValue(type);
    }

    /**
     * <p>
     * The type of Active Directory error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActiveDirectoryErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of Active Directory error.
     * @see ActiveDirectoryErrorType
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ActiveDirectoryId", ACTIVE_DIRECTORY_ID_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveDirectoryErrorException, T> g) {
        return obj -> g.apply((ActiveDirectoryErrorException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveDirectoryErrorException>, FSxException.Builder {
        /**
         * <p>
         * The directory ID of the directory that an error pertains to.
         * </p>
         * 
         * @param activeDirectoryId
         *        The directory ID of the directory that an error pertains to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryId(String activeDirectoryId);

        /**
         * <p>
         * The type of Active Directory error.
         * </p>
         * 
         * @param type
         *        The type of Active Directory error.
         * @see ActiveDirectoryErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryErrorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of Active Directory error.
         * </p>
         * 
         * @param type
         *        The type of Active Directory error.
         * @see ActiveDirectoryErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActiveDirectoryErrorType
         */
        Builder type(ActiveDirectoryErrorType type);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends FSxException.BuilderImpl implements Builder {
        private String activeDirectoryId;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveDirectoryErrorException model) {
            super(model);
            activeDirectoryId(model.activeDirectoryId);
            type(model.type);
        }

        public final String getActiveDirectoryId() {
            return activeDirectoryId;
        }

        public final void setActiveDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
        }

        @Override
        public final Builder activeDirectoryId(String activeDirectoryId) {
            this.activeDirectoryId = activeDirectoryId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActiveDirectoryErrorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ActiveDirectoryErrorException build() {
            return new ActiveDirectoryErrorException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
