/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a specific Amazon FSx administrative action for the current Windows, Lustre, OpenZFS, or ONTAP file system
 * or volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdministrativeAction implements SdkPojo, Serializable,
        ToCopyableBuilder<AdministrativeAction.Builder, AdministrativeAction> {
    private static final SdkField<String> ADMINISTRATIVE_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdministrativeActionType").getter(getter(AdministrativeAction::administrativeActionTypeAsString))
            .setter(setter(Builder::administrativeActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeActionType").build())
            .build();

    private static final SdkField<Integer> PROGRESS_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgressPercent").getter(getter(AdministrativeAction::progressPercent))
            .setter(setter(Builder::progressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()).build();

    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RequestTime").getter(getter(AdministrativeAction::requestTime)).setter(setter(Builder::requestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AdministrativeAction::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<FileSystem> TARGET_FILE_SYSTEM_VALUES_FIELD = SdkField
            .<FileSystem> builder(MarshallingType.SDK_POJO).memberName("TargetFileSystemValues")
            .getter(getter(AdministrativeAction::targetFileSystemValues)).setter(setter(Builder::targetFileSystemValues))
            .constructor(FileSystem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetFileSystemValues").build())
            .build();

    private static final SdkField<AdministrativeActionFailureDetails> FAILURE_DETAILS_FIELD = SdkField
            .<AdministrativeActionFailureDetails> builder(MarshallingType.SDK_POJO).memberName("FailureDetails")
            .getter(getter(AdministrativeAction::failureDetails)).setter(setter(Builder::failureDetails))
            .constructor(AdministrativeActionFailureDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()).build();

    private static final SdkField<Volume> TARGET_VOLUME_VALUES_FIELD = SdkField.<Volume> builder(MarshallingType.SDK_POJO)
            .memberName("TargetVolumeValues").getter(getter(AdministrativeAction::targetVolumeValues))
            .setter(setter(Builder::targetVolumeValues)).constructor(Volume::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVolumeValues").build())
            .build();

    private static final SdkField<Snapshot> TARGET_SNAPSHOT_VALUES_FIELD = SdkField.<Snapshot> builder(MarshallingType.SDK_POJO)
            .memberName("TargetSnapshotValues").getter(getter(AdministrativeAction::targetSnapshotValues))
            .setter(setter(Builder::targetSnapshotValues)).constructor(Snapshot::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSnapshotValues").build())
            .build();

    private static final SdkField<Long> TOTAL_TRANSFER_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalTransferBytes").getter(getter(AdministrativeAction::totalTransferBytes))
            .setter(setter(Builder::totalTransferBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTransferBytes").build())
            .build();

    private static final SdkField<Long> REMAINING_TRANSFER_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RemainingTransferBytes").getter(getter(AdministrativeAction::remainingTransferBytes))
            .setter(setter(Builder::remainingTransferBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemainingTransferBytes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADMINISTRATIVE_ACTION_TYPE_FIELD, PROGRESS_PERCENT_FIELD, REQUEST_TIME_FIELD, STATUS_FIELD,
            TARGET_FILE_SYSTEM_VALUES_FIELD, FAILURE_DETAILS_FIELD, TARGET_VOLUME_VALUES_FIELD, TARGET_SNAPSHOT_VALUES_FIELD,
            TOTAL_TRANSFER_BYTES_FIELD, REMAINING_TRANSFER_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String administrativeActionType;

    private final Integer progressPercent;

    private final Instant requestTime;

    private final String status;

    private final FileSystem targetFileSystemValues;

    private final AdministrativeActionFailureDetails failureDetails;

    private final Volume targetVolumeValues;

    private final Snapshot targetSnapshotValues;

    private final Long totalTransferBytes;

    private final Long remainingTransferBytes;

    private AdministrativeAction(BuilderImpl builder) {
        this.administrativeActionType = builder.administrativeActionType;
        this.progressPercent = builder.progressPercent;
        this.requestTime = builder.requestTime;
        this.status = builder.status;
        this.targetFileSystemValues = builder.targetFileSystemValues;
        this.failureDetails = builder.failureDetails;
        this.targetVolumeValues = builder.targetVolumeValues;
        this.targetSnapshotValues = builder.targetSnapshotValues;
        this.totalTransferBytes = builder.totalTransferBytes;
        this.remainingTransferBytes = builder.remainingTransferBytes;
    }

    /**
     * Returns the value of the AdministrativeActionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #administrativeActionType} will return {@link AdministrativeActionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #administrativeActionTypeAsString}.
     * </p>
     * 
     * @return The value of the AdministrativeActionType property for this object.
     * @see AdministrativeActionType
     */
    public final AdministrativeActionType administrativeActionType() {
        return AdministrativeActionType.fromValue(administrativeActionType);
    }

    /**
     * Returns the value of the AdministrativeActionType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #administrativeActionType} will return {@link AdministrativeActionType#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #administrativeActionTypeAsString}.
     * </p>
     * 
     * @return The value of the AdministrativeActionType property for this object.
     * @see AdministrativeActionType
     */
    public final String administrativeActionTypeAsString() {
        return administrativeActionType;
    }

    /**
     * <p>
     * The percentage-complete status of a <code>STORAGE_OPTIMIZATION</code> or <code>DOWNLOAD_DATA_FROM_BACKUP</code>
     * administrative action. Does not apply to any other administrative action type.
     * </p>
     * 
     * @return The percentage-complete status of a <code>STORAGE_OPTIMIZATION</code> or
     *         <code>DOWNLOAD_DATA_FROM_BACKUP</code> administrative action. Does not apply to any other administrative
     *         action type.
     */
    public final Integer progressPercent() {
        return progressPercent;
    }

    /**
     * <p>
     * The time that the administrative action request was received.
     * </p>
     * 
     * @return The time that the administrative action request was received.
     */
    public final Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * The status of the administrative action, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.
     * </p>
     * <p>
     * For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has been
     * downloaded to the volume, and clients now have read-write access to volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the file system
     * with the new storage capacity, and is now performing the storage-optimization process.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates that the
     * file metadata is being downloaded onto the volume. The volume's Lifecycle state is CREATING.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates that
     * all metadata has been downloaded to the new volume and client can access data with read-only access while Amazon
     * FSx downloads the file data to the volume. Track the progress of this process with the
     * <code>ProgressPercent</code> element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the administrative action, as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.
     *         </p>
     *         <p>
     *         For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has been
     *         downloaded to the volume, and clients now have read-write access to volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the file
     *         system with the new storage capacity, and is now performing the storage-optimization process.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates
     *         that the file metadata is being downloaded onto the volume. The volume's Lifecycle state is CREATING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - For a backup restore to a second-generation FSx for ONTAP file system,
     *         indicates that all metadata has been downloaded to the new volume and client can access data with
     *         read-only access while Amazon FSx downloads the file data to the volume. Track the progress of this
     *         process with the <code>ProgressPercent</code> element.
     *         </p>
     *         </li>
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the administrative action, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.
     * </p>
     * <p>
     * For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has been
     * downloaded to the volume, and clients now have read-write access to volume.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the file system
     * with the new storage capacity, and is now performing the storage-optimization process.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates that the
     * file metadata is being downloaded onto the volume. The volume's Lifecycle state is CREATING.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates that
     * all metadata has been downloaded to the new volume and client can access data with read-only access while Amazon
     * FSx downloads the file data to the volume. Track the progress of this process with the
     * <code>ProgressPercent</code> element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the administrative action, as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.
     *         </p>
     *         <p>
     *         For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has been
     *         downloaded to the volume, and clients now have read-write access to volume.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the file
     *         system with the new storage capacity, and is now performing the storage-optimization process.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates
     *         that the file metadata is being downloaded onto the volume. The volume's Lifecycle state is CREATING.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - For a backup restore to a second-generation FSx for ONTAP file system,
     *         indicates that all metadata has been downloaded to the new volume and client can access data with
     *         read-only access while Amazon FSx downloads the file data to the volume. Track the progress of this
     *         process with the <code>ProgressPercent</code> element.
     *         </p>
     *         </li>
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The target value for the administration action, provided in the <code>UpdateFileSystem</code> operation. Returned
     * for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
     * </p>
     * 
     * @return The target value for the administration action, provided in the <code>UpdateFileSystem</code> operation.
     *         Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
     */
    public final FileSystem targetFileSystemValues() {
        return targetFileSystemValues;
    }

    /**
     * Returns the value of the FailureDetails property for this object.
     * 
     * @return The value of the FailureDetails property for this object.
     */
    public final AdministrativeActionFailureDetails failureDetails() {
        return failureDetails;
    }

    /**
     * Returns the value of the TargetVolumeValues property for this object.
     * 
     * @return The value of the TargetVolumeValues property for this object.
     */
    public final Volume targetVolumeValues() {
        return targetVolumeValues;
    }

    /**
     * Returns the value of the TargetSnapshotValues property for this object.
     * 
     * @return The value of the TargetSnapshotValues property for this object.
     */
    public final Snapshot targetSnapshotValues() {
        return targetSnapshotValues;
    }

    /**
     * <p>
     * The number of bytes that have transferred for the FSx for OpenZFS snapshot that you're copying.
     * </p>
     * 
     * @return The number of bytes that have transferred for the FSx for OpenZFS snapshot that you're copying.
     */
    public final Long totalTransferBytes() {
        return totalTransferBytes;
    }

    /**
     * <p>
     * The remaining bytes to transfer for the FSx for OpenZFS snapshot that you're copying.
     * </p>
     * 
     * @return The remaining bytes to transfer for the FSx for OpenZFS snapshot that you're copying.
     */
    public final Long remainingTransferBytes() {
        return remainingTransferBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(administrativeActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercent());
        hashCode = 31 * hashCode + Objects.hashCode(requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetFileSystemValues());
        hashCode = 31 * hashCode + Objects.hashCode(failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(targetVolumeValues());
        hashCode = 31 * hashCode + Objects.hashCode(targetSnapshotValues());
        hashCode = 31 * hashCode + Objects.hashCode(totalTransferBytes());
        hashCode = 31 * hashCode + Objects.hashCode(remainingTransferBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdministrativeAction)) {
            return false;
        }
        AdministrativeAction other = (AdministrativeAction) obj;
        return Objects.equals(administrativeActionTypeAsString(), other.administrativeActionTypeAsString())
                && Objects.equals(progressPercent(), other.progressPercent())
                && Objects.equals(requestTime(), other.requestTime()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(targetFileSystemValues(), other.targetFileSystemValues())
                && Objects.equals(failureDetails(), other.failureDetails())
                && Objects.equals(targetVolumeValues(), other.targetVolumeValues())
                && Objects.equals(targetSnapshotValues(), other.targetSnapshotValues())
                && Objects.equals(totalTransferBytes(), other.totalTransferBytes())
                && Objects.equals(remainingTransferBytes(), other.remainingTransferBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdministrativeAction").add("AdministrativeActionType", administrativeActionTypeAsString())
                .add("ProgressPercent", progressPercent()).add("RequestTime", requestTime()).add("Status", statusAsString())
                .add("TargetFileSystemValues", targetFileSystemValues()).add("FailureDetails", failureDetails())
                .add("TargetVolumeValues", targetVolumeValues()).add("TargetSnapshotValues", targetSnapshotValues())
                .add("TotalTransferBytes", totalTransferBytes()).add("RemainingTransferBytes", remainingTransferBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdministrativeActionType":
            return Optional.ofNullable(clazz.cast(administrativeActionTypeAsString()));
        case "ProgressPercent":
            return Optional.ofNullable(clazz.cast(progressPercent()));
        case "RequestTime":
            return Optional.ofNullable(clazz.cast(requestTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TargetFileSystemValues":
            return Optional.ofNullable(clazz.cast(targetFileSystemValues()));
        case "FailureDetails":
            return Optional.ofNullable(clazz.cast(failureDetails()));
        case "TargetVolumeValues":
            return Optional.ofNullable(clazz.cast(targetVolumeValues()));
        case "TargetSnapshotValues":
            return Optional.ofNullable(clazz.cast(targetSnapshotValues()));
        case "TotalTransferBytes":
            return Optional.ofNullable(clazz.cast(totalTransferBytes()));
        case "RemainingTransferBytes":
            return Optional.ofNullable(clazz.cast(remainingTransferBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdministrativeActionType", ADMINISTRATIVE_ACTION_TYPE_FIELD);
        map.put("ProgressPercent", PROGRESS_PERCENT_FIELD);
        map.put("RequestTime", REQUEST_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TargetFileSystemValues", TARGET_FILE_SYSTEM_VALUES_FIELD);
        map.put("FailureDetails", FAILURE_DETAILS_FIELD);
        map.put("TargetVolumeValues", TARGET_VOLUME_VALUES_FIELD);
        map.put("TargetSnapshotValues", TARGET_SNAPSHOT_VALUES_FIELD);
        map.put("TotalTransferBytes", TOTAL_TRANSFER_BYTES_FIELD);
        map.put("RemainingTransferBytes", REMAINING_TRANSFER_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdministrativeAction, T> g) {
        return obj -> g.apply((AdministrativeAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdministrativeAction> {
        /**
         * Sets the value of the AdministrativeActionType property for this object.
         *
         * @param administrativeActionType
         *        The new value for the AdministrativeActionType property for this object.
         * @see AdministrativeActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdministrativeActionType
         */
        Builder administrativeActionType(String administrativeActionType);

        /**
         * Sets the value of the AdministrativeActionType property for this object.
         *
         * @param administrativeActionType
         *        The new value for the AdministrativeActionType property for this object.
         * @see AdministrativeActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AdministrativeActionType
         */
        Builder administrativeActionType(AdministrativeActionType administrativeActionType);

        /**
         * <p>
         * The percentage-complete status of a <code>STORAGE_OPTIMIZATION</code> or
         * <code>DOWNLOAD_DATA_FROM_BACKUP</code> administrative action. Does not apply to any other administrative
         * action type.
         * </p>
         * 
         * @param progressPercent
         *        The percentage-complete status of a <code>STORAGE_OPTIMIZATION</code> or
         *        <code>DOWNLOAD_DATA_FROM_BACKUP</code> administrative action. Does not apply to any other
         *        administrative action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercent(Integer progressPercent);

        /**
         * <p>
         * The time that the administrative action request was received.
         * </p>
         * 
         * @param requestTime
         *        The time that the administrative action request was received.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * The status of the administrative action, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.
         * </p>
         * <p>
         * For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has been
         * downloaded to the volume, and clients now have read-write access to volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the file
         * system with the new storage capacity, and is now performing the storage-optimization process.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates that
         * the file metadata is being downloaded onto the volume. The volume's Lifecycle state is CREATING.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates
         * that all metadata has been downloaded to the new volume and client can access data with read-only access
         * while Amazon FSx downloads the file data to the volume. Track the progress of this process with the
         * <code>ProgressPercent</code> element.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the administrative action, as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.
         *        </p>
         *        <p>
         *        For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has
         *        been downloaded to the volume, and clients now have read-write access to volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the
         *        file system with the new storage capacity, and is now performing the storage-optimization process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - For a backup restore to a second-generation FSx for ONTAP file system,
         *        indicates that the file metadata is being downloaded onto the volume. The volume's Lifecycle state is
         *        CREATING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - For a backup restore to a second-generation FSx for ONTAP file system,
         *        indicates that all metadata has been downloaded to the new volume and client can access data with
         *        read-only access while Amazon FSx downloads the file data to the volume. Track the progress of this
         *        process with the <code>ProgressPercent</code> element.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the administrative action, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.
         * </p>
         * <p>
         * For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has been
         * downloaded to the volume, and clients now have read-write access to volume.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the file
         * system with the new storage capacity, and is now performing the storage-optimization process.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates that
         * the file metadata is being downloaded onto the volume. The volume's Lifecycle state is CREATING.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - For a backup restore to a second-generation FSx for ONTAP file system, indicates
         * that all metadata has been downloaded to the new volume and client can access data with read-only access
         * while Amazon FSx downloads the file data to the volume. Track the progress of this process with the
         * <code>ProgressPercent</code> element.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the administrative action, as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Amazon FSx failed to process the administrative action successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - Amazon FSx is processing the administrative action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - Amazon FSx is waiting to process the administrative action.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code> - Amazon FSx has finished processing the administrative task.
         *        </p>
         *        <p>
         *        For a backup restore to a second-generation FSx for ONTAP file system, indicates that all data has
         *        been downloaded to the volume, and clients now have read-write access to volume.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATED_OPTIMIZING</code> - For a storage-capacity increase update, Amazon FSx has updated the
         *        file system with the new storage capacity, and is now performing the storage-optimization process.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code> - For a backup restore to a second-generation FSx for ONTAP file system,
         *        indicates that the file metadata is being downloaded onto the volume. The volume's Lifecycle state is
         *        CREATING.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - For a backup restore to a second-generation FSx for ONTAP file system,
         *        indicates that all metadata has been downloaded to the new volume and client can access data with
         *        read-only access while Amazon FSx downloads the file data to the volume. Track the progress of this
         *        process with the <code>ProgressPercent</code> element.
         *        </p>
         *        </li>
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * The target value for the administration action, provided in the <code>UpdateFileSystem</code> operation.
         * Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
         * </p>
         * 
         * @param targetFileSystemValues
         *        The target value for the administration action, provided in the <code>UpdateFileSystem</code>
         *        operation. Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFileSystemValues(FileSystem targetFileSystemValues);

        /**
         * <p>
         * The target value for the administration action, provided in the <code>UpdateFileSystem</code> operation.
         * Returned for <code>FILE_SYSTEM_UPDATE</code> administrative actions.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSystem.Builder} avoiding the need to
         * create one manually via {@link FileSystem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSystem.Builder#build()} is called immediately and its result
         * is passed to {@link #targetFileSystemValues(FileSystem)}.
         * 
         * @param targetFileSystemValues
         *        a consumer that will call methods on {@link FileSystem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetFileSystemValues(FileSystem)
         */
        default Builder targetFileSystemValues(Consumer<FileSystem.Builder> targetFileSystemValues) {
            return targetFileSystemValues(FileSystem.builder().applyMutation(targetFileSystemValues).build());
        }

        /**
         * Sets the value of the FailureDetails property for this object.
         *
         * @param failureDetails
         *        The new value for the FailureDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureDetails(AdministrativeActionFailureDetails failureDetails);

        /**
         * Sets the value of the FailureDetails property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link AdministrativeActionFailureDetails.Builder} avoiding the need to create one manually via
         * {@link AdministrativeActionFailureDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdministrativeActionFailureDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #failureDetails(AdministrativeActionFailureDetails)}.
         * 
         * @param failureDetails
         *        a consumer that will call methods on {@link AdministrativeActionFailureDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureDetails(AdministrativeActionFailureDetails)
         */
        default Builder failureDetails(Consumer<AdministrativeActionFailureDetails.Builder> failureDetails) {
            return failureDetails(AdministrativeActionFailureDetails.builder().applyMutation(failureDetails).build());
        }

        /**
         * Sets the value of the TargetVolumeValues property for this object.
         *
         * @param targetVolumeValues
         *        The new value for the TargetVolumeValues property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVolumeValues(Volume targetVolumeValues);

        /**
         * Sets the value of the TargetVolumeValues property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Volume.Builder} avoiding the need to
         * create one manually via {@link Volume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Volume.Builder#build()} is called immediately and its result is
         * passed to {@link #targetVolumeValues(Volume)}.
         * 
         * @param targetVolumeValues
         *        a consumer that will call methods on {@link Volume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetVolumeValues(Volume)
         */
        default Builder targetVolumeValues(Consumer<Volume.Builder> targetVolumeValues) {
            return targetVolumeValues(Volume.builder().applyMutation(targetVolumeValues).build());
        }

        /**
         * Sets the value of the TargetSnapshotValues property for this object.
         *
         * @param targetSnapshotValues
         *        The new value for the TargetSnapshotValues property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSnapshotValues(Snapshot targetSnapshotValues);

        /**
         * Sets the value of the TargetSnapshotValues property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Snapshot.Builder} avoiding the need to
         * create one manually via {@link Snapshot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Snapshot.Builder#build()} is called immediately and its result is
         * passed to {@link #targetSnapshotValues(Snapshot)}.
         * 
         * @param targetSnapshotValues
         *        a consumer that will call methods on {@link Snapshot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetSnapshotValues(Snapshot)
         */
        default Builder targetSnapshotValues(Consumer<Snapshot.Builder> targetSnapshotValues) {
            return targetSnapshotValues(Snapshot.builder().applyMutation(targetSnapshotValues).build());
        }

        /**
         * <p>
         * The number of bytes that have transferred for the FSx for OpenZFS snapshot that you're copying.
         * </p>
         * 
         * @param totalTransferBytes
         *        The number of bytes that have transferred for the FSx for OpenZFS snapshot that you're copying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalTransferBytes(Long totalTransferBytes);

        /**
         * <p>
         * The remaining bytes to transfer for the FSx for OpenZFS snapshot that you're copying.
         * </p>
         * 
         * @param remainingTransferBytes
         *        The remaining bytes to transfer for the FSx for OpenZFS snapshot that you're copying.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remainingTransferBytes(Long remainingTransferBytes);
    }

    static final class BuilderImpl implements Builder {
        private String administrativeActionType;

        private Integer progressPercent;

        private Instant requestTime;

        private String status;

        private FileSystem targetFileSystemValues;

        private AdministrativeActionFailureDetails failureDetails;

        private Volume targetVolumeValues;

        private Snapshot targetSnapshotValues;

        private Long totalTransferBytes;

        private Long remainingTransferBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(AdministrativeAction model) {
            administrativeActionType(model.administrativeActionType);
            progressPercent(model.progressPercent);
            requestTime(model.requestTime);
            status(model.status);
            targetFileSystemValues(model.targetFileSystemValues);
            failureDetails(model.failureDetails);
            targetVolumeValues(model.targetVolumeValues);
            targetSnapshotValues(model.targetSnapshotValues);
            totalTransferBytes(model.totalTransferBytes);
            remainingTransferBytes(model.remainingTransferBytes);
        }

        public final String getAdministrativeActionType() {
            return administrativeActionType;
        }

        public final void setAdministrativeActionType(String administrativeActionType) {
            this.administrativeActionType = administrativeActionType;
        }

        @Override
        public final Builder administrativeActionType(String administrativeActionType) {
            this.administrativeActionType = administrativeActionType;
            return this;
        }

        @Override
        public final Builder administrativeActionType(AdministrativeActionType administrativeActionType) {
            this.administrativeActionType(administrativeActionType == null ? null : administrativeActionType.toString());
            return this;
        }

        public final Integer getProgressPercent() {
            return progressPercent;
        }

        public final void setProgressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Integer progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final FileSystem.Builder getTargetFileSystemValues() {
            return targetFileSystemValues != null ? targetFileSystemValues.toBuilder() : null;
        }

        public final void setTargetFileSystemValues(FileSystem.BuilderImpl targetFileSystemValues) {
            this.targetFileSystemValues = targetFileSystemValues != null ? targetFileSystemValues.build() : null;
        }

        @Override
        public final Builder targetFileSystemValues(FileSystem targetFileSystemValues) {
            this.targetFileSystemValues = targetFileSystemValues;
            return this;
        }

        public final AdministrativeActionFailureDetails.Builder getFailureDetails() {
            return failureDetails != null ? failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(AdministrativeActionFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(AdministrativeActionFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final Volume.Builder getTargetVolumeValues() {
            return targetVolumeValues != null ? targetVolumeValues.toBuilder() : null;
        }

        public final void setTargetVolumeValues(Volume.BuilderImpl targetVolumeValues) {
            this.targetVolumeValues = targetVolumeValues != null ? targetVolumeValues.build() : null;
        }

        @Override
        public final Builder targetVolumeValues(Volume targetVolumeValues) {
            this.targetVolumeValues = targetVolumeValues;
            return this;
        }

        public final Snapshot.Builder getTargetSnapshotValues() {
            return targetSnapshotValues != null ? targetSnapshotValues.toBuilder() : null;
        }

        public final void setTargetSnapshotValues(Snapshot.BuilderImpl targetSnapshotValues) {
            this.targetSnapshotValues = targetSnapshotValues != null ? targetSnapshotValues.build() : null;
        }

        @Override
        public final Builder targetSnapshotValues(Snapshot targetSnapshotValues) {
            this.targetSnapshotValues = targetSnapshotValues;
            return this;
        }

        public final Long getTotalTransferBytes() {
            return totalTransferBytes;
        }

        public final void setTotalTransferBytes(Long totalTransferBytes) {
            this.totalTransferBytes = totalTransferBytes;
        }

        @Override
        public final Builder totalTransferBytes(Long totalTransferBytes) {
            this.totalTransferBytes = totalTransferBytes;
            return this;
        }

        public final Long getRemainingTransferBytes() {
            return remainingTransferBytes;
        }

        public final void setRemainingTransferBytes(Long remainingTransferBytes) {
            this.remainingTransferBytes = remainingTransferBytes;
        }

        @Override
        public final Builder remainingTransferBytes(Long remainingTransferBytes) {
            this.remainingTransferBytes = remainingTransferBytes;
            return this;
        }

        @Override
        public AdministrativeAction build() {
            return new AdministrativeAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
