/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataRepositoryAssociationResponse extends FSxResponse implements
        ToCopyableBuilder<CreateDataRepositoryAssociationResponse.Builder, CreateDataRepositoryAssociationResponse> {
    private static final SdkField<DataRepositoryAssociation> ASSOCIATION_FIELD = SdkField
            .<DataRepositoryAssociation> builder(MarshallingType.SDK_POJO).memberName("Association")
            .getter(getter(CreateDataRepositoryAssociationResponse::association)).setter(setter(Builder::association))
            .constructor(DataRepositoryAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DataRepositoryAssociation association;

    private CreateDataRepositoryAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.association = builder.association;
    }

    /**
     * <p>
     * The response object returned after the data repository association is created.
     * </p>
     * 
     * @return The response object returned after the data repository association is created.
     */
    public final DataRepositoryAssociation association() {
        return association;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(association());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataRepositoryAssociationResponse)) {
            return false;
        }
        CreateDataRepositoryAssociationResponse other = (CreateDataRepositoryAssociationResponse) obj;
        return Objects.equals(association(), other.association());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataRepositoryAssociationResponse").add("Association", association()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Association", ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataRepositoryAssociationResponse, T> g) {
        return obj -> g.apply((CreateDataRepositoryAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateDataRepositoryAssociationResponse> {
        /**
         * <p>
         * The response object returned after the data repository association is created.
         * </p>
         * 
         * @param association
         *        The response object returned after the data repository association is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(DataRepositoryAssociation association);

        /**
         * <p>
         * The response object returned after the data repository association is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link DataRepositoryAssociation.Builder}
         * avoiding the need to create one manually via {@link DataRepositoryAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataRepositoryAssociation.Builder#build()} is called immediately
         * and its result is passed to {@link #association(DataRepositoryAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link DataRepositoryAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(DataRepositoryAssociation)
         */
        default Builder association(Consumer<DataRepositoryAssociation.Builder> association) {
            return association(DataRepositoryAssociation.builder().applyMutation(association).build());
        }
    }

    static final class BuilderImpl extends FSxResponse.BuilderImpl implements Builder {
        private DataRepositoryAssociation association;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataRepositoryAssociationResponse model) {
            super(model);
            association(model.association);
        }

        public final DataRepositoryAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        public final void setAssociation(DataRepositoryAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(DataRepositoryAssociation association) {
            this.association = association;
            return this;
        }

        @Override
        public CreateDataRepositoryAssociationResponse build() {
            return new CreateDataRepositoryAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
