/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileCacheRequest extends FSxRequest implements
        ToCopyableBuilder<CreateFileCacheRequest.Builder, CreateFileCacheRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateFileCacheRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FILE_CACHE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileCacheType").getter(getter(CreateFileCacheRequest::fileCacheTypeAsString))
            .setter(setter(Builder::fileCacheType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheType").build()).build();

    private static final SdkField<String> FILE_CACHE_TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileCacheTypeVersion").getter(getter(CreateFileCacheRequest::fileCacheTypeVersion))
            .setter(setter(Builder::fileCacheTypeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheTypeVersion").build())
            .build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageCapacity").getter(getter(CreateFileCacheRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(CreateFileCacheRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateFileCacheRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFileCacheRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_DATA_REPOSITORY_ASSOCIATIONS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToDataRepositoryAssociations")
            .getter(getter(CreateFileCacheRequest::copyTagsToDataRepositoryAssociations))
            .setter(setter(Builder::copyTagsToDataRepositoryAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CopyTagsToDataRepositoryAssociations").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateFileCacheRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<CreateFileCacheLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField
            .<CreateFileCacheLustreConfiguration> builder(MarshallingType.SDK_POJO).memberName("LustreConfiguration")
            .getter(getter(CreateFileCacheRequest::lustreConfiguration)).setter(setter(Builder::lustreConfiguration))
            .constructor(CreateFileCacheLustreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build())
            .build();

    private static final SdkField<List<FileCacheDataRepositoryAssociation>> DATA_REPOSITORY_ASSOCIATIONS_FIELD = SdkField
            .<List<FileCacheDataRepositoryAssociation>> builder(MarshallingType.LIST)
            .memberName("DataRepositoryAssociations")
            .getter(getter(CreateFileCacheRequest::dataRepositoryAssociations))
            .setter(setter(Builder::dataRepositoryAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FileCacheDataRepositoryAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(FileCacheDataRepositoryAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            FILE_CACHE_TYPE_FIELD, FILE_CACHE_TYPE_VERSION_FIELD, STORAGE_CAPACITY_FIELD, SUBNET_IDS_FIELD,
            SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, COPY_TAGS_TO_DATA_REPOSITORY_ASSOCIATIONS_FIELD, KMS_KEY_ID_FIELD,
            LUSTRE_CONFIGURATION_FIELD, DATA_REPOSITORY_ASSOCIATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final String fileCacheType;

    private final String fileCacheTypeVersion;

    private final Integer storageCapacity;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final List<Tag> tags;

    private final Boolean copyTagsToDataRepositoryAssociations;

    private final String kmsKeyId;

    private final CreateFileCacheLustreConfiguration lustreConfiguration;

    private final List<FileCacheDataRepositoryAssociation> dataRepositoryAssociations;

    private CreateFileCacheRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.fileCacheType = builder.fileCacheType;
        this.fileCacheTypeVersion = builder.fileCacheTypeVersion;
        this.storageCapacity = builder.storageCapacity;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.copyTagsToDataRepositoryAssociations = builder.copyTagsToDataRepositoryAssociations;
        this.kmsKeyId = builder.kmsKeyId;
        this.lustreConfiguration = builder.lustreConfiguration;
        this.dataRepositoryAssociations = builder.dataRepositoryAssociations;
    }

    /**
     * <p>
     * An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is automatically
     * filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     * </p>
     * <p>
     * By using the idempotent operation, you can retry a <code>CreateFileCache</code> operation without the risk of
     * creating an extra cache. This approach can be useful when an initial call fails in a way that makes it unclear
     * whether a cache was created. Examples are if a transport level timeout occurred, or your connection was reset. If
     * you use the same client request token and the initial call created a cache, the client receives success as long
     * as the parameters are the same.
     * </p>
     * 
     * @return An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is
     *         automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web
     *         Services SDK.</p>
     *         <p>
     *         By using the idempotent operation, you can retry a <code>CreateFileCache</code> operation without the
     *         risk of creating an extra cache. This approach can be useful when an initial call fails in a way that
     *         makes it unclear whether a cache was created. Examples are if a transport level timeout occurred, or your
     *         connection was reset. If you use the same client request token and the initial call created a cache, the
     *         client receives success as long as the parameters are the same.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The type of cache that you're creating, which must be <code>LUSTRE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileCacheType}
     * will return {@link FileCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileCacheTypeAsString}.
     * </p>
     * 
     * @return The type of cache that you're creating, which must be <code>LUSTRE</code>.
     * @see FileCacheType
     */
    public final FileCacheType fileCacheType() {
        return FileCacheType.fromValue(fileCacheType);
    }

    /**
     * <p>
     * The type of cache that you're creating, which must be <code>LUSTRE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileCacheType}
     * will return {@link FileCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileCacheTypeAsString}.
     * </p>
     * 
     * @return The type of cache that you're creating, which must be <code>LUSTRE</code>.
     * @see FileCacheType
     */
    public final String fileCacheTypeAsString() {
        return fileCacheType;
    }

    /**
     * <p>
     * Sets the Lustre version for the cache that you're creating, which must be <code>2.12</code>.
     * </p>
     * 
     * @return Sets the Lustre version for the cache that you're creating, which must be <code>2.12</code>.
     */
    public final String fileCacheTypeVersion() {
        return fileCacheTypeVersion;
    }

    /**
     * <p>
     * The storage capacity of the cache in gibibytes (GiB). Valid values are 1200 GiB, 2400 GiB, and increments of 2400
     * GiB.
     * </p>
     * 
     * @return The storage capacity of the cache in gibibytes (GiB). Valid values are 1200 GiB, 2400 GiB, and increments
     *         of 2400 GiB.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SubnetIds property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return The value of the SubnetIds property for this object.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache
     * access. This list isn't returned in later requests to describe the cache.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File
     *         Cache access. This list isn't returned in later requests to describe the cache.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value
     * defaults to false.
     * </p>
     * 
     * @return A boolean flag indicating whether tags for the cache should be copied to data repository associations.
     *         This value defaults to false.
     */
    public final Boolean copyTagsToDataRepositoryAssociations() {
        return copyTagsToDataRepositoryAssociations;
    }

    /**
     * <p>
     * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on an Amazon File Cache. If a
     * <code>KmsKeyId</code> isn't specified, the Amazon FSx-managed KMS key for your account is used. For more
     * information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in
     * the <i>Key Management Service API Reference</i>.
     * </p>
     * 
     * @return Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on an Amazon File
     *         Cache. If a <code>KmsKeyId</code> isn't specified, the Amazon FSx-managed KMS key for your account is
     *         used. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key
     *         Management Service API Reference</i>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The configuration for the Amazon File Cache resource being created.
     * </p>
     * 
     * @return The configuration for the Amazon File Cache resource being created.
     */
    public final CreateFileCacheLustreConfiguration lustreConfiguration() {
        return lustreConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataRepositoryAssociations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataRepositoryAssociations() {
        return dataRepositoryAssociations != null && !(dataRepositoryAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation.
     * The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository
     * that supports the NFSv3 protocol.
     * </p>
     * <p>
     * The DRA configurations must meet the following requirements:
     * </p>
     * <ul>
     * <li>
     * <p>
     * All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't
     * link to different data repository types at the same time.
     * </p>
     * </li>
     * <li>
     * <p>
     * An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
     * </p>
     * </li>
     * </ul>
     * <p>
     * DRA automatic import and automatic export is not supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataRepositoryAssociations} method.
     * </p>
     * 
     * @return A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache
     *         creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS)
     *         data repository that supports the NFSv3 protocol.</p>
     *         <p>
     *         The DRA configurations must meet the following requirements:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         All configurations on the list must be of the same data repository type, either all S3 or all NFS. A
     *         cache can't link to different data repository types at the same time.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         DRA automatic import and automatic export is not supported.
     */
    public final List<FileCacheDataRepositoryAssociation> dataRepositoryAssociations() {
        return dataRepositoryAssociations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(fileCacheTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fileCacheTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToDataRepositoryAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(lustreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataRepositoryAssociations() ? dataRepositoryAssociations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileCacheRequest)) {
            return false;
        }
        CreateFileCacheRequest other = (CreateFileCacheRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(fileCacheTypeAsString(), other.fileCacheTypeAsString())
                && Objects.equals(fileCacheTypeVersion(), other.fileCacheTypeVersion())
                && Objects.equals(storageCapacity(), other.storageCapacity()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(copyTagsToDataRepositoryAssociations(), other.copyTagsToDataRepositoryAssociations())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(lustreConfiguration(), other.lustreConfiguration())
                && hasDataRepositoryAssociations() == other.hasDataRepositoryAssociations()
                && Objects.equals(dataRepositoryAssociations(), other.dataRepositoryAssociations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFileCacheRequest").add("ClientRequestToken", clientRequestToken())
                .add("FileCacheType", fileCacheTypeAsString()).add("FileCacheTypeVersion", fileCacheTypeVersion())
                .add("StorageCapacity", storageCapacity()).add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null)
                .add("CopyTagsToDataRepositoryAssociations", copyTagsToDataRepositoryAssociations()).add("KmsKeyId", kmsKeyId())
                .add("LustreConfiguration", lustreConfiguration())
                .add("DataRepositoryAssociations", hasDataRepositoryAssociations() ? dataRepositoryAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "FileCacheType":
            return Optional.ofNullable(clazz.cast(fileCacheTypeAsString()));
        case "FileCacheTypeVersion":
            return Optional.ofNullable(clazz.cast(fileCacheTypeVersion()));
        case "StorageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "CopyTagsToDataRepositoryAssociations":
            return Optional.ofNullable(clazz.cast(copyTagsToDataRepositoryAssociations()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "LustreConfiguration":
            return Optional.ofNullable(clazz.cast(lustreConfiguration()));
        case "DataRepositoryAssociations":
            return Optional.ofNullable(clazz.cast(dataRepositoryAssociations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("FileCacheType", FILE_CACHE_TYPE_FIELD);
        map.put("FileCacheTypeVersion", FILE_CACHE_TYPE_VERSION_FIELD);
        map.put("StorageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("CopyTagsToDataRepositoryAssociations", COPY_TAGS_TO_DATA_REPOSITORY_ASSOCIATIONS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("LustreConfiguration", LUSTRE_CONFIGURATION_FIELD);
        map.put("DataRepositoryAssociations", DATA_REPOSITORY_ASSOCIATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFileCacheRequest, T> g) {
        return obj -> g.apply((CreateFileCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFileCacheRequest> {
        /**
         * <p>
         * An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is
         * automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services
         * SDK.
         * </p>
         * <p>
         * By using the idempotent operation, you can retry a <code>CreateFileCache</code> operation without the risk of
         * creating an extra cache. This approach can be useful when an initial call fails in a way that makes it
         * unclear whether a cache was created. Examples are if a transport level timeout occurred, or your connection
         * was reset. If you use the same client request token and the initial call created a cache, the client receives
         * success as long as the parameters are the same.
         * </p>
         * 
         * @param clientRequestToken
         *        An idempotency token for resource creation, in a string of up to 63 ASCII characters. This token is
         *        automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web
         *        Services SDK.</p>
         *        <p>
         *        By using the idempotent operation, you can retry a <code>CreateFileCache</code> operation without the
         *        risk of creating an extra cache. This approach can be useful when an initial call fails in a way that
         *        makes it unclear whether a cache was created. Examples are if a transport level timeout occurred, or
         *        your connection was reset. If you use the same client request token and the initial call created a
         *        cache, the client receives success as long as the parameters are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The type of cache that you're creating, which must be <code>LUSTRE</code>.
         * </p>
         * 
         * @param fileCacheType
         *        The type of cache that you're creating, which must be <code>LUSTRE</code>.
         * @see FileCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileCacheType
         */
        Builder fileCacheType(String fileCacheType);

        /**
         * <p>
         * The type of cache that you're creating, which must be <code>LUSTRE</code>.
         * </p>
         * 
         * @param fileCacheType
         *        The type of cache that you're creating, which must be <code>LUSTRE</code>.
         * @see FileCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileCacheType
         */
        Builder fileCacheType(FileCacheType fileCacheType);

        /**
         * <p>
         * Sets the Lustre version for the cache that you're creating, which must be <code>2.12</code>.
         * </p>
         * 
         * @param fileCacheTypeVersion
         *        Sets the Lustre version for the cache that you're creating, which must be <code>2.12</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileCacheTypeVersion(String fileCacheTypeVersion);

        /**
         * <p>
         * The storage capacity of the cache in gibibytes (GiB). Valid values are 1200 GiB, 2400 GiB, and increments of
         * 2400 GiB.
         * </p>
         * 
         * @param storageCapacity
         *        The storage capacity of the cache in gibibytes (GiB). Valid values are 1200 GiB, 2400 GiB, and
         *        increments of 2400 GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * Sets the value of the SubnetIds property for this object.
         *
         * @param subnetIds
         *        The new value for the SubnetIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * Sets the value of the SubnetIds property for this object.
         *
         * @param subnetIds
         *        The new value for the SubnetIds property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache
         * access. This list isn't returned in later requests to describe the cache.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of IDs specifying the security groups to apply to all network interfaces created for Amazon
         *        File Cache access. This list isn't returned in later requests to describe the cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache
         * access. This list isn't returned in later requests to describe the cache.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of IDs specifying the security groups to apply to all network interfaces created for Amazon
         *        File Cache access. This list isn't returned in later requests to describe the cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A boolean flag indicating whether tags for the cache should be copied to data repository associations. This
         * value defaults to false.
         * </p>
         * 
         * @param copyTagsToDataRepositoryAssociations
         *        A boolean flag indicating whether tags for the cache should be copied to data repository associations.
         *        This value defaults to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToDataRepositoryAssociations(Boolean copyTagsToDataRepositoryAssociations);

        /**
         * <p>
         * Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on an Amazon File Cache.
         * If a <code>KmsKeyId</code> isn't specified, the Amazon FSx-managed KMS key for your account is used. For more
         * information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a>
         * in the <i>Key Management Service API Reference</i>.
         * </p>
         * 
         * @param kmsKeyId
         *        Specifies the ID of the Key Management Service (KMS) key to use for encrypting data on an Amazon File
         *        Cache. If a <code>KmsKeyId</code> isn't specified, the Amazon FSx-managed KMS key for your account is
         *        used. For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/APIReference/API_Encrypt.html">Encrypt</a> in the <i>Key
         *        Management Service API Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The configuration for the Amazon File Cache resource being created.
         * </p>
         * 
         * @param lustreConfiguration
         *        The configuration for the Amazon File Cache resource being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lustreConfiguration(CreateFileCacheLustreConfiguration lustreConfiguration);

        /**
         * <p>
         * The configuration for the Amazon File Cache resource being created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateFileCacheLustreConfiguration.Builder} avoiding the need to create one manually via
         * {@link CreateFileCacheLustreConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateFileCacheLustreConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lustreConfiguration(CreateFileCacheLustreConfiguration)}.
         * 
         * @param lustreConfiguration
         *        a consumer that will call methods on {@link CreateFileCacheLustreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lustreConfiguration(CreateFileCacheLustreConfiguration)
         */
        default Builder lustreConfiguration(Consumer<CreateFileCacheLustreConfiguration.Builder> lustreConfiguration) {
            return lustreConfiguration(CreateFileCacheLustreConfiguration.builder().applyMutation(lustreConfiguration).build());
        }

        /**
         * <p>
         * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache
         * creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data
         * repository that supports the NFSv3 protocol.
         * </p>
         * <p>
         * The DRA configurations must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache
         * can't link to different data repository types at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
         * </p>
         * </li>
         * </ul>
         * <p>
         * DRA automatic import and automatic export is not supported.
         * </p>
         * 
         * @param dataRepositoryAssociations
         *        A list of up to 8 configurations for data repository associations (DRAs) to be created during the
         *        cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File
         *        System (NFS) data repository that supports the NFSv3 protocol.</p>
         *        <p>
         *        The DRA configurations must meet the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All configurations on the list must be of the same data repository type, either all S3 or all NFS. A
         *        cache can't link to different data repository types at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        DRA automatic import and automatic export is not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRepositoryAssociations(Collection<FileCacheDataRepositoryAssociation> dataRepositoryAssociations);

        /**
         * <p>
         * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache
         * creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data
         * repository that supports the NFSv3 protocol.
         * </p>
         * <p>
         * The DRA configurations must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache
         * can't link to different data repository types at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
         * </p>
         * </li>
         * </ul>
         * <p>
         * DRA automatic import and automatic export is not supported.
         * </p>
         * 
         * @param dataRepositoryAssociations
         *        A list of up to 8 configurations for data repository associations (DRAs) to be created during the
         *        cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File
         *        System (NFS) data repository that supports the NFSv3 protocol.</p>
         *        <p>
         *        The DRA configurations must meet the following requirements:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        All configurations on the list must be of the same data repository type, either all S3 or all NFS. A
         *        cache can't link to different data repository types at the same time.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        DRA automatic import and automatic export is not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRepositoryAssociations(FileCacheDataRepositoryAssociation... dataRepositoryAssociations);

        /**
         * <p>
         * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache
         * creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data
         * repository that supports the NFSv3 protocol.
         * </p>
         * <p>
         * The DRA configurations must meet the following requirements:
         * </p>
         * <ul>
         * <li>
         * <p>
         * All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache
         * can't link to different data repository types at the same time.
         * </p>
         * </li>
         * <li>
         * <p>
         * An NFS DRA must link to an NFS file system that supports the NFSv3 protocol.
         * </p>
         * </li>
         * </ul>
         * <p>
         * DRA automatic import and automatic export is not supported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #dataRepositoryAssociations(List<FileCacheDataRepositoryAssociation>)}.
         * 
         * @param dataRepositoryAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.FileCacheDataRepositoryAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataRepositoryAssociations(java.util.Collection<FileCacheDataRepositoryAssociation>)
         */
        Builder dataRepositoryAssociations(Consumer<FileCacheDataRepositoryAssociation.Builder>... dataRepositoryAssociations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String fileCacheType;

        private String fileCacheTypeVersion;

        private Integer storageCapacity;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Boolean copyTagsToDataRepositoryAssociations;

        private String kmsKeyId;

        private CreateFileCacheLustreConfiguration lustreConfiguration;

        private List<FileCacheDataRepositoryAssociation> dataRepositoryAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileCacheRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            fileCacheType(model.fileCacheType);
            fileCacheTypeVersion(model.fileCacheTypeVersion);
            storageCapacity(model.storageCapacity);
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            tags(model.tags);
            copyTagsToDataRepositoryAssociations(model.copyTagsToDataRepositoryAssociations);
            kmsKeyId(model.kmsKeyId);
            lustreConfiguration(model.lustreConfiguration);
            dataRepositoryAssociations(model.dataRepositoryAssociations);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getFileCacheType() {
            return fileCacheType;
        }

        public final void setFileCacheType(String fileCacheType) {
            this.fileCacheType = fileCacheType;
        }

        @Override
        public final Builder fileCacheType(String fileCacheType) {
            this.fileCacheType = fileCacheType;
            return this;
        }

        @Override
        public final Builder fileCacheType(FileCacheType fileCacheType) {
            this.fileCacheType(fileCacheType == null ? null : fileCacheType.toString());
            return this;
        }

        public final String getFileCacheTypeVersion() {
            return fileCacheTypeVersion;
        }

        public final void setFileCacheTypeVersion(String fileCacheTypeVersion) {
            this.fileCacheTypeVersion = fileCacheTypeVersion;
        }

        @Override
        public final Builder fileCacheTypeVersion(String fileCacheTypeVersion) {
            this.fileCacheTypeVersion = fileCacheTypeVersion;
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCopyTagsToDataRepositoryAssociations() {
            return copyTagsToDataRepositoryAssociations;
        }

        public final void setCopyTagsToDataRepositoryAssociations(Boolean copyTagsToDataRepositoryAssociations) {
            this.copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations;
        }

        @Override
        public final Builder copyTagsToDataRepositoryAssociations(Boolean copyTagsToDataRepositoryAssociations) {
            this.copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final CreateFileCacheLustreConfiguration.Builder getLustreConfiguration() {
            return lustreConfiguration != null ? lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(CreateFileCacheLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public final Builder lustreConfiguration(CreateFileCacheLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final List<FileCacheDataRepositoryAssociation.Builder> getDataRepositoryAssociations() {
            List<FileCacheDataRepositoryAssociation.Builder> result = CreateFileCacheDataRepositoryAssociationsCopier
                    .copyToBuilder(this.dataRepositoryAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataRepositoryAssociations(
                Collection<FileCacheDataRepositoryAssociation.BuilderImpl> dataRepositoryAssociations) {
            this.dataRepositoryAssociations = CreateFileCacheDataRepositoryAssociationsCopier
                    .copyFromBuilder(dataRepositoryAssociations);
        }

        @Override
        public final Builder dataRepositoryAssociations(Collection<FileCacheDataRepositoryAssociation> dataRepositoryAssociations) {
            this.dataRepositoryAssociations = CreateFileCacheDataRepositoryAssociationsCopier.copy(dataRepositoryAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositoryAssociations(FileCacheDataRepositoryAssociation... dataRepositoryAssociations) {
            dataRepositoryAssociations(Arrays.asList(dataRepositoryAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositoryAssociations(
                Consumer<FileCacheDataRepositoryAssociation.Builder>... dataRepositoryAssociations) {
            dataRepositoryAssociations(Stream.of(dataRepositoryAssociations)
                    .map(c -> FileCacheDataRepositoryAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFileCacheRequest build() {
            return new CreateFileCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
