/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request object for the <code>CreateFileSystemFromBackup</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFileSystemFromBackupRequest extends FSxRequest implements
        ToCopyableBuilder<CreateFileSystemFromBackupRequest.Builder, CreateFileSystemFromBackupRequest> {
    private static final SdkField<String> BACKUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupId").getter(getter(CreateFileSystemFromBackupRequest::backupId)).setter(setter(Builder::backupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(CreateFileSystemFromBackupRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(CreateFileSystemFromBackupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(CreateFileSystemFromBackupRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateFileSystemFromBackupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CreateFileSystemWindowsConfiguration> WINDOWS_CONFIGURATION_FIELD = SdkField
            .<CreateFileSystemWindowsConfiguration> builder(MarshallingType.SDK_POJO).memberName("WindowsConfiguration")
            .getter(getter(CreateFileSystemFromBackupRequest::windowsConfiguration))
            .setter(setter(Builder::windowsConfiguration)).constructor(CreateFileSystemWindowsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsConfiguration").build())
            .build();

    private static final SdkField<CreateFileSystemLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField
            .<CreateFileSystemLustreConfiguration> builder(MarshallingType.SDK_POJO).memberName("LustreConfiguration")
            .getter(getter(CreateFileSystemFromBackupRequest::lustreConfiguration)).setter(setter(Builder::lustreConfiguration))
            .constructor(CreateFileSystemLustreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build())
            .build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(CreateFileSystemFromBackupRequest::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateFileSystemFromBackupRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> FILE_SYSTEM_TYPE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemTypeVersion").getter(getter(CreateFileSystemFromBackupRequest::fileSystemTypeVersion))
            .setter(setter(Builder::fileSystemTypeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemTypeVersion").build())
            .build();

    private static final SdkField<CreateFileSystemOpenZFSConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField
            .<CreateFileSystemOpenZFSConfiguration> builder(MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration")
            .getter(getter(CreateFileSystemFromBackupRequest::openZFSConfiguration))
            .setter(setter(Builder::openZFSConfiguration)).constructor(CreateFileSystemOpenZFSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build())
            .build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageCapacity").getter(getter(CreateFileSystemFromBackupRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, TAGS_FIELD, WINDOWS_CONFIGURATION_FIELD,
            LUSTRE_CONFIGURATION_FIELD, STORAGE_TYPE_FIELD, KMS_KEY_ID_FIELD, FILE_SYSTEM_TYPE_VERSION_FIELD,
            OPEN_ZFS_CONFIGURATION_FIELD, STORAGE_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupId;

    private final String clientRequestToken;

    private final List<String> subnetIds;

    private final List<String> securityGroupIds;

    private final List<Tag> tags;

    private final CreateFileSystemWindowsConfiguration windowsConfiguration;

    private final CreateFileSystemLustreConfiguration lustreConfiguration;

    private final String storageType;

    private final String kmsKeyId;

    private final String fileSystemTypeVersion;

    private final CreateFileSystemOpenZFSConfiguration openZFSConfiguration;

    private final Integer storageCapacity;

    private CreateFileSystemFromBackupRequest(BuilderImpl builder) {
        super(builder);
        this.backupId = builder.backupId;
        this.clientRequestToken = builder.clientRequestToken;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.tags = builder.tags;
        this.windowsConfiguration = builder.windowsConfiguration;
        this.lustreConfiguration = builder.lustreConfiguration;
        this.storageType = builder.storageType;
        this.kmsKeyId = builder.kmsKeyId;
        this.fileSystemTypeVersion = builder.fileSystemTypeVersion;
        this.openZFSConfiguration = builder.openZFSConfiguration;
        this.storageCapacity = builder.storageCapacity;
    }

    /**
     * Returns the value of the BackupId property for this object.
     * 
     * @return The value of the BackupId property for this object.
     */
    public final String backupId() {
        return backupId;
    }

    /**
     * <p>
     * A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is
     * automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services SDK.
     * </p>
     * 
     * @return A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is
     *         automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web
     *         Services SDK.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the IDs of the subnets that the file system will be accessible from. For Windows
     * <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the preferred file
     * server and one for the standby file server. You specify one of these subnets as the preferred subnet using the
     * <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.
     * </p>
     * <p>
     * Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre file systems,
     * and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet's Availability
     * Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return Specifies the IDs of the subnets that the file system will be accessible from. For Windows
     *         <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the
     *         preferred file server and one for the standby file server. You specify one of these subnets as the
     *         preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.</p>
     *         <p>
     *         Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre file
     *         systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that
     *         subnet's Availability Zone.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system
     * access. These security groups apply to all network interfaces. This value isn't returned in later
     * <code>DescribeFileSystem</code> requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return A list of IDs for the security groups that apply to the specified network interfaces created for file
     *         system access. These security groups apply to all network interfaces. This value isn't returned in later
     *         <code>DescribeFileSystem</code> requests.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag
     * appears in the console as the file system name.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be applied to the file system at file system creation. The key value of the <code>Name</code>
     *         tag appears in the console as the file system name.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The configuration for this Microsoft Windows file system.
     * </p>
     * 
     * @return The configuration for this Microsoft Windows file system.
     */
    public final CreateFileSystemWindowsConfiguration windowsConfiguration() {
        return windowsConfiguration;
    }

    /**
     * Returns the value of the LustreConfiguration property for this object.
     * 
     * @return The value of the LustreConfiguration property for this object.
     */
    public final CreateFileSystemLustreConfiguration lustreConfiguration() {
        return lustreConfiguration;
    }

    /**
     * <p>
     * Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values are
     * <code>SSD</code> and <code>HDD</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS deployment
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and
     * <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default value is <code>SSD</code>.
     * </p>
     * <note>
     * <p>
     * HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's storage
     * capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a
     * backup of a file system that used SSD storage if the original SSD file system had a storage capacity of at least
     * 2000 GiB.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid
     *         values are <code>SSD</code> and <code>HDD</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS
     *         deployment types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and
     *         <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default value is <code>SSD</code>.
     *         </p>
     *         <note>
     *         <p>
     *         HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's
     *         storage capacity is tied to the file system that was backed up. You can create a file system that uses
     *         HDD storage from a backup of a file system that used SSD storage if the original SSD file system had a
     *         storage capacity of at least 2000 GiB.
     *         </p>
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values are
     * <code>SSD</code> and <code>HDD</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS deployment
     * types.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and
     * <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default value is <code>SSD</code>.
     * </p>
     * <note>
     * <p>
     * HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's storage
     * capacity is tied to the file system that was backed up. You can create a file system that uses HDD storage from a
     * backup of a file system that used SSD storage if the original SSD file system had a storage capacity of at least
     * 2000 GiB.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid
     *         values are <code>SSD</code> and <code>HDD</code>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS
     *         deployment types.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and
     *         <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default value is <code>SSD</code>.
     *         </p>
     *         <note>
     *         <p>
     *         HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's
     *         storage capacity is tied to the file system that was backed up. You can create a file system that uses
     *         HDD storage from a backup of a file system that used SSD storage if the original SSD file system had a
     *         storage capacity of at least 2000 GiB.
     *         </p>
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * Returns the value of the KmsKeyId property for this object.
     * 
     * @return The value of the KmsKeyId property for this object.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid values are
     * <code>2.10</code>, <code>2.12</code>, and <code>2.15</code>.
     * </p>
     * <p>
     * You can enter a Lustre version that is newer than the backup's <code>FileSystemTypeVersion</code> setting. If you
     * don't enter a newer Lustre version, it defaults to the backup's setting.
     * </p>
     * 
     * @return Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid
     *         values are <code>2.10</code>, <code>2.12</code>, and <code>2.15</code>.</p>
     *         <p>
     *         You can enter a Lustre version that is newer than the backup's <code>FileSystemTypeVersion</code>
     *         setting. If you don't enter a newer Lustre version, it defaults to the backup's setting.
     */
    public final String fileSystemTypeVersion() {
        return fileSystemTypeVersion;
    }

    /**
     * <p>
     * The OpenZFS configuration for the file system that's being created.
     * </p>
     * 
     * @return The OpenZFS configuration for the file system that's being created.
     */
    public final CreateFileSystemOpenZFSConfiguration openZFSConfiguration() {
        return openZFSConfiguration;
    }

    /**
     * <p>
     * Sets the storage capacity of the OpenZFS file system that you're creating from a backup, in gibibytes (GiB).
     * Valid values are from 64 GiB up to 524,288 GiB (512 TiB). However, the value that you specify must be equal to or
     * greater than the backup's storage capacity value. If you don't use the <code>StorageCapacity</code> parameter,
     * the default is the backup's <code>StorageCapacity</code> value.
     * </p>
     * <p>
     * If used to create a file system other than OpenZFS, you must provide a value that matches the backup's
     * <code>StorageCapacity</code> value. If you provide any other value, Amazon FSx responds with an HTTP status code
     * 400 Bad Request.
     * </p>
     * 
     * @return Sets the storage capacity of the OpenZFS file system that you're creating from a backup, in gibibytes
     *         (GiB). Valid values are from 64 GiB up to 524,288 GiB (512 TiB). However, the value that you specify must
     *         be equal to or greater than the backup's storage capacity value. If you don't use the
     *         <code>StorageCapacity</code> parameter, the default is the backup's <code>StorageCapacity</code>
     *         value.</p>
     *         <p>
     *         If used to create a file system other than OpenZFS, you must provide a value that matches the backup's
     *         <code>StorageCapacity</code> value. If you provide any other value, Amazon FSx responds with an HTTP
     *         status code 400 Bad Request.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(windowsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lustreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(openZFSConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemFromBackupRequest)) {
            return false;
        }
        CreateFileSystemFromBackupRequest other = (CreateFileSystemFromBackupRequest) obj;
        return Objects.equals(backupId(), other.backupId()) && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(windowsConfiguration(), other.windowsConfiguration())
                && Objects.equals(lustreConfiguration(), other.lustreConfiguration())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(fileSystemTypeVersion(), other.fileSystemTypeVersion())
                && Objects.equals(openZFSConfiguration(), other.openZFSConfiguration())
                && Objects.equals(storageCapacity(), other.storageCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFileSystemFromBackupRequest").add("BackupId", backupId())
                .add("ClientRequestToken", clientRequestToken()).add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("Tags", hasTags() ? tags() : null).add("WindowsConfiguration", windowsConfiguration())
                .add("LustreConfiguration", lustreConfiguration()).add("StorageType", storageTypeAsString())
                .add("KmsKeyId", kmsKeyId()).add("FileSystemTypeVersion", fileSystemTypeVersion())
                .add("OpenZFSConfiguration", openZFSConfiguration()).add("StorageCapacity", storageCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupId":
            return Optional.ofNullable(clazz.cast(backupId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WindowsConfiguration":
            return Optional.ofNullable(clazz.cast(windowsConfiguration()));
        case "LustreConfiguration":
            return Optional.ofNullable(clazz.cast(lustreConfiguration()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "FileSystemTypeVersion":
            return Optional.ofNullable(clazz.cast(fileSystemTypeVersion()));
        case "OpenZFSConfiguration":
            return Optional.ofNullable(clazz.cast(openZFSConfiguration()));
        case "StorageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupId", BACKUP_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WindowsConfiguration", WINDOWS_CONFIGURATION_FIELD);
        map.put("LustreConfiguration", LUSTRE_CONFIGURATION_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("FileSystemTypeVersion", FILE_SYSTEM_TYPE_VERSION_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        map.put("StorageCapacity", STORAGE_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFileSystemFromBackupRequest, T> g) {
        return obj -> g.apply((CreateFileSystemFromBackupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFileSystemFromBackupRequest> {
        /**
         * Sets the value of the BackupId property for this object.
         *
         * @param backupId
         *        The new value for the BackupId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupId(String backupId);

        /**
         * <p>
         * A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string is
         * automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web Services
         * SDK.
         * </p>
         * 
         * @param clientRequestToken
         *        A string of up to 63 ASCII characters that Amazon FSx uses to ensure idempotent creation. This string
         *        is automatically filled on your behalf when you use the Command Line Interface (CLI) or an Amazon Web
         *        Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Specifies the IDs of the subnets that the file system will be accessible from. For Windows
         * <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the preferred
         * file server and one for the standby file server. You specify one of these subnets as the preferred subnet
         * using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.
         * </p>
         * <p>
         * Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre file
         * systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet's
         * Availability Zone.
         * </p>
         * 
         * @param subnetIds
         *        Specifies the IDs of the subnets that the file system will be accessible from. For Windows
         *        <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the
         *        preferred file server and one for the standby file server. You specify one of these subnets as the
         *        preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.</p>
         *        <p>
         *        Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre
         *        file systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in
         *        that subnet's Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * Specifies the IDs of the subnets that the file system will be accessible from. For Windows
         * <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the preferred
         * file server and one for the standby file server. You specify one of these subnets as the preferred subnet
         * using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.
         * </p>
         * <p>
         * Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre file
         * systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in that subnet's
         * Availability Zone.
         * </p>
         * 
         * @param subnetIds
         *        Specifies the IDs of the subnets that the file system will be accessible from. For Windows
         *        <code>MULTI_AZ_1</code> file system deployment types, provide exactly two subnet IDs, one for the
         *        preferred file server and one for the standby file server. You specify one of these subnets as the
         *        preferred subnet using the <code>WindowsConfiguration &gt; PreferredSubnetID</code> property.</p>
         *        <p>
         *        Windows <code>SINGLE_AZ_1</code> and <code>SINGLE_AZ_2</code> file system deployment types, Lustre
         *        file systems, and OpenZFS file systems provide exactly one subnet ID. The file server is launched in
         *        that subnet's Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of IDs for the security groups that apply to the specified network interfaces created for file system
         * access. These security groups apply to all network interfaces. This value isn't returned in later
         * <code>DescribeFileSystem</code> requests.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of IDs for the security groups that apply to the specified network interfaces created for file
         *        system access. These security groups apply to all network interfaces. This value isn't returned in
         *        later <code>DescribeFileSystem</code> requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * A list of IDs for the security groups that apply to the specified network interfaces created for file system
         * access. These security groups apply to all network interfaces. This value isn't returned in later
         * <code>DescribeFileSystem</code> requests.
         * </p>
         * 
         * @param securityGroupIds
         *        A list of IDs for the security groups that apply to the specified network interfaces created for file
         *        system access. These security groups apply to all network interfaces. This value isn't returned in
         *        later <code>DescribeFileSystem</code> requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag
         * appears in the console as the file system name.
         * </p>
         * 
         * @param tags
         *        The tags to be applied to the file system at file system creation. The key value of the
         *        <code>Name</code> tag appears in the console as the file system name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag
         * appears in the console as the file system name.
         * </p>
         * 
         * @param tags
         *        The tags to be applied to the file system at file system creation. The key value of the
         *        <code>Name</code> tag appears in the console as the file system name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be applied to the file system at file system creation. The key value of the <code>Name</code> tag
         * appears in the console as the file system name.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The configuration for this Microsoft Windows file system.
         * </p>
         * 
         * @param windowsConfiguration
         *        The configuration for this Microsoft Windows file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowsConfiguration(CreateFileSystemWindowsConfiguration windowsConfiguration);

        /**
         * <p>
         * The configuration for this Microsoft Windows file system.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateFileSystemWindowsConfiguration.Builder} avoiding the need to create one manually via
         * {@link CreateFileSystemWindowsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateFileSystemWindowsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #windowsConfiguration(CreateFileSystemWindowsConfiguration)}.
         * 
         * @param windowsConfiguration
         *        a consumer that will call methods on {@link CreateFileSystemWindowsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowsConfiguration(CreateFileSystemWindowsConfiguration)
         */
        default Builder windowsConfiguration(Consumer<CreateFileSystemWindowsConfiguration.Builder> windowsConfiguration) {
            return windowsConfiguration(CreateFileSystemWindowsConfiguration.builder().applyMutation(windowsConfiguration)
                    .build());
        }

        /**
         * Sets the value of the LustreConfiguration property for this object.
         *
         * @param lustreConfiguration
         *        The new value for the LustreConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lustreConfiguration(CreateFileSystemLustreConfiguration lustreConfiguration);

        /**
         * Sets the value of the LustreConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CreateFileSystemLustreConfiguration.Builder} avoiding the need to create one manually via
         * {@link CreateFileSystemLustreConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateFileSystemLustreConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lustreConfiguration(CreateFileSystemLustreConfiguration)}.
         * 
         * @param lustreConfiguration
         *        a consumer that will call methods on {@link CreateFileSystemLustreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lustreConfiguration(CreateFileSystemLustreConfiguration)
         */
        default Builder lustreConfiguration(Consumer<CreateFileSystemLustreConfiguration.Builder> lustreConfiguration) {
            return lustreConfiguration(CreateFileSystemLustreConfiguration.builder().applyMutation(lustreConfiguration).build());
        }

        /**
         * <p>
         * Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values
         * are <code>SSD</code> and <code>HDD</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS
         * deployment types.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and
         * <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default value is <code>SSD</code>.
         * </p>
         * <note>
         * <p>
         * HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's
         * storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD
         * storage from a backup of a file system that used SSD storage if the original SSD file system had a storage
         * capacity of at least 2000 GiB.
         * </p>
         * </note>
         * 
         * @param storageType
         *        Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid
         *        values are <code>SSD</code> and <code>HDD</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS
         *        deployment types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code>
         *        and <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default value is <code>SSD</code>.
         *        </p>
         *        <note>
         *        <p>
         *        HDD and SSD storage types have different minimum storage capacity requirements. A restored file
         *        system's storage capacity is tied to the file system that was backed up. You can create a file system
         *        that uses HDD storage from a backup of a file system that used SSD storage if the original SSD file
         *        system had a storage capacity of at least 2000 GiB.
         *        </p>
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid values
         * are <code>SSD</code> and <code>HDD</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS
         * deployment types.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code> and
         * <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default value is <code>SSD</code>.
         * </p>
         * <note>
         * <p>
         * HDD and SSD storage types have different minimum storage capacity requirements. A restored file system's
         * storage capacity is tied to the file system that was backed up. You can create a file system that uses HDD
         * storage from a backup of a file system that used SSD storage if the original SSD file system had a storage
         * capacity of at least 2000 GiB.
         * </p>
         * </note>
         * 
         * @param storageType
         *        Sets the storage type for the Windows or OpenZFS file system that you're creating from a backup. Valid
         *        values are <code>SSD</code> and <code>HDD</code>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set to <code>SSD</code> to use solid state drive storage. SSD is supported on all Windows and OpenZFS
         *        deployment types.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set to <code>HDD</code> to use hard disk drive storage. HDD is supported on <code>SINGLE_AZ_2</code>
         *        and <code>MULTI_AZ_1</code> FSx for Windows File Server file system deployment types.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default value is <code>SSD</code>.
         *        </p>
         *        <note>
         *        <p>
         *        HDD and SSD storage types have different minimum storage capacity requirements. A restored file
         *        system's storage capacity is tied to the file system that was backed up. You can create a file system
         *        that uses HDD storage from a backup of a file system that used SSD storage if the original SSD file
         *        system had a storage capacity of at least 2000 GiB.
         *        </p>
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * Sets the value of the KmsKeyId property for this object.
         *
         * @param kmsKeyId
         *        The new value for the KmsKeyId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid values
         * are <code>2.10</code>, <code>2.12</code>, and <code>2.15</code>.
         * </p>
         * <p>
         * You can enter a Lustre version that is newer than the backup's <code>FileSystemTypeVersion</code> setting. If
         * you don't enter a newer Lustre version, it defaults to the backup's setting.
         * </p>
         * 
         * @param fileSystemTypeVersion
         *        Sets the version for the Amazon FSx for Lustre file system that you're creating from a backup. Valid
         *        values are <code>2.10</code>, <code>2.12</code>, and <code>2.15</code>.</p>
         *        <p>
         *        You can enter a Lustre version that is newer than the backup's <code>FileSystemTypeVersion</code>
         *        setting. If you don't enter a newer Lustre version, it defaults to the backup's setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemTypeVersion(String fileSystemTypeVersion);

        /**
         * <p>
         * The OpenZFS configuration for the file system that's being created.
         * </p>
         * 
         * @param openZFSConfiguration
         *        The OpenZFS configuration for the file system that's being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSConfiguration(CreateFileSystemOpenZFSConfiguration openZFSConfiguration);

        /**
         * <p>
         * The OpenZFS configuration for the file system that's being created.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateFileSystemOpenZFSConfiguration.Builder} avoiding the need to create one manually via
         * {@link CreateFileSystemOpenZFSConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateFileSystemOpenZFSConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #openZFSConfiguration(CreateFileSystemOpenZFSConfiguration)}.
         * 
         * @param openZFSConfiguration
         *        a consumer that will call methods on {@link CreateFileSystemOpenZFSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSConfiguration(CreateFileSystemOpenZFSConfiguration)
         */
        default Builder openZFSConfiguration(Consumer<CreateFileSystemOpenZFSConfiguration.Builder> openZFSConfiguration) {
            return openZFSConfiguration(CreateFileSystemOpenZFSConfiguration.builder().applyMutation(openZFSConfiguration)
                    .build());
        }

        /**
         * <p>
         * Sets the storage capacity of the OpenZFS file system that you're creating from a backup, in gibibytes (GiB).
         * Valid values are from 64 GiB up to 524,288 GiB (512 TiB). However, the value that you specify must be equal
         * to or greater than the backup's storage capacity value. If you don't use the <code>StorageCapacity</code>
         * parameter, the default is the backup's <code>StorageCapacity</code> value.
         * </p>
         * <p>
         * If used to create a file system other than OpenZFS, you must provide a value that matches the backup's
         * <code>StorageCapacity</code> value. If you provide any other value, Amazon FSx responds with an HTTP status
         * code 400 Bad Request.
         * </p>
         * 
         * @param storageCapacity
         *        Sets the storage capacity of the OpenZFS file system that you're creating from a backup, in gibibytes
         *        (GiB). Valid values are from 64 GiB up to 524,288 GiB (512 TiB). However, the value that you specify
         *        must be equal to or greater than the backup's storage capacity value. If you don't use the
         *        <code>StorageCapacity</code> parameter, the default is the backup's <code>StorageCapacity</code>
         *        value.</p>
         *        <p>
         *        If used to create a file system other than OpenZFS, you must provide a value that matches the backup's
         *        <code>StorageCapacity</code> value. If you provide any other value, Amazon FSx responds with an HTTP
         *        status code 400 Bad Request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String backupId;

        private String clientRequestToken;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private CreateFileSystemWindowsConfiguration windowsConfiguration;

        private CreateFileSystemLustreConfiguration lustreConfiguration;

        private String storageType;

        private String kmsKeyId;

        private String fileSystemTypeVersion;

        private CreateFileSystemOpenZFSConfiguration openZFSConfiguration;

        private Integer storageCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFileSystemFromBackupRequest model) {
            super(model);
            backupId(model.backupId);
            clientRequestToken(model.clientRequestToken);
            subnetIds(model.subnetIds);
            securityGroupIds(model.securityGroupIds);
            tags(model.tags);
            windowsConfiguration(model.windowsConfiguration);
            lustreConfiguration(model.lustreConfiguration);
            storageType(model.storageType);
            kmsKeyId(model.kmsKeyId);
            fileSystemTypeVersion(model.fileSystemTypeVersion);
            openZFSConfiguration(model.openZFSConfiguration);
            storageCapacity(model.storageCapacity);
        }

        public final String getBackupId() {
            return backupId;
        }

        public final void setBackupId(String backupId) {
            this.backupId = backupId;
        }

        @Override
        public final Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CreateFileSystemWindowsConfiguration.Builder getWindowsConfiguration() {
            return windowsConfiguration != null ? windowsConfiguration.toBuilder() : null;
        }

        public final void setWindowsConfiguration(CreateFileSystemWindowsConfiguration.BuilderImpl windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration != null ? windowsConfiguration.build() : null;
        }

        @Override
        public final Builder windowsConfiguration(CreateFileSystemWindowsConfiguration windowsConfiguration) {
            this.windowsConfiguration = windowsConfiguration;
            return this;
        }

        public final CreateFileSystemLustreConfiguration.Builder getLustreConfiguration() {
            return lustreConfiguration != null ? lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(CreateFileSystemLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public final Builder lustreConfiguration(CreateFileSystemLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getFileSystemTypeVersion() {
            return fileSystemTypeVersion;
        }

        public final void setFileSystemTypeVersion(String fileSystemTypeVersion) {
            this.fileSystemTypeVersion = fileSystemTypeVersion;
        }

        @Override
        public final Builder fileSystemTypeVersion(String fileSystemTypeVersion) {
            this.fileSystemTypeVersion = fileSystemTypeVersion;
            return this;
        }

        public final CreateFileSystemOpenZFSConfiguration.Builder getOpenZFSConfiguration() {
            return openZFSConfiguration != null ? openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(CreateFileSystemOpenZFSConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(CreateFileSystemOpenZFSConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFileSystemFromBackupRequest build() {
            return new CreateFileSystemFromBackupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
