/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDataRepositoryAssociationRequest extends FSxRequest implements
        ToCopyableBuilder<DeleteDataRepositoryAssociationRequest.Builder, DeleteDataRepositoryAssociationRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(DeleteDataRepositoryAssociationRequest::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(DeleteDataRepositoryAssociationRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Boolean> DELETE_DATA_IN_FILE_SYSTEM_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteDataInFileSystem").getter(getter(DeleteDataRepositoryAssociationRequest::deleteDataInFileSystem))
            .setter(setter(Builder::deleteDataInFileSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteDataInFileSystem").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            CLIENT_REQUEST_TOKEN_FIELD, DELETE_DATA_IN_FILE_SYSTEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String associationId;

    private final String clientRequestToken;

    private final Boolean deleteDataInFileSystem;

    private DeleteDataRepositoryAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.clientRequestToken = builder.clientRequestToken;
        this.deleteDataInFileSystem = builder.deleteDataInFileSystem;
    }

    /**
     * <p>
     * The ID of the data repository association that you want to delete.
     * </p>
     * 
     * @return The ID of the data repository association that you want to delete.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * Set to <code>true</code> to delete the data in the file system that corresponds to the data repository
     * association.
     * </p>
     * 
     * @return Set to <code>true</code> to delete the data in the file system that corresponds to the data repository
     *         association.
     */
    public final Boolean deleteDataInFileSystem() {
        return deleteDataInFileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(deleteDataInFileSystem());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataRepositoryAssociationRequest)) {
            return false;
        }
        DeleteDataRepositoryAssociationRequest other = (DeleteDataRepositoryAssociationRequest) obj;
        return Objects.equals(associationId(), other.associationId())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(deleteDataInFileSystem(), other.deleteDataInFileSystem());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteDataRepositoryAssociationRequest").add("AssociationId", associationId())
                .add("ClientRequestToken", clientRequestToken()).add("DeleteDataInFileSystem", deleteDataInFileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "DeleteDataInFileSystem":
            return Optional.ofNullable(clazz.cast(deleteDataInFileSystem()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociationId", ASSOCIATION_ID_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("DeleteDataInFileSystem", DELETE_DATA_IN_FILE_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataRepositoryAssociationRequest, T> g) {
        return obj -> g.apply((DeleteDataRepositoryAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDataRepositoryAssociationRequest> {
        /**
         * <p>
         * The ID of the data repository association that you want to delete.
         * </p>
         * 
         * @param associationId
         *        The ID of the data repository association that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * Set to <code>true</code> to delete the data in the file system that corresponds to the data repository
         * association.
         * </p>
         * 
         * @param deleteDataInFileSystem
         *        Set to <code>true</code> to delete the data in the file system that corresponds to the data repository
         *        association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteDataInFileSystem(Boolean deleteDataInFileSystem);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String associationId;

        private String clientRequestToken;

        private Boolean deleteDataInFileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataRepositoryAssociationRequest model) {
            super(model);
            associationId(model.associationId);
            clientRequestToken(model.clientRequestToken);
            deleteDataInFileSystem(model.deleteDataInFileSystem);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final Boolean getDeleteDataInFileSystem() {
            return deleteDataInFileSystem;
        }

        public final void setDeleteDataInFileSystem(Boolean deleteDataInFileSystem) {
            this.deleteDataInFileSystem = deleteDataInFileSystem;
        }

        @Override
        public final Builder deleteDataInFileSystem(Boolean deleteDataInFileSystem) {
            this.deleteDataInFileSystem = deleteDataInFileSystem;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteDataRepositoryAssociationRequest build() {
            return new DeleteDataRepositoryAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
