/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration object for the Amazon FSx for OpenZFS file system used in the <code>DeleteFileSystem</code>
 * operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteFileSystemOpenZFSConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteFileSystemOpenZFSConfiguration.Builder, DeleteFileSystemOpenZFSConfiguration> {
    private static final SdkField<Boolean> SKIP_FINAL_BACKUP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SkipFinalBackup").getter(getter(DeleteFileSystemOpenZFSConfiguration::skipFinalBackup))
            .setter(setter(Builder::skipFinalBackup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkipFinalBackup").build()).build();

    private static final SdkField<List<Tag>> FINAL_BACKUP_TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("FinalBackupTags")
            .getter(getter(DeleteFileSystemOpenZFSConfiguration::finalBackupTags))
            .setter(setter(Builder::finalBackupTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FinalBackupTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(DeleteFileSystemOpenZFSConfiguration::optionsAsStrings))
            .setter(setter(Builder::optionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKIP_FINAL_BACKUP_FIELD,
            FINAL_BACKUP_TAGS_FIELD, OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean skipFinalBackup;

    private final List<Tag> finalBackupTags;

    private final List<String> options;

    private DeleteFileSystemOpenZFSConfiguration(BuilderImpl builder) {
        this.skipFinalBackup = builder.skipFinalBackup;
        this.finalBackupTags = builder.finalBackupTags;
        this.options = builder.options;
    }

    /**
     * <p>
     * By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the <code>DeleteFileSystem</code>
     * operation is invoked. Doing this helps protect you from data loss, and we highly recommend taking the final
     * backup. If you want to skip taking a final backup, set this value to <code>true</code>.
     * </p>
     * 
     * @return By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the
     *         <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you from data loss, and we
     *         highly recommend taking the final backup. If you want to skip taking a final backup, set this value to
     *         <code>true</code>.
     */
    public final Boolean skipFinalBackup() {
        return skipFinalBackup;
    }

    /**
     * For responses, this returns true if the service returned a value for the FinalBackupTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFinalBackupTags() {
        return finalBackupTags != null && !(finalBackupTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to apply to the file system's final backup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFinalBackupTags} method.
     * </p>
     * 
     * @return A list of tags to apply to the file system's final backup.
     */
    public final List<Tag> finalBackupTags() {
        return finalBackupTags;
    }

    /**
     * <p>
     * To delete a file system if there are child volumes present below the root volume, use the string
     * <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't use this
     * option, the delete request will fail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return To delete a file system if there are child volumes present below the root volume, use the string
     *         <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't use
     *         this option, the delete request will fail.
     */
    public final List<DeleteFileSystemOpenZFSOption> options() {
        return DeleteFileSystemOpenZFSOptionsCopier.copyStringToEnum(options);
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * To delete a file system if there are child volumes present below the root volume, use the string
     * <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't use this
     * option, the delete request will fail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return To delete a file system if there are child volumes present below the root volume, use the string
     *         <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't use
     *         this option, the delete request will fail.
     */
    public final List<String> optionsAsStrings() {
        return options;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(skipFinalBackup());
        hashCode = 31 * hashCode + Objects.hashCode(hasFinalBackupTags() ? finalBackupTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? optionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileSystemOpenZFSConfiguration)) {
            return false;
        }
        DeleteFileSystemOpenZFSConfiguration other = (DeleteFileSystemOpenZFSConfiguration) obj;
        return Objects.equals(skipFinalBackup(), other.skipFinalBackup()) && hasFinalBackupTags() == other.hasFinalBackupTags()
                && Objects.equals(finalBackupTags(), other.finalBackupTags()) && hasOptions() == other.hasOptions()
                && Objects.equals(optionsAsStrings(), other.optionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteFileSystemOpenZFSConfiguration").add("SkipFinalBackup", skipFinalBackup())
                .add("FinalBackupTags", hasFinalBackupTags() ? finalBackupTags() : null)
                .add("Options", hasOptions() ? optionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SkipFinalBackup":
            return Optional.ofNullable(clazz.cast(skipFinalBackup()));
        case "FinalBackupTags":
            return Optional.ofNullable(clazz.cast(finalBackupTags()));
        case "Options":
            return Optional.ofNullable(clazz.cast(optionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SkipFinalBackup", SKIP_FINAL_BACKUP_FIELD);
        map.put("FinalBackupTags", FINAL_BACKUP_TAGS_FIELD);
        map.put("Options", OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileSystemOpenZFSConfiguration, T> g) {
        return obj -> g.apply((DeleteFileSystemOpenZFSConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteFileSystemOpenZFSConfiguration> {
        /**
         * <p>
         * By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the <code>DeleteFileSystem</code>
         * operation is invoked. Doing this helps protect you from data loss, and we highly recommend taking the final
         * backup. If you want to skip taking a final backup, set this value to <code>true</code>.
         * </p>
         * 
         * @param skipFinalBackup
         *        By default, Amazon FSx for OpenZFS takes a final backup on your behalf when the
         *        <code>DeleteFileSystem</code> operation is invoked. Doing this helps protect you from data loss, and
         *        we highly recommend taking the final backup. If you want to skip taking a final backup, set this value
         *        to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipFinalBackup(Boolean skipFinalBackup);

        /**
         * <p>
         * A list of tags to apply to the file system's final backup.
         * </p>
         * 
         * @param finalBackupTags
         *        A list of tags to apply to the file system's final backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Collection<Tag> finalBackupTags);

        /**
         * <p>
         * A list of tags to apply to the file system's final backup.
         * </p>
         * 
         * @param finalBackupTags
         *        A list of tags to apply to the file system's final backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder finalBackupTags(Tag... finalBackupTags);

        /**
         * <p>
         * A list of tags to apply to the file system's final backup.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.fsx.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.fsx.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #finalBackupTags(List<Tag>)}.
         * 
         * @param finalBackupTags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.fsx.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #finalBackupTags(java.util.Collection<Tag>)
         */
        Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags);

        /**
         * <p>
         * To delete a file system if there are child volumes present below the root volume, use the string
         * <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't use this
         * option, the delete request will fail.
         * </p>
         * 
         * @param options
         *        To delete a file system if there are child volumes present below the root volume, use the string
         *        <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't
         *        use this option, the delete request will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(Collection<String> options);

        /**
         * <p>
         * To delete a file system if there are child volumes present below the root volume, use the string
         * <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't use this
         * option, the delete request will fail.
         * </p>
         * 
         * @param options
         *        To delete a file system if there are child volumes present below the root volume, use the string
         *        <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't
         *        use this option, the delete request will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionsWithStrings(String... options);

        /**
         * <p>
         * To delete a file system if there are child volumes present below the root volume, use the string
         * <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't use this
         * option, the delete request will fail.
         * </p>
         * 
         * @param options
         *        To delete a file system if there are child volumes present below the root volume, use the string
         *        <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't
         *        use this option, the delete request will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<DeleteFileSystemOpenZFSOption> options);

        /**
         * <p>
         * To delete a file system if there are child volumes present below the root volume, use the string
         * <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't use this
         * option, the delete request will fail.
         * </p>
         * 
         * @param options
         *        To delete a file system if there are child volumes present below the root volume, use the string
         *        <code>DELETE_CHILD_VOLUMES_AND_SNAPSHOTS</code>. If your file system has child volumes and you don't
         *        use this option, the delete request will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(DeleteFileSystemOpenZFSOption... options);
    }

    static final class BuilderImpl implements Builder {
        private Boolean skipFinalBackup;

        private List<Tag> finalBackupTags = DefaultSdkAutoConstructList.getInstance();

        private List<String> options = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileSystemOpenZFSConfiguration model) {
            skipFinalBackup(model.skipFinalBackup);
            finalBackupTags(model.finalBackupTags);
            optionsWithStrings(model.options);
        }

        public final Boolean getSkipFinalBackup() {
            return skipFinalBackup;
        }

        public final void setSkipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
        }

        @Override
        public final Builder skipFinalBackup(Boolean skipFinalBackup) {
            this.skipFinalBackup = skipFinalBackup;
            return this;
        }

        public final List<Tag.Builder> getFinalBackupTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.finalBackupTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFinalBackupTags(Collection<Tag.BuilderImpl> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copyFromBuilder(finalBackupTags);
        }

        @Override
        public final Builder finalBackupTags(Collection<Tag> finalBackupTags) {
            this.finalBackupTags = TagsCopier.copy(finalBackupTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Tag... finalBackupTags) {
            finalBackupTags(Arrays.asList(finalBackupTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder finalBackupTags(Consumer<Tag.Builder>... finalBackupTags) {
            finalBackupTags(Stream.of(finalBackupTags).map(c -> Tag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOptions() {
            if (options instanceof SdkAutoConstructList) {
                return null;
            }
            return options;
        }

        public final void setOptions(Collection<String> options) {
            this.options = DeleteFileSystemOpenZFSOptionsCopier.copy(options);
        }

        @Override
        public final Builder optionsWithStrings(Collection<String> options) {
            this.options = DeleteFileSystemOpenZFSOptionsCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionsWithStrings(String... options) {
            optionsWithStrings(Arrays.asList(options));
            return this;
        }

        @Override
        public final Builder options(Collection<DeleteFileSystemOpenZFSOption> options) {
            this.options = DeleteFileSystemOpenZFSOptionsCopier.copyEnumToString(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(DeleteFileSystemOpenZFSOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        public DeleteFileSystemOpenZFSConfiguration build() {
            return new DeleteFileSystemOpenZFSConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
