/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataRepositoryTasksRequest extends FSxRequest implements
        ToCopyableBuilder<DescribeDataRepositoryTasksRequest.Builder, DescribeDataRepositoryTasksRequest> {
    private static final SdkField<List<String>> TASK_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TaskIds")
            .getter(getter(DescribeDataRepositoryTasksRequest::taskIds))
            .setter(setter(Builder::taskIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<DataRepositoryTaskFilter>> FILTERS_FIELD = SdkField
            .<List<DataRepositoryTaskFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeDataRepositoryTasksRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataRepositoryTaskFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataRepositoryTaskFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeDataRepositoryTasksRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDataRepositoryTasksRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_IDS_FIELD, FILTERS_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> taskIds;

    private final List<DataRepositoryTaskFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeDataRepositoryTasksRequest(BuilderImpl builder) {
        super(builder);
        this.taskIds = builder.taskIds;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTaskIds() {
        return taskIds != null && !(taskIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) IDs of the tasks whose descriptions you want to retrieve (String).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskIds} method.
     * </p>
     * 
     * @return (Optional) IDs of the tasks whose descriptions you want to retrieve (String).
     */
    public final List<String> taskIds() {
        return taskIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include just
     * tasks for specific file systems, or tasks in a specific lifecycle state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return (Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include
     *         just tasks for specific file systems, or tasks in a specific lifecycle state.
     */
    public final List<DataRepositoryTaskFilter> filters() {
        return filters;
    }

    /**
     * Returns the value of the MaxResults property for this object.
     * 
     * @return The value of the MaxResults property for this object.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskIds() ? taskIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataRepositoryTasksRequest)) {
            return false;
        }
        DescribeDataRepositoryTasksRequest other = (DescribeDataRepositoryTasksRequest) obj;
        return hasTaskIds() == other.hasTaskIds() && Objects.equals(taskIds(), other.taskIds())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataRepositoryTasksRequest").add("TaskIds", hasTaskIds() ? taskIds() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TaskIds":
            return Optional.ofNullable(clazz.cast(taskIds()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TaskIds", TASK_IDS_FIELD);
        map.put("Filters", FILTERS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataRepositoryTasksRequest, T> g) {
        return obj -> g.apply((DescribeDataRepositoryTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDataRepositoryTasksRequest> {
        /**
         * <p>
         * (Optional) IDs of the tasks whose descriptions you want to retrieve (String).
         * </p>
         * 
         * @param taskIds
         *        (Optional) IDs of the tasks whose descriptions you want to retrieve (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIds(Collection<String> taskIds);

        /**
         * <p>
         * (Optional) IDs of the tasks whose descriptions you want to retrieve (String).
         * </p>
         * 
         * @param taskIds
         *        (Optional) IDs of the tasks whose descriptions you want to retrieve (String).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIds(String... taskIds);

        /**
         * <p>
         * (Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include
         * just tasks for specific file systems, or tasks in a specific lifecycle state.
         * </p>
         * 
         * @param filters
         *        (Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to
         *        include just tasks for specific file systems, or tasks in a specific lifecycle state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<DataRepositoryTaskFilter> filters);

        /**
         * <p>
         * (Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include
         * just tasks for specific file systems, or tasks in a specific lifecycle state.
         * </p>
         * 
         * @param filters
         *        (Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to
         *        include just tasks for specific file systems, or tasks in a specific lifecycle state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(DataRepositoryTaskFilter... filters);

        /**
         * <p>
         * (Optional) You can use filters to narrow the <code>DescribeDataRepositoryTasks</code> response to include
         * just tasks for specific file systems, or tasks in a specific lifecycle state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<DataRepositoryTaskFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<DataRepositoryTaskFilter>)
         */
        Builder filters(Consumer<DataRepositoryTaskFilter.Builder>... filters);

        /**
         * Sets the value of the MaxResults property for this object.
         *
         * @param maxResults
         *        The new value for the MaxResults property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private List<String> taskIds = DefaultSdkAutoConstructList.getInstance();

        private List<DataRepositoryTaskFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataRepositoryTasksRequest model) {
            super(model);
            taskIds(model.taskIds);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getTaskIds() {
            if (taskIds instanceof SdkAutoConstructList) {
                return null;
            }
            return taskIds;
        }

        public final void setTaskIds(Collection<String> taskIds) {
            this.taskIds = TaskIdsCopier.copy(taskIds);
        }

        @Override
        public final Builder taskIds(Collection<String> taskIds) {
            this.taskIds = TaskIdsCopier.copy(taskIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIds(String... taskIds) {
            taskIds(Arrays.asList(taskIds));
            return this;
        }

        public final List<DataRepositoryTaskFilter.Builder> getFilters() {
            List<DataRepositoryTaskFilter.Builder> result = DataRepositoryTaskFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<DataRepositoryTaskFilter.BuilderImpl> filters) {
            this.filters = DataRepositoryTaskFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<DataRepositoryTaskFilter> filters) {
            this.filters = DataRepositoryTaskFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(DataRepositoryTaskFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<DataRepositoryTaskFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> DataRepositoryTaskFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDataRepositoryTasksRequest build() {
            return new DescribeDataRepositoryTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
