/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a Lustre MDT (Metadata Target) storage volume. The metadata on Amazon File Cache is managed by
 * a Lustre Metadata Server (MDS) while the actual metadata is persisted on an MDT.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileCacheLustreMetadataConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FileCacheLustreMetadataConfiguration.Builder, FileCacheLustreMetadataConfiguration> {
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StorageCapacity").getter(getter(FileCacheLustreMetadataConfiguration::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer storageCapacity;

    private FileCacheLustreMetadataConfiguration(BuilderImpl builder) {
        this.storageCapacity = builder.storageCapacity;
    }

    /**
     * <p>
     * The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only supported
     * value is <code>2400</code> GiB.
     * </p>
     * 
     * @return The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only
     *         supported value is <code>2400</code> GiB.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileCacheLustreMetadataConfiguration)) {
            return false;
        }
        FileCacheLustreMetadataConfiguration other = (FileCacheLustreMetadataConfiguration) obj;
        return Objects.equals(storageCapacity(), other.storageCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileCacheLustreMetadataConfiguration").add("StorageCapacity", storageCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StorageCapacity", STORAGE_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileCacheLustreMetadataConfiguration, T> g) {
        return obj -> g.apply((FileCacheLustreMetadataConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileCacheLustreMetadataConfiguration> {
        /**
         * <p>
         * The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only
         * supported value is <code>2400</code> GiB.
         * </p>
         * 
         * @param storageCapacity
         *        The storage capacity of the Lustre MDT (Metadata Target) storage volume in gibibytes (GiB). The only
         *        supported value is <code>2400</code> GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);
    }

    static final class BuilderImpl implements Builder {
        private Integer storageCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(FileCacheLustreMetadataConfiguration model) {
            storageCapacity(model.storageCapacity);
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        @Override
        public FileCacheLustreMetadataConfiguration build() {
            return new FileCacheLustreMetadataConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
