/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration that specifies a minimum amount of time since last access for an exported file to be eligible for
 * release from an Amazon FSx for Lustre file system. Only files that were last accessed before this point-in-time can
 * be released. For example, if you specify a last accessed time criteria of 9 days, only files that were last accessed
 * 9.00001 or more days ago can be released.
 * </p>
 * <p>
 * Only file data that has been exported to S3 can be released. Files that have not yet been exported to S3, such as new
 * or changed files that have not been exported, are not eligible for release. When files are released, their metadata
 * stays on the file system, so they can still be accessed later. Users and applications can access a released file by
 * reading the file again, which restores data from Amazon S3 to the FSx for Lustre file system.
 * </p>
 * <note>
 * <p>
 * If a file meets the last accessed time criteria, its file or directory path must also be specified with the
 * <code>Paths</code> parameter of the operation in order for the file to be released.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReleaseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ReleaseConfiguration.Builder, ReleaseConfiguration> {
    private static final SdkField<DurationSinceLastAccess> DURATION_SINCE_LAST_ACCESS_FIELD = SdkField
            .<DurationSinceLastAccess> builder(MarshallingType.SDK_POJO).memberName("DurationSinceLastAccess")
            .getter(getter(ReleaseConfiguration::durationSinceLastAccess)).setter(setter(Builder::durationSinceLastAccess))
            .constructor(DurationSinceLastAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSinceLastAccess").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DURATION_SINCE_LAST_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DurationSinceLastAccess durationSinceLastAccess;

    private ReleaseConfiguration(BuilderImpl builder) {
        this.durationSinceLastAccess = builder.durationSinceLastAccess;
    }

    /**
     * <p>
     * Defines the point-in-time since an exported file was last accessed, in order for that file to be eligible for
     * release. Only files that were last accessed before this point-in-time are eligible to be released from the file
     * system.
     * </p>
     * 
     * @return Defines the point-in-time since an exported file was last accessed, in order for that file to be eligible
     *         for release. Only files that were last accessed before this point-in-time are eligible to be released
     *         from the file system.
     */
    public final DurationSinceLastAccess durationSinceLastAccess() {
        return durationSinceLastAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationSinceLastAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseConfiguration)) {
            return false;
        }
        ReleaseConfiguration other = (ReleaseConfiguration) obj;
        return Objects.equals(durationSinceLastAccess(), other.durationSinceLastAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReleaseConfiguration").add("DurationSinceLastAccess", durationSinceLastAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationSinceLastAccess":
            return Optional.ofNullable(clazz.cast(durationSinceLastAccess()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DurationSinceLastAccess", DURATION_SINCE_LAST_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ReleaseConfiguration, T> g) {
        return obj -> g.apply((ReleaseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReleaseConfiguration> {
        /**
         * <p>
         * Defines the point-in-time since an exported file was last accessed, in order for that file to be eligible for
         * release. Only files that were last accessed before this point-in-time are eligible to be released from the
         * file system.
         * </p>
         * 
         * @param durationSinceLastAccess
         *        Defines the point-in-time since an exported file was last accessed, in order for that file to be
         *        eligible for release. Only files that were last accessed before this point-in-time are eligible to be
         *        released from the file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSinceLastAccess(DurationSinceLastAccess durationSinceLastAccess);

        /**
         * <p>
         * Defines the point-in-time since an exported file was last accessed, in order for that file to be eligible for
         * release. Only files that were last accessed before this point-in-time are eligible to be released from the
         * file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link DurationSinceLastAccess.Builder} avoiding
         * the need to create one manually via {@link DurationSinceLastAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DurationSinceLastAccess.Builder#build()} is called immediately
         * and its result is passed to {@link #durationSinceLastAccess(DurationSinceLastAccess)}.
         * 
         * @param durationSinceLastAccess
         *        a consumer that will call methods on {@link DurationSinceLastAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #durationSinceLastAccess(DurationSinceLastAccess)
         */
        default Builder durationSinceLastAccess(Consumer<DurationSinceLastAccess.Builder> durationSinceLastAccess) {
            return durationSinceLastAccess(DurationSinceLastAccess.builder().applyMutation(durationSinceLastAccess).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DurationSinceLastAccess durationSinceLastAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseConfiguration model) {
            durationSinceLastAccess(model.durationSinceLastAccess);
        }

        public final DurationSinceLastAccess.Builder getDurationSinceLastAccess() {
            return durationSinceLastAccess != null ? durationSinceLastAccess.toBuilder() : null;
        }

        public final void setDurationSinceLastAccess(DurationSinceLastAccess.BuilderImpl durationSinceLastAccess) {
            this.durationSinceLastAccess = durationSinceLastAccess != null ? durationSinceLastAccess.build() : null;
        }

        @Override
        public final Builder durationSinceLastAccess(DurationSinceLastAccess durationSinceLastAccess) {
            this.durationSinceLastAccess = durationSinceLastAccess;
            return this;
        }

        @Override
        public ReleaseConfiguration build() {
            return new ReleaseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
