/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies changes you are making to the self-managed Microsoft Active Directory configuration to which an FSx for
 * Windows File Server file system or an FSx for ONTAP SVM is joined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfManagedActiveDirectoryConfigurationUpdates implements SdkPojo, Serializable,
        ToCopyableBuilder<SelfManagedActiveDirectoryConfigurationUpdates.Builder, SelfManagedActiveDirectoryConfigurationUpdates> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(SelfManagedActiveDirectoryConfigurationUpdates::userName))
            .setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(SelfManagedActiveDirectoryConfigurationUpdates::password))
            .setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<List<String>> DNS_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsIps")
            .getter(getter(SelfManagedActiveDirectoryConfigurationUpdates::dnsIps))
            .setter(setter(Builder::dnsIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(SelfManagedActiveDirectoryConfigurationUpdates::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitDistinguishedName")
            .getter(getter(SelfManagedActiveDirectoryConfigurationUpdates::organizationalUnitDistinguishedName))
            .setter(setter(Builder::organizationalUnitDistinguishedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OrganizationalUnitDistinguishedName").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ADMINISTRATORS_GROUP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FileSystemAdministratorsGroup")
            .getter(getter(SelfManagedActiveDirectoryConfigurationUpdates::fileSystemAdministratorsGroup))
            .setter(setter(Builder::fileSystemAdministratorsGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemAdministratorsGroup")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            PASSWORD_FIELD, DNS_IPS_FIELD, DOMAIN_NAME_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD,
            FILE_SYSTEM_ADMINISTRATORS_GROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String password;

    private final List<String> dnsIps;

    private final String domainName;

    private final String organizationalUnitDistinguishedName;

    private final String fileSystemAdministratorsGroup;

    private SelfManagedActiveDirectoryConfigurationUpdates(BuilderImpl builder) {
        this.userName = builder.userName;
        this.password = builder.password;
        this.dnsIps = builder.dnsIps;
        this.domainName = builder.domainName;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
        this.fileSystemAdministratorsGroup = builder.fileSystemAdministratorsGroup;
    }

    /**
     * <p>
     * Specifies the updated user name for the service account on your self-managed Active Directory domain. Amazon FSx
     * uses this account to join to your self-managed Active Directory domain.
     * </p>
     * <p>
     * This account must have the permissions required to join computers to the domain in the organizational unit
     * provided in <code>OrganizationalUnitDistinguishedName</code>.
     * </p>
     * 
     * @return Specifies the updated user name for the service account on your self-managed Active Directory domain.
     *         Amazon FSx uses this account to join to your self-managed Active Directory domain.</p>
     *         <p>
     *         This account must have the permissions required to join computers to the domain in the organizational
     *         unit provided in <code>OrganizationalUnitDistinguishedName</code>.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * Specifies the updated password for the service account on your self-managed Active Directory domain. Amazon FSx
     * uses this account to join to your self-managed Active Directory domain.
     * </p>
     * 
     * @return Specifies the updated password for the service account on your self-managed Active Directory domain.
     *         Amazon FSx uses this account to join to your self-managed Active Directory domain.
     */
    public final String password() {
        return password;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDnsIps() {
        return dnsIps != null && !(dnsIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of up to three DNS server or domain controller IP addresses in your self-managed Active Directory domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsIps} method.
     * </p>
     * 
     * @return A list of up to three DNS server or domain controller IP addresses in your self-managed Active Directory
     *         domain.
     */
    public final List<String> dnsIps() {
        return dnsIps;
    }

    /**
     * <p>
     * Specifies an updated fully qualified domain name of your self-managed Active Directory configuration.
     * </p>
     * 
     * @return Specifies an updated fully qualified domain name of your self-managed Active Directory configuration.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Specifies an updated fully qualified distinguished name of the organization unit within your self-managed Active
     * Directory.
     * </p>
     * 
     * @return Specifies an updated fully qualified distinguished name of the organization unit within your self-managed
     *         Active Directory.
     */
    public final String organizationalUnitDistinguishedName() {
        return organizationalUnitDistinguishedName;
    }

    /**
     * <p>
     * For FSx for ONTAP file systems only - Specifies the updated name of the self-managed Active Directory domain
     * group whose members are granted administrative privileges for the Amazon FSx resource.
     * </p>
     * 
     * @return For FSx for ONTAP file systems only - Specifies the updated name of the self-managed Active Directory
     *         domain group whose members are granted administrative privileges for the Amazon FSx resource.
     */
    public final String fileSystemAdministratorsGroup() {
        return fileSystemAdministratorsGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsIps() ? dnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitDistinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAdministratorsGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfManagedActiveDirectoryConfigurationUpdates)) {
            return false;
        }
        SelfManagedActiveDirectoryConfigurationUpdates other = (SelfManagedActiveDirectoryConfigurationUpdates) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(password(), other.password())
                && hasDnsIps() == other.hasDnsIps() && Objects.equals(dnsIps(), other.dnsIps())
                && Objects.equals(domainName(), other.domainName())
                && Objects.equals(organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName())
                && Objects.equals(fileSystemAdministratorsGroup(), other.fileSystemAdministratorsGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfManagedActiveDirectoryConfigurationUpdates").add("UserName", userName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DnsIps", hasDnsIps() ? dnsIps() : null).add("DomainName", domainName())
                .add("OrganizationalUnitDistinguishedName", organizationalUnitDistinguishedName())
                .add("FileSystemAdministratorsGroup", fileSystemAdministratorsGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "DnsIps":
            return Optional.ofNullable(clazz.cast(dnsIps()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "OrganizationalUnitDistinguishedName":
            return Optional.ofNullable(clazz.cast(organizationalUnitDistinguishedName()));
        case "FileSystemAdministratorsGroup":
            return Optional.ofNullable(clazz.cast(fileSystemAdministratorsGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserName", USER_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("DnsIps", DNS_IPS_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("OrganizationalUnitDistinguishedName", ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD);
        map.put("FileSystemAdministratorsGroup", FILE_SYSTEM_ADMINISTRATORS_GROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SelfManagedActiveDirectoryConfigurationUpdates, T> g) {
        return obj -> g.apply((SelfManagedActiveDirectoryConfigurationUpdates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfManagedActiveDirectoryConfigurationUpdates> {
        /**
         * <p>
         * Specifies the updated user name for the service account on your self-managed Active Directory domain. Amazon
         * FSx uses this account to join to your self-managed Active Directory domain.
         * </p>
         * <p>
         * This account must have the permissions required to join computers to the domain in the organizational unit
         * provided in <code>OrganizationalUnitDistinguishedName</code>.
         * </p>
         * 
         * @param userName
         *        Specifies the updated user name for the service account on your self-managed Active Directory domain.
         *        Amazon FSx uses this account to join to your self-managed Active Directory domain.</p>
         *        <p>
         *        This account must have the permissions required to join computers to the domain in the organizational
         *        unit provided in <code>OrganizationalUnitDistinguishedName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * Specifies the updated password for the service account on your self-managed Active Directory domain. Amazon
         * FSx uses this account to join to your self-managed Active Directory domain.
         * </p>
         * 
         * @param password
         *        Specifies the updated password for the service account on your self-managed Active Directory domain.
         *        Amazon FSx uses this account to join to your self-managed Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * A list of up to three DNS server or domain controller IP addresses in your self-managed Active Directory
         * domain.
         * </p>
         * 
         * @param dnsIps
         *        A list of up to three DNS server or domain controller IP addresses in your self-managed Active
         *        Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIps(Collection<String> dnsIps);

        /**
         * <p>
         * A list of up to three DNS server or domain controller IP addresses in your self-managed Active Directory
         * domain.
         * </p>
         * 
         * @param dnsIps
         *        A list of up to three DNS server or domain controller IP addresses in your self-managed Active
         *        Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsIps(String... dnsIps);

        /**
         * <p>
         * Specifies an updated fully qualified domain name of your self-managed Active Directory configuration.
         * </p>
         * 
         * @param domainName
         *        Specifies an updated fully qualified domain name of your self-managed Active Directory configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Specifies an updated fully qualified distinguished name of the organization unit within your self-managed
         * Active Directory.
         * </p>
         * 
         * @param organizationalUnitDistinguishedName
         *        Specifies an updated fully qualified distinguished name of the organization unit within your
         *        self-managed Active Directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName);

        /**
         * <p>
         * For FSx for ONTAP file systems only - Specifies the updated name of the self-managed Active Directory domain
         * group whose members are granted administrative privileges for the Amazon FSx resource.
         * </p>
         * 
         * @param fileSystemAdministratorsGroup
         *        For FSx for ONTAP file systems only - Specifies the updated name of the self-managed Active Directory
         *        domain group whose members are granted administrative privileges for the Amazon FSx resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemAdministratorsGroup(String fileSystemAdministratorsGroup);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String password;

        private List<String> dnsIps = DefaultSdkAutoConstructList.getInstance();

        private String domainName;

        private String organizationalUnitDistinguishedName;

        private String fileSystemAdministratorsGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfManagedActiveDirectoryConfigurationUpdates model) {
            userName(model.userName);
            password(model.password);
            dnsIps(model.dnsIps);
            domainName(model.domainName);
            organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
            fileSystemAdministratorsGroup(model.fileSystemAdministratorsGroup);
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final Collection<String> getDnsIps() {
            if (dnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsIps;
        }

        public final void setDnsIps(Collection<String> dnsIps) {
            this.dnsIps = DnsIpsCopier.copy(dnsIps);
        }

        @Override
        public final Builder dnsIps(Collection<String> dnsIps) {
            this.dnsIps = DnsIpsCopier.copy(dnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsIps(String... dnsIps) {
            dnsIps(Arrays.asList(dnsIps));
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return organizationalUnitDistinguishedName;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final String getFileSystemAdministratorsGroup() {
            return fileSystemAdministratorsGroup;
        }

        public final void setFileSystemAdministratorsGroup(String fileSystemAdministratorsGroup) {
            this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
        }

        @Override
        public final Builder fileSystemAdministratorsGroup(String fileSystemAdministratorsGroup) {
            this.fileSystemAdministratorsGroup = fileSystemAdministratorsGroup;
            return this;
        }

        @Override
        public SelfManagedActiveDirectoryConfigurationUpdates build() {
            return new SelfManagedActiveDirectoryConfigurationUpdates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
