/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVolumeRequest extends FSxRequest implements
        ToCopyableBuilder<UpdateVolumeRequest.Builder, UpdateVolumeRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientRequestToken")
            .getter(getter(UpdateVolumeRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(UpdateVolumeRequest::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<UpdateOntapVolumeConfiguration> ONTAP_CONFIGURATION_FIELD = SdkField
            .<UpdateOntapVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("OntapConfiguration")
            .getter(getter(UpdateVolumeRequest::ontapConfiguration)).setter(setter(Builder::ontapConfiguration))
            .constructor(UpdateOntapVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OntapConfiguration").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateVolumeRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<UpdateOpenZFSVolumeConfiguration> OPEN_ZFS_CONFIGURATION_FIELD = SdkField
            .<UpdateOpenZFSVolumeConfiguration> builder(MarshallingType.SDK_POJO).memberName("OpenZFSConfiguration")
            .getter(getter(UpdateVolumeRequest::openZFSConfiguration)).setter(setter(Builder::openZFSConfiguration))
            .constructor(UpdateOpenZFSVolumeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenZFSConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD,
            VOLUME_ID_FIELD, ONTAP_CONFIGURATION_FIELD, NAME_FIELD, OPEN_ZFS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientRequestToken;

    private final String volumeId;

    private final UpdateOntapVolumeConfiguration ontapConfiguration;

    private final String name;

    private final UpdateOpenZFSVolumeConfiguration openZFSConfiguration;

    private UpdateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.volumeId = builder.volumeId;
        this.ontapConfiguration = builder.ontapConfiguration;
        this.name = builder.name;
        this.openZFSConfiguration = builder.openZFSConfiguration;
    }

    /**
     * Returns the value of the ClientRequestToken property for this object.
     * 
     * @return The value of the ClientRequestToken property for this object.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The ID of the volume that you want to update, in the format <code>fsvol-0123456789abcdef0</code>.
     * </p>
     * 
     * @return The ID of the volume that you want to update, in the format <code>fsvol-0123456789abcdef0</code>.
     */
    public final String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The configuration of the ONTAP volume that you are updating.
     * </p>
     * 
     * @return The configuration of the ONTAP volume that you are updating.
     */
    public final UpdateOntapVolumeConfiguration ontapConfiguration() {
        return ontapConfiguration;
    }

    /**
     * <p>
     * The name of the OpenZFS volume. OpenZFS root volumes are automatically named <code>FSX</code>. Child volume names
     * must be unique among their parent volume's children. The name of the volume is part of the mount string for the
     * OpenZFS volume.
     * </p>
     * 
     * @return The name of the OpenZFS volume. OpenZFS root volumes are automatically named <code>FSX</code>. Child
     *         volume names must be unique among their parent volume's children. The name of the volume is part of the
     *         mount string for the OpenZFS volume.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The configuration of the OpenZFS volume that you are updating.
     * </p>
     * 
     * @return The configuration of the OpenZFS volume that you are updating.
     */
    public final UpdateOpenZFSVolumeConfiguration openZFSConfiguration() {
        return openZFSConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(ontapConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(openZFSConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVolumeRequest)) {
            return false;
        }
        UpdateVolumeRequest other = (UpdateVolumeRequest) obj;
        return Objects.equals(clientRequestToken(), other.clientRequestToken()) && Objects.equals(volumeId(), other.volumeId())
                && Objects.equals(ontapConfiguration(), other.ontapConfiguration()) && Objects.equals(name(), other.name())
                && Objects.equals(openZFSConfiguration(), other.openZFSConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVolumeRequest").add("ClientRequestToken", clientRequestToken())
                .add("VolumeId", volumeId()).add("OntapConfiguration", ontapConfiguration()).add("Name", name())
                .add("OpenZFSConfiguration", openZFSConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "OntapConfiguration":
            return Optional.ofNullable(clazz.cast(ontapConfiguration()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "OpenZFSConfiguration":
            return Optional.ofNullable(clazz.cast(openZFSConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("OntapConfiguration", ONTAP_CONFIGURATION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("OpenZFSConfiguration", OPEN_ZFS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVolumeRequest, T> g) {
        return obj -> g.apply((UpdateVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends FSxRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVolumeRequest> {
        /**
         * Sets the value of the ClientRequestToken property for this object.
         *
         * @param clientRequestToken
         *        The new value for the ClientRequestToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The ID of the volume that you want to update, in the format <code>fsvol-0123456789abcdef0</code>.
         * </p>
         * 
         * @param volumeId
         *        The ID of the volume that you want to update, in the format <code>fsvol-0123456789abcdef0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The configuration of the ONTAP volume that you are updating.
         * </p>
         * 
         * @param ontapConfiguration
         *        The configuration of the ONTAP volume that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ontapConfiguration(UpdateOntapVolumeConfiguration ontapConfiguration);

        /**
         * <p>
         * The configuration of the ONTAP volume that you are updating.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateOntapVolumeConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateOntapVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateOntapVolumeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ontapConfiguration(UpdateOntapVolumeConfiguration)}.
         * 
         * @param ontapConfiguration
         *        a consumer that will call methods on {@link UpdateOntapVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ontapConfiguration(UpdateOntapVolumeConfiguration)
         */
        default Builder ontapConfiguration(Consumer<UpdateOntapVolumeConfiguration.Builder> ontapConfiguration) {
            return ontapConfiguration(UpdateOntapVolumeConfiguration.builder().applyMutation(ontapConfiguration).build());
        }

        /**
         * <p>
         * The name of the OpenZFS volume. OpenZFS root volumes are automatically named <code>FSX</code>. Child volume
         * names must be unique among their parent volume's children. The name of the volume is part of the mount string
         * for the OpenZFS volume.
         * </p>
         * 
         * @param name
         *        The name of the OpenZFS volume. OpenZFS root volumes are automatically named <code>FSX</code>. Child
         *        volume names must be unique among their parent volume's children. The name of the volume is part of
         *        the mount string for the OpenZFS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The configuration of the OpenZFS volume that you are updating.
         * </p>
         * 
         * @param openZFSConfiguration
         *        The configuration of the OpenZFS volume that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openZFSConfiguration(UpdateOpenZFSVolumeConfiguration openZFSConfiguration);

        /**
         * <p>
         * The configuration of the OpenZFS volume that you are updating.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateOpenZFSVolumeConfiguration.Builder}
         * avoiding the need to create one manually via {@link UpdateOpenZFSVolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateOpenZFSVolumeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #openZFSConfiguration(UpdateOpenZFSVolumeConfiguration)}.
         * 
         * @param openZFSConfiguration
         *        a consumer that will call methods on {@link UpdateOpenZFSVolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openZFSConfiguration(UpdateOpenZFSVolumeConfiguration)
         */
        default Builder openZFSConfiguration(Consumer<UpdateOpenZFSVolumeConfiguration.Builder> openZFSConfiguration) {
            return openZFSConfiguration(UpdateOpenZFSVolumeConfiguration.builder().applyMutation(openZFSConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends FSxRequest.BuilderImpl implements Builder {
        private String clientRequestToken;

        private String volumeId;

        private UpdateOntapVolumeConfiguration ontapConfiguration;

        private String name;

        private UpdateOpenZFSVolumeConfiguration openZFSConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVolumeRequest model) {
            super(model);
            clientRequestToken(model.clientRequestToken);
            volumeId(model.volumeId);
            ontapConfiguration(model.ontapConfiguration);
            name(model.name);
            openZFSConfiguration(model.openZFSConfiguration);
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getVolumeId() {
            return volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final UpdateOntapVolumeConfiguration.Builder getOntapConfiguration() {
            return ontapConfiguration != null ? ontapConfiguration.toBuilder() : null;
        }

        public final void setOntapConfiguration(UpdateOntapVolumeConfiguration.BuilderImpl ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration != null ? ontapConfiguration.build() : null;
        }

        @Override
        public final Builder ontapConfiguration(UpdateOntapVolumeConfiguration ontapConfiguration) {
            this.ontapConfiguration = ontapConfiguration;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final UpdateOpenZFSVolumeConfiguration.Builder getOpenZFSConfiguration() {
            return openZFSConfiguration != null ? openZFSConfiguration.toBuilder() : null;
        }

        public final void setOpenZFSConfiguration(UpdateOpenZFSVolumeConfiguration.BuilderImpl openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration != null ? openZFSConfiguration.build() : null;
        }

        @Override
        public final Builder openZFSConfiguration(UpdateOpenZFSVolumeConfiguration openZFSConfiguration) {
            this.openZFSConfiguration = openZFSConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateVolumeRequest build() {
            return new UpdateVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
