/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.geomaps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSpritesRequest extends GeoMapsRequest implements
        ToCopyableBuilder<GetSpritesRequest.Builder, GetSpritesRequest> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileName").getter(getter(GetSpritesRequest::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("FileName").build()).build();

    private static final SdkField<String> STYLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Style")
            .getter(getter(GetSpritesRequest::styleAsString)).setter(setter(Builder::style))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Style").build()).build();

    private static final SdkField<String> COLOR_SCHEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColorScheme").getter(getter(GetSpritesRequest::colorSchemeAsString))
            .setter(setter(Builder::colorScheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ColorScheme").build()).build();

    private static final SdkField<String> VARIANT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Variant")
            .getter(getter(GetSpritesRequest::variantAsString)).setter(setter(Builder::variant))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Variant").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD, STYLE_FIELD,
            COLOR_SCHEME_FIELD, VARIANT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String fileName;

    private final String style;

    private final String colorScheme;

    private final String variant;

    private GetSpritesRequest(BuilderImpl builder) {
        super(builder);
        this.fileName = builder.fileName;
        this.style = builder.style;
        this.colorScheme = builder.colorScheme;
        this.variant = builder.variant;
    }

    /**
     * <p>
     * <code>Sprites</code> API: The name of the sprite ﬁle to retrieve, following pattern
     * <code>sprites(@2x)?\.(png|json)</code>.
     * </p>
     * <p>
     * Example: <code>sprites.png</code>
     * </p>
     * 
     * @return <code>Sprites</code> API: The name of the sprite ﬁle to retrieve, following pattern
     *         <code>sprites(@2x)?\.(png|json)</code>.</p>
     *         <p>
     *         Example: <code>sprites.png</code>
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * Style specifies the desired map style for the <code>Sprites</code> APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #style} will return
     * {@link MapStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #styleAsString}.
     * </p>
     * 
     * @return Style specifies the desired map style for the <code>Sprites</code> APIs.
     * @see MapStyle
     */
    public final MapStyle style() {
        return MapStyle.fromValue(style);
    }

    /**
     * <p>
     * Style specifies the desired map style for the <code>Sprites</code> APIs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #style} will return
     * {@link MapStyle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #styleAsString}.
     * </p>
     * 
     * @return Style specifies the desired map style for the <code>Sprites</code> APIs.
     * @see MapStyle
     */
    public final String styleAsString() {
        return style;
    }

    /**
     * <p>
     * Sets color tone for map such as dark and light for specific map styles. It applies to only vector map styles such
     * as Standard and Monochrome.
     * </p>
     * <p>
     * Example: <code>Light</code>
     * </p>
     * <p>
     * Default value: <code>Light</code>
     * </p>
     * <note>
     * <p>
     * Valid values for ColorScheme are case sensitive.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorScheme} will
     * return {@link ColorScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorSchemeAsString}.
     * </p>
     * 
     * @return Sets color tone for map such as dark and light for specific map styles. It applies to only vector map
     *         styles such as Standard and Monochrome.</p>
     *         <p>
     *         Example: <code>Light</code>
     *         </p>
     *         <p>
     *         Default value: <code>Light</code>
     *         </p>
     *         <note>
     *         <p>
     *         Valid values for ColorScheme are case sensitive.
     *         </p>
     * @see ColorScheme
     */
    public final ColorScheme colorScheme() {
        return ColorScheme.fromValue(colorScheme);
    }

    /**
     * <p>
     * Sets color tone for map such as dark and light for specific map styles. It applies to only vector map styles such
     * as Standard and Monochrome.
     * </p>
     * <p>
     * Example: <code>Light</code>
     * </p>
     * <p>
     * Default value: <code>Light</code>
     * </p>
     * <note>
     * <p>
     * Valid values for ColorScheme are case sensitive.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #colorScheme} will
     * return {@link ColorScheme#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #colorSchemeAsString}.
     * </p>
     * 
     * @return Sets color tone for map such as dark and light for specific map styles. It applies to only vector map
     *         styles such as Standard and Monochrome.</p>
     *         <p>
     *         Example: <code>Light</code>
     *         </p>
     *         <p>
     *         Default value: <code>Light</code>
     *         </p>
     *         <note>
     *         <p>
     *         Valid values for ColorScheme are case sensitive.
     *         </p>
     * @see ColorScheme
     */
    public final String colorSchemeAsString() {
        return colorScheme;
    }

    /**
     * <p>
     * Optimizes map styles for specific use case or industry. You can choose allowed variant only with Standard map
     * style.
     * </p>
     * <p>
     * Example: <code>Default</code>
     * </p>
     * <note>
     * <p>
     * Valid values for Variant are case sensitive.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #variant} will
     * return {@link Variant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #variantAsString}.
     * </p>
     * 
     * @return Optimizes map styles for specific use case or industry. You can choose allowed variant only with Standard
     *         map style.</p>
     *         <p>
     *         Example: <code>Default</code>
     *         </p>
     *         <note>
     *         <p>
     *         Valid values for Variant are case sensitive.
     *         </p>
     * @see Variant
     */
    public final Variant variant() {
        return Variant.fromValue(variant);
    }

    /**
     * <p>
     * Optimizes map styles for specific use case or industry. You can choose allowed variant only with Standard map
     * style.
     * </p>
     * <p>
     * Example: <code>Default</code>
     * </p>
     * <note>
     * <p>
     * Valid values for Variant are case sensitive.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #variant} will
     * return {@link Variant#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #variantAsString}.
     * </p>
     * 
     * @return Optimizes map styles for specific use case or industry. You can choose allowed variant only with Standard
     *         map style.</p>
     *         <p>
     *         Example: <code>Default</code>
     *         </p>
     *         <note>
     *         <p>
     *         Valid values for Variant are case sensitive.
     *         </p>
     * @see Variant
     */
    public final String variantAsString() {
        return variant;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(styleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(colorSchemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(variantAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSpritesRequest)) {
            return false;
        }
        GetSpritesRequest other = (GetSpritesRequest) obj;
        return Objects.equals(fileName(), other.fileName()) && Objects.equals(styleAsString(), other.styleAsString())
                && Objects.equals(colorSchemeAsString(), other.colorSchemeAsString())
                && Objects.equals(variantAsString(), other.variantAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSpritesRequest").add("FileName", fileName()).add("Style", styleAsString())
                .add("ColorScheme", colorSchemeAsString()).add("Variant", variantAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "Style":
            return Optional.ofNullable(clazz.cast(styleAsString()));
        case "ColorScheme":
            return Optional.ofNullable(clazz.cast(colorSchemeAsString()));
        case "Variant":
            return Optional.ofNullable(clazz.cast(variantAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FileName", FILE_NAME_FIELD);
        map.put("Style", STYLE_FIELD);
        map.put("ColorScheme", COLOR_SCHEME_FIELD);
        map.put("Variant", VARIANT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSpritesRequest, T> g) {
        return obj -> g.apply((GetSpritesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GeoMapsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetSpritesRequest> {
        /**
         * <p>
         * <code>Sprites</code> API: The name of the sprite ﬁle to retrieve, following pattern
         * <code>sprites(@2x)?\.(png|json)</code>.
         * </p>
         * <p>
         * Example: <code>sprites.png</code>
         * </p>
         * 
         * @param fileName
         *        <code>Sprites</code> API: The name of the sprite ﬁle to retrieve, following pattern
         *        <code>sprites(@2x)?\.(png|json)</code>.</p>
         *        <p>
         *        Example: <code>sprites.png</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * Style specifies the desired map style for the <code>Sprites</code> APIs.
         * </p>
         * 
         * @param style
         *        Style specifies the desired map style for the <code>Sprites</code> APIs.
         * @see MapStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapStyle
         */
        Builder style(String style);

        /**
         * <p>
         * Style specifies the desired map style for the <code>Sprites</code> APIs.
         * </p>
         * 
         * @param style
         *        Style specifies the desired map style for the <code>Sprites</code> APIs.
         * @see MapStyle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapStyle
         */
        Builder style(MapStyle style);

        /**
         * <p>
         * Sets color tone for map such as dark and light for specific map styles. It applies to only vector map styles
         * such as Standard and Monochrome.
         * </p>
         * <p>
         * Example: <code>Light</code>
         * </p>
         * <p>
         * Default value: <code>Light</code>
         * </p>
         * <note>
         * <p>
         * Valid values for ColorScheme are case sensitive.
         * </p>
         * </note>
         * 
         * @param colorScheme
         *        Sets color tone for map such as dark and light for specific map styles. It applies to only vector map
         *        styles such as Standard and Monochrome.</p>
         *        <p>
         *        Example: <code>Light</code>
         *        </p>
         *        <p>
         *        Default value: <code>Light</code>
         *        </p>
         *        <note>
         *        <p>
         *        Valid values for ColorScheme are case sensitive.
         *        </p>
         * @see ColorScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorScheme
         */
        Builder colorScheme(String colorScheme);

        /**
         * <p>
         * Sets color tone for map such as dark and light for specific map styles. It applies to only vector map styles
         * such as Standard and Monochrome.
         * </p>
         * <p>
         * Example: <code>Light</code>
         * </p>
         * <p>
         * Default value: <code>Light</code>
         * </p>
         * <note>
         * <p>
         * Valid values for ColorScheme are case sensitive.
         * </p>
         * </note>
         * 
         * @param colorScheme
         *        Sets color tone for map such as dark and light for specific map styles. It applies to only vector map
         *        styles such as Standard and Monochrome.</p>
         *        <p>
         *        Example: <code>Light</code>
         *        </p>
         *        <p>
         *        Default value: <code>Light</code>
         *        </p>
         *        <note>
         *        <p>
         *        Valid values for ColorScheme are case sensitive.
         *        </p>
         * @see ColorScheme
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ColorScheme
         */
        Builder colorScheme(ColorScheme colorScheme);

        /**
         * <p>
         * Optimizes map styles for specific use case or industry. You can choose allowed variant only with Standard map
         * style.
         * </p>
         * <p>
         * Example: <code>Default</code>
         * </p>
         * <note>
         * <p>
         * Valid values for Variant are case sensitive.
         * </p>
         * </note>
         * 
         * @param variant
         *        Optimizes map styles for specific use case or industry. You can choose allowed variant only with
         *        Standard map style.</p>
         *        <p>
         *        Example: <code>Default</code>
         *        </p>
         *        <note>
         *        <p>
         *        Valid values for Variant are case sensitive.
         *        </p>
         * @see Variant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Variant
         */
        Builder variant(String variant);

        /**
         * <p>
         * Optimizes map styles for specific use case or industry. You can choose allowed variant only with Standard map
         * style.
         * </p>
         * <p>
         * Example: <code>Default</code>
         * </p>
         * <note>
         * <p>
         * Valid values for Variant are case sensitive.
         * </p>
         * </note>
         * 
         * @param variant
         *        Optimizes map styles for specific use case or industry. You can choose allowed variant only with
         *        Standard map style.</p>
         *        <p>
         *        Example: <code>Default</code>
         *        </p>
         *        <note>
         *        <p>
         *        Valid values for Variant are case sensitive.
         *        </p>
         * @see Variant
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Variant
         */
        Builder variant(Variant variant);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GeoMapsRequest.BuilderImpl implements Builder {
        private String fileName;

        private String style;

        private String colorScheme;

        private String variant;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSpritesRequest model) {
            super(model);
            fileName(model.fileName);
            style(model.style);
            colorScheme(model.colorScheme);
            variant(model.variant);
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getStyle() {
            return style;
        }

        public final void setStyle(String style) {
            this.style = style;
        }

        @Override
        public final Builder style(String style) {
            this.style = style;
            return this;
        }

        @Override
        public final Builder style(MapStyle style) {
            this.style(style == null ? null : style.toString());
            return this;
        }

        public final String getColorScheme() {
            return colorScheme;
        }

        public final void setColorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
        }

        @Override
        public final Builder colorScheme(String colorScheme) {
            this.colorScheme = colorScheme;
            return this;
        }

        @Override
        public final Builder colorScheme(ColorScheme colorScheme) {
            this.colorScheme(colorScheme == null ? null : colorScheme.toString());
            return this;
        }

        public final String getVariant() {
            return variant;
        }

        public final void setVariant(String variant) {
            this.variant = variant;
        }

        @Override
        public final Builder variant(String variant) {
            this.variant = variant;
            return this;
        }

        @Override
        public final Builder variant(Variant variant) {
            this.variant(variant == null ? null : variant.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSpritesRequest build() {
            return new GetSpritesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
