/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.GeoPlacesResponse;
import software.amazon.awssdk.services.geoplaces.model.SearchTextResultItem;
import software.amazon.awssdk.services.geoplaces.model.SearchTextResultItemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTextResponse
extends GeoPlacesResponse
implements ToCopyableBuilder<Builder, SearchTextResponse> {
    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingBucket").getter(SearchTextResponse.getter(SearchTextResponse::pricingBucket)).setter(SearchTextResponse.setter(Builder::pricingBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build()}).build();
    private static final SdkField<List<SearchTextResultItem>> RESULT_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultItems").getter(SearchTextResponse.getter(SearchTextResponse::resultItems)).setter(SearchTextResponse.setter(Builder::resultItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchTextResultItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchTextResponse.getter(SearchTextResponse::nextToken)).setter(SearchTextResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRICING_BUCKET_FIELD, RESULT_ITEMS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
            this.put("ResultItems", RESULT_ITEMS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String pricingBucket;
    private final List<SearchTextResultItem> resultItems;
    private final String nextToken;

    private SearchTextResponse(BuilderImpl builder) {
        super(builder);
        this.pricingBucket = builder.pricingBucket;
        this.resultItems = builder.resultItems;
        this.nextToken = builder.nextToken;
    }

    public final String pricingBucket() {
        return this.pricingBucket;
    }

    public final boolean hasResultItems() {
        return this.resultItems != null && !(this.resultItems instanceof SdkAutoConstructList);
    }

    public final List<SearchTextResultItem> resultItems() {
        return this.resultItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultItems() ? this.resultItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTextResponse)) {
            return false;
        }
        SearchTextResponse other = (SearchTextResponse)((Object)obj);
        return Objects.equals(this.pricingBucket(), other.pricingBucket()) && this.hasResultItems() == other.hasResultItems() && Objects.equals(this.resultItems(), other.resultItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTextResponse").add("PricingBucket", (Object)this.pricingBucket()).add("ResultItems", this.hasResultItems() ? this.resultItems() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PricingBucket": {
                return Optional.ofNullable(clazz.cast(this.pricingBucket()));
            }
            case "ResultItems": {
                return Optional.ofNullable(clazz.cast(this.resultItems()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchTextResponse, T> g) {
        return obj -> g.apply((SearchTextResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GeoPlacesResponse.BuilderImpl
    implements Builder {
        private String pricingBucket;
        private List<SearchTextResultItem> resultItems = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTextResponse model) {
            super(model);
            this.pricingBucket(model.pricingBucket);
            this.resultItems(model.resultItems);
            this.nextToken(model.nextToken);
        }

        public final String getPricingBucket() {
            return this.pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<SearchTextResultItem.Builder> getResultItems() {
            List<SearchTextResultItem.Builder> result = SearchTextResultItemListCopier.copyToBuilder(this.resultItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultItems(Collection<SearchTextResultItem.BuilderImpl> resultItems) {
            this.resultItems = SearchTextResultItemListCopier.copyFromBuilder(resultItems);
        }

        @Override
        public final Builder resultItems(Collection<SearchTextResultItem> resultItems) {
            this.resultItems = SearchTextResultItemListCopier.copy(resultItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(SearchTextResultItem ... resultItems) {
            this.resultItems(Arrays.asList(resultItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultItems(Consumer<SearchTextResultItem.Builder> ... resultItems) {
            this.resultItems(Stream.of(resultItems).map(c -> (SearchTextResultItem)((SearchTextResultItem.Builder)SearchTextResultItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public SearchTextResponse build() {
            return new SearchTextResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GeoPlacesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchTextResponse> {
        public Builder pricingBucket(String var1);

        public Builder resultItems(Collection<SearchTextResultItem> var1);

        public Builder resultItems(SearchTextResultItem ... var1);

        public Builder resultItems(Consumer<SearchTextResultItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

