/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.geoplaces.model.Address;
import software.amazon.awssdk.services.geoplaces.model.AutocompleteHighlights;
import software.amazon.awssdk.services.geoplaces.model.PlaceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutocompleteResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutocompleteResultItem> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceId").getter(AutocompleteResultItem.getter(AutocompleteResultItem::placeId)).setter(AutocompleteResultItem.setter(Builder::placeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()}).build();
    private static final SdkField<String> PLACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceType").getter(AutocompleteResultItem.getter(AutocompleteResultItem::placeTypeAsString)).setter(AutocompleteResultItem.setter(Builder::placeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceType").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(AutocompleteResultItem.getter(AutocompleteResultItem::title)).setter(AutocompleteResultItem.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(AutocompleteResultItem.getter(AutocompleteResultItem::address)).setter(AutocompleteResultItem.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<Long> DISTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Distance").getter(AutocompleteResultItem.getter(AutocompleteResultItem::distance)).setter(AutocompleteResultItem.setter(Builder::distance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Distance").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(AutocompleteResultItem.getter(AutocompleteResultItem::language)).setter(AutocompleteResultItem.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> POLITICAL_VIEW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoliticalView").getter(AutocompleteResultItem.getter(AutocompleteResultItem::politicalView)).setter(AutocompleteResultItem.setter(Builder::politicalView)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoliticalView").build()}).build();
    private static final SdkField<AutocompleteHighlights> HIGHLIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Highlights").getter(AutocompleteResultItem.getter(AutocompleteResultItem::highlights)).setter(AutocompleteResultItem.setter(Builder::highlights)).constructor(AutocompleteHighlights::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Highlights").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD, PLACE_TYPE_FIELD, TITLE_FIELD, ADDRESS_FIELD, DISTANCE_FIELD, LANGUAGE_FIELD, POLITICAL_VIEW_FIELD, HIGHLIGHTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutocompleteResultItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String placeId;
    private final String placeType;
    private final String title;
    private final Address address;
    private final Long distance;
    private final String language;
    private final String politicalView;
    private final AutocompleteHighlights highlights;

    private AutocompleteResultItem(BuilderImpl builder) {
        this.placeId = builder.placeId;
        this.placeType = builder.placeType;
        this.title = builder.title;
        this.address = builder.address;
        this.distance = builder.distance;
        this.language = builder.language;
        this.politicalView = builder.politicalView;
        this.highlights = builder.highlights;
    }

    public final String placeId() {
        return this.placeId;
    }

    public final PlaceType placeType() {
        return PlaceType.fromValue(this.placeType);
    }

    public final String placeTypeAsString() {
        return this.placeType;
    }

    public final String title() {
        return this.title;
    }

    public final Address address() {
        return this.address;
    }

    public final Long distance() {
        return this.distance;
    }

    public final String language() {
        return this.language;
    }

    public final String politicalView() {
        return this.politicalView;
    }

    public final AutocompleteHighlights highlights() {
        return this.highlights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.placeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.distance());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.politicalView());
        hashCode = 31 * hashCode + Objects.hashCode(this.highlights());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutocompleteResultItem)) {
            return false;
        }
        AutocompleteResultItem other = (AutocompleteResultItem)obj;
        return Objects.equals(this.placeId(), other.placeId()) && Objects.equals(this.placeTypeAsString(), other.placeTypeAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.distance(), other.distance()) && Objects.equals(this.language(), other.language()) && Objects.equals(this.politicalView(), other.politicalView()) && Objects.equals(this.highlights(), other.highlights());
    }

    public final String toString() {
        return ToString.builder((String)"AutocompleteResultItem").add("PlaceId", (Object)this.placeId()).add("PlaceType", (Object)this.placeTypeAsString()).add("Title", (Object)this.title()).add("Address", (Object)this.address()).add("Distance", (Object)this.distance()).add("Language", (Object)this.language()).add("PoliticalView", (Object)this.politicalView()).add("Highlights", (Object)this.highlights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlaceId": {
                return Optional.ofNullable(clazz.cast(this.placeId()));
            }
            case "PlaceType": {
                return Optional.ofNullable(clazz.cast(this.placeTypeAsString()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Distance": {
                return Optional.ofNullable(clazz.cast(this.distance()));
            }
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "PoliticalView": {
                return Optional.ofNullable(clazz.cast(this.politicalView()));
            }
            case "Highlights": {
                return Optional.ofNullable(clazz.cast(this.highlights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("PlaceType", PLACE_TYPE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("Distance", DISTANCE_FIELD);
        map.put("Language", LANGUAGE_FIELD);
        map.put("PoliticalView", POLITICAL_VIEW_FIELD);
        map.put("Highlights", HIGHLIGHTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutocompleteResultItem, T> g) {
        return obj -> g.apply((AutocompleteResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String placeId;
        private String placeType;
        private String title;
        private Address address;
        private Long distance;
        private String language;
        private String politicalView;
        private AutocompleteHighlights highlights;

        private BuilderImpl() {
        }

        private BuilderImpl(AutocompleteResultItem model) {
            this.placeId(model.placeId);
            this.placeType(model.placeType);
            this.title(model.title);
            this.address(model.address);
            this.distance(model.distance);
            this.language(model.language);
            this.politicalView(model.politicalView);
            this.highlights(model.highlights);
        }

        public final String getPlaceId() {
            return this.placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final String getPlaceType() {
            return this.placeType;
        }

        public final void setPlaceType(String placeType) {
            this.placeType = placeType;
        }

        @Override
        public final Builder placeType(String placeType) {
            this.placeType = placeType;
            return this;
        }

        @Override
        public final Builder placeType(PlaceType placeType) {
            this.placeType(placeType == null ? null : placeType.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Long getDistance() {
            return this.distance;
        }

        public final void setDistance(Long distance) {
            this.distance = distance;
        }

        @Override
        public final Builder distance(Long distance) {
            this.distance = distance;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final String getPoliticalView() {
            return this.politicalView;
        }

        public final void setPoliticalView(String politicalView) {
            this.politicalView = politicalView;
        }

        @Override
        public final Builder politicalView(String politicalView) {
            this.politicalView = politicalView;
            return this;
        }

        public final AutocompleteHighlights.Builder getHighlights() {
            return this.highlights != null ? this.highlights.toBuilder() : null;
        }

        public final void setHighlights(AutocompleteHighlights.BuilderImpl highlights) {
            this.highlights = highlights != null ? highlights.build() : null;
        }

        @Override
        public final Builder highlights(AutocompleteHighlights highlights) {
            this.highlights = highlights;
            return this;
        }

        public AutocompleteResultItem build() {
            return new AutocompleteResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutocompleteResultItem> {
        public Builder placeId(String var1);

        public Builder placeType(String var1);

        public Builder placeType(PlaceType var1);

        public Builder title(String var1);

        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder distance(Long var1);

        public Builder language(String var1);

        public Builder politicalView(String var1);

        public Builder highlights(AutocompleteHighlights var1);

        default public Builder highlights(Consumer<AutocompleteHighlights.Builder> highlights) {
            return this.highlights((AutocompleteHighlights)((AutocompleteHighlights.Builder)AutocompleteHighlights.builder().applyMutation(highlights)).build());
        }
    }
}

