/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PostalCodeMode {
    MERGE_ALL_SPANNED_LOCALITIES("MergeAllSpannedLocalities"),
    ENUMERATE_SPANNED_LOCALITIES("EnumerateSpannedLocalities"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PostalCodeMode> VALUE_MAP;
    private final String value;

    private PostalCodeMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PostalCodeMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PostalCodeMode> knownValues() {
        EnumSet<PostalCodeMode> knownValues = EnumSet.allOf(PostalCodeMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PostalCodeMode.class, PostalCodeMode::toString);
    }
}

