/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CalculateRoutesResponse extends GeoRoutesResponse implements
        ToCopyableBuilder<CalculateRoutesResponse.Builder, CalculateRoutesResponse> {
    private static final SdkField<String> LEG_GEOMETRY_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LegGeometryFormat").getter(getter(CalculateRoutesResponse::legGeometryFormatAsString))
            .setter(setter(Builder::legGeometryFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LegGeometryFormat").build()).build();

    private static final SdkField<List<RouteResponseNotice>> NOTICES_FIELD = SdkField
            .<List<RouteResponseNotice>> builder(MarshallingType.LIST)
            .memberName("Notices")
            .getter(getter(CalculateRoutesResponse::notices))
            .setter(setter(Builder::notices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteResponseNotice> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteResponseNotice::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRICING_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PricingBucket").getter(getter(CalculateRoutesResponse::pricingBucket))
            .setter(setter(Builder::pricingBucket))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-geo-pricing-bucket").build())
            .build();

    private static final SdkField<List<Route>> ROUTES_FIELD = SdkField
            .<List<Route>> builder(MarshallingType.LIST)
            .memberName("Routes")
            .getter(getter(CalculateRoutesResponse::routes))
            .setter(setter(Builder::routes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Routes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEG_GEOMETRY_FORMAT_FIELD,
            NOTICES_FIELD, PRICING_BUCKET_FIELD, ROUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String legGeometryFormat;

    private final List<RouteResponseNotice> notices;

    private final String pricingBucket;

    private final List<Route> routes;

    private CalculateRoutesResponse(BuilderImpl builder) {
        super(builder);
        this.legGeometryFormat = builder.legGeometryFormat;
        this.notices = builder.notices;
        this.pricingBucket = builder.pricingBucket;
        this.routes = builder.routes;
    }

    /**
     * <p>
     * Specifies the format of the geometry returned for each leg of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #legGeometryFormat}
     * will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #legGeometryFormatAsString}.
     * </p>
     * 
     * @return Specifies the format of the geometry returned for each leg of the route.
     * @see GeometryFormat
     */
    public final GeometryFormat legGeometryFormat() {
        return GeometryFormat.fromValue(legGeometryFormat);
    }

    /**
     * <p>
     * Specifies the format of the geometry returned for each leg of the route.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #legGeometryFormat}
     * will return {@link GeometryFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #legGeometryFormatAsString}.
     * </p>
     * 
     * @return Specifies the format of the geometry returned for each leg of the route.
     * @see GeometryFormat
     */
    public final String legGeometryFormatAsString() {
        return legGeometryFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Notices property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNotices() {
        return notices != null && !(notices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Notices are additional information returned that indicate issues that occurred during route calculation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotices} method.
     * </p>
     * 
     * @return Notices are additional information returned that indicate issues that occurred during route calculation.
     */
    public final List<RouteResponseNotice> notices() {
        return notices;
    }

    /**
     * <p>
     * The pricing bucket for which the query is charged at.
     * </p>
     * 
     * @return The pricing bucket for which the query is charged at.
     */
    public final String pricingBucket() {
        return pricingBucket;
    }

    /**
     * For responses, this returns true if the service returned a value for the Routes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRoutes() {
        return routes != null && !(routes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path from the origin to the destination.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutes} method.
     * </p>
     * 
     * @return The path from the origin to the destination.
     */
    public final List<Route> routes() {
        return routes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(legGeometryFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasNotices() ? notices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pricingBucket());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutes() ? routes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CalculateRoutesResponse)) {
            return false;
        }
        CalculateRoutesResponse other = (CalculateRoutesResponse) obj;
        return Objects.equals(legGeometryFormatAsString(), other.legGeometryFormatAsString())
                && hasNotices() == other.hasNotices() && Objects.equals(notices(), other.notices())
                && Objects.equals(pricingBucket(), other.pricingBucket()) && hasRoutes() == other.hasRoutes()
                && Objects.equals(routes(), other.routes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CalculateRoutesResponse").add("LegGeometryFormat", legGeometryFormatAsString())
                .add("Notices", hasNotices() ? notices() : null).add("PricingBucket", pricingBucket())
                .add("Routes", hasRoutes() ? routes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LegGeometryFormat":
            return Optional.ofNullable(clazz.cast(legGeometryFormatAsString()));
        case "Notices":
            return Optional.ofNullable(clazz.cast(notices()));
        case "PricingBucket":
            return Optional.ofNullable(clazz.cast(pricingBucket()));
        case "Routes":
            return Optional.ofNullable(clazz.cast(routes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LegGeometryFormat", LEG_GEOMETRY_FORMAT_FIELD);
        map.put("Notices", NOTICES_FIELD);
        map.put("x-amz-geo-pricing-bucket", PRICING_BUCKET_FIELD);
        map.put("Routes", ROUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CalculateRoutesResponse, T> g) {
        return obj -> g.apply((CalculateRoutesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GeoRoutesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CalculateRoutesResponse> {
        /**
         * <p>
         * Specifies the format of the geometry returned for each leg of the route.
         * </p>
         * 
         * @param legGeometryFormat
         *        Specifies the format of the geometry returned for each leg of the route.
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder legGeometryFormat(String legGeometryFormat);

        /**
         * <p>
         * Specifies the format of the geometry returned for each leg of the route.
         * </p>
         * 
         * @param legGeometryFormat
         *        Specifies the format of the geometry returned for each leg of the route.
         * @see GeometryFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GeometryFormat
         */
        Builder legGeometryFormat(GeometryFormat legGeometryFormat);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(Collection<RouteResponseNotice> notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * 
         * @param notices
         *        Notices are additional information returned that indicate issues that occurred during route
         *        calculation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notices(RouteResponseNotice... notices);

        /**
         * <p>
         * Notices are additional information returned that indicate issues that occurred during route calculation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteResponseNotice.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteResponseNotice#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteResponseNotice.Builder#build()} is called
         * immediately and its result is passed to {@link #notices(List<RouteResponseNotice>)}.
         * 
         * @param notices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteResponseNotice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notices(java.util.Collection<RouteResponseNotice>)
         */
        Builder notices(Consumer<RouteResponseNotice.Builder>... notices);

        /**
         * <p>
         * The pricing bucket for which the query is charged at.
         * </p>
         * 
         * @param pricingBucket
         *        The pricing bucket for which the query is charged at.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pricingBucket(String pricingBucket);

        /**
         * <p>
         * The path from the origin to the destination.
         * </p>
         * 
         * @param routes
         *        The path from the origin to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Collection<Route> routes);

        /**
         * <p>
         * The path from the origin to the destination.
         * </p>
         * 
         * @param routes
         *        The path from the origin to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routes(Route... routes);

        /**
         * <p>
         * The path from the origin to the destination.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.Route.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.Route#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.Route.Builder#build()} is called immediately and its
         * result is passed to {@link #routes(List<Route>)}.
         * 
         * @param routes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.Route.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routes(java.util.Collection<Route>)
         */
        Builder routes(Consumer<Route.Builder>... routes);
    }

    static final class BuilderImpl extends GeoRoutesResponse.BuilderImpl implements Builder {
        private String legGeometryFormat;

        private List<RouteResponseNotice> notices = DefaultSdkAutoConstructList.getInstance();

        private String pricingBucket;

        private List<Route> routes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CalculateRoutesResponse model) {
            super(model);
            legGeometryFormat(model.legGeometryFormat);
            notices(model.notices);
            pricingBucket(model.pricingBucket);
            routes(model.routes);
        }

        public final String getLegGeometryFormat() {
            return legGeometryFormat;
        }

        public final void setLegGeometryFormat(String legGeometryFormat) {
            this.legGeometryFormat = legGeometryFormat;
        }

        @Override
        public final Builder legGeometryFormat(String legGeometryFormat) {
            this.legGeometryFormat = legGeometryFormat;
            return this;
        }

        @Override
        public final Builder legGeometryFormat(GeometryFormat legGeometryFormat) {
            this.legGeometryFormat(legGeometryFormat == null ? null : legGeometryFormat.toString());
            return this;
        }

        public final List<RouteResponseNotice.Builder> getNotices() {
            List<RouteResponseNotice.Builder> result = RouteResponseNoticeListCopier.copyToBuilder(this.notices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotices(Collection<RouteResponseNotice.BuilderImpl> notices) {
            this.notices = RouteResponseNoticeListCopier.copyFromBuilder(notices);
        }

        @Override
        public final Builder notices(Collection<RouteResponseNotice> notices) {
            this.notices = RouteResponseNoticeListCopier.copy(notices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(RouteResponseNotice... notices) {
            notices(Arrays.asList(notices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notices(Consumer<RouteResponseNotice.Builder>... notices) {
            notices(Stream.of(notices).map(c -> RouteResponseNotice.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPricingBucket() {
            return pricingBucket;
        }

        public final void setPricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
        }

        @Override
        public final Builder pricingBucket(String pricingBucket) {
            this.pricingBucket = pricingBucket;
            return this;
        }

        public final List<Route.Builder> getRoutes() {
            List<Route.Builder> result = RouteListCopier.copyToBuilder(this.routes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutes(Collection<Route.BuilderImpl> routes) {
            this.routes = RouteListCopier.copyFromBuilder(routes);
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route... routes) {
            routes(Arrays.asList(routes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Consumer<Route.Builder>... routes) {
            routes(Stream.of(routes).map(c -> Route.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CalculateRoutesResponse build() {
            return new CalculateRoutesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
