/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Calculated isolines and associated properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Isoline implements SdkPojo, Serializable, ToCopyableBuilder<Isoline.Builder, Isoline> {
    private static final SdkField<List<IsolineConnection>> CONNECTIONS_FIELD = SdkField
            .<List<IsolineConnection>> builder(MarshallingType.LIST)
            .memberName("Connections")
            .getter(getter(Isoline::connections))
            .setter(setter(Builder::connections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IsolineConnection> builder(MarshallingType.SDK_POJO)
                                            .constructor(IsolineConnection::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> DISTANCE_THRESHOLD_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DistanceThreshold").getter(getter(Isoline::distanceThreshold))
            .setter(setter(Builder::distanceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DistanceThreshold").build()).build();

    private static final SdkField<List<IsolineShapeGeometry>> GEOMETRIES_FIELD = SdkField
            .<List<IsolineShapeGeometry>> builder(MarshallingType.LIST)
            .memberName("Geometries")
            .getter(getter(Isoline::geometries))
            .setter(setter(Builder::geometries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Geometries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IsolineShapeGeometry> builder(MarshallingType.SDK_POJO)
                                            .constructor(IsolineShapeGeometry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TIME_THRESHOLD_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TimeThreshold").getter(getter(Isoline::timeThreshold)).setter(setter(Builder::timeThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeThreshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTIONS_FIELD,
            DISTANCE_THRESHOLD_FIELD, GEOMETRIES_FIELD, TIME_THRESHOLD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<IsolineConnection> connections;

    private final Long distanceThreshold;

    private final List<IsolineShapeGeometry> geometries;

    private final Long timeThreshold;

    private Isoline(BuilderImpl builder) {
        this.connections = builder.connections;
        this.distanceThreshold = builder.distanceThreshold;
        this.geometries = builder.geometries;
        this.timeThreshold = builder.timeThreshold;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connections property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConnections() {
        return connections != null && !(connections instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Isolines may contain multiple components, if these components are connected by ferry links. These components are
     * returned as separate polygons while the ferry links are returned as connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnections} method.
     * </p>
     * 
     * @return Isolines may contain multiple components, if these components are connected by ferry links. These
     *         components are returned as separate polygons while the ferry links are returned as connections.
     */
    public final List<IsolineConnection> connections() {
        return connections;
    }

    /**
     * <p>
     * Distance threshold corresponding to the calculated Isoline.
     * </p>
     * 
     * @return Distance threshold corresponding to the calculated Isoline.
     */
    public final Long distanceThreshold() {
        return distanceThreshold;
    }

    /**
     * For responses, this returns true if the service returned a value for the Geometries property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGeometries() {
        return geometries != null && !(geometries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Geometries for the Calculated isolines.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGeometries} method.
     * </p>
     * 
     * @return Geometries for the Calculated isolines.
     */
    public final List<IsolineShapeGeometry> geometries() {
        return geometries;
    }

    /**
     * <p>
     * Time threshold corresponding to the calculated isoline.
     * </p>
     * 
     * @return Time threshold corresponding to the calculated isoline.
     */
    public final Long timeThreshold() {
        return timeThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasConnections() ? connections() : null);
        hashCode = 31 * hashCode + Objects.hashCode(distanceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(hasGeometries() ? geometries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeThreshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Isoline)) {
            return false;
        }
        Isoline other = (Isoline) obj;
        return hasConnections() == other.hasConnections() && Objects.equals(connections(), other.connections())
                && Objects.equals(distanceThreshold(), other.distanceThreshold()) && hasGeometries() == other.hasGeometries()
                && Objects.equals(geometries(), other.geometries()) && Objects.equals(timeThreshold(), other.timeThreshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Isoline").add("Connections", hasConnections() ? connections() : null)
                .add("DistanceThreshold", distanceThreshold()).add("Geometries", hasGeometries() ? geometries() : null)
                .add("TimeThreshold", timeThreshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connections":
            return Optional.ofNullable(clazz.cast(connections()));
        case "DistanceThreshold":
            return Optional.ofNullable(clazz.cast(distanceThreshold()));
        case "Geometries":
            return Optional.ofNullable(clazz.cast(geometries()));
        case "TimeThreshold":
            return Optional.ofNullable(clazz.cast(timeThreshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Connections", CONNECTIONS_FIELD);
        map.put("DistanceThreshold", DISTANCE_THRESHOLD_FIELD);
        map.put("Geometries", GEOMETRIES_FIELD);
        map.put("TimeThreshold", TIME_THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Isoline, T> g) {
        return obj -> g.apply((Isoline) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Isoline> {
        /**
         * <p>
         * Isolines may contain multiple components, if these components are connected by ferry links. These components
         * are returned as separate polygons while the ferry links are returned as connections.
         * </p>
         * 
         * @param connections
         *        Isolines may contain multiple components, if these components are connected by ferry links. These
         *        components are returned as separate polygons while the ferry links are returned as connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(Collection<IsolineConnection> connections);

        /**
         * <p>
         * Isolines may contain multiple components, if these components are connected by ferry links. These components
         * are returned as separate polygons while the ferry links are returned as connections.
         * </p>
         * 
         * @param connections
         *        Isolines may contain multiple components, if these components are connected by ferry links. These
         *        components are returned as separate polygons while the ferry links are returned as connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connections(IsolineConnection... connections);

        /**
         * <p>
         * Isolines may contain multiple components, if these components are connected by ferry links. These components
         * are returned as separate polygons while the ferry links are returned as connections.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.IsolineConnection.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.georoutes.model.IsolineConnection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.IsolineConnection.Builder#build()} is called
         * immediately and its result is passed to {@link #connections(List<IsolineConnection>)}.
         * 
         * @param connections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.IsolineConnection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connections(java.util.Collection<IsolineConnection>)
         */
        Builder connections(Consumer<IsolineConnection.Builder>... connections);

        /**
         * <p>
         * Distance threshold corresponding to the calculated Isoline.
         * </p>
         * 
         * @param distanceThreshold
         *        Distance threshold corresponding to the calculated Isoline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder distanceThreshold(Long distanceThreshold);

        /**
         * <p>
         * Geometries for the Calculated isolines.
         * </p>
         * 
         * @param geometries
         *        Geometries for the Calculated isolines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometries(Collection<IsolineShapeGeometry> geometries);

        /**
         * <p>
         * Geometries for the Calculated isolines.
         * </p>
         * 
         * @param geometries
         *        Geometries for the Calculated isolines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geometries(IsolineShapeGeometry... geometries);

        /**
         * <p>
         * Geometries for the Calculated isolines.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.IsolineShapeGeometry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.IsolineShapeGeometry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.IsolineShapeGeometry.Builder#build()} is called
         * immediately and its result is passed to {@link #geometries(List<IsolineShapeGeometry>)}.
         * 
         * @param geometries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.IsolineShapeGeometry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geometries(java.util.Collection<IsolineShapeGeometry>)
         */
        Builder geometries(Consumer<IsolineShapeGeometry.Builder>... geometries);

        /**
         * <p>
         * Time threshold corresponding to the calculated isoline.
         * </p>
         * 
         * @param timeThreshold
         *        Time threshold corresponding to the calculated isoline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeThreshold(Long timeThreshold);
    }

    static final class BuilderImpl implements Builder {
        private List<IsolineConnection> connections = DefaultSdkAutoConstructList.getInstance();

        private Long distanceThreshold;

        private List<IsolineShapeGeometry> geometries = DefaultSdkAutoConstructList.getInstance();

        private Long timeThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(Isoline model) {
            connections(model.connections);
            distanceThreshold(model.distanceThreshold);
            geometries(model.geometries);
            timeThreshold(model.timeThreshold);
        }

        public final List<IsolineConnection.Builder> getConnections() {
            List<IsolineConnection.Builder> result = IsolineConnectionListCopier.copyToBuilder(this.connections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnections(Collection<IsolineConnection.BuilderImpl> connections) {
            this.connections = IsolineConnectionListCopier.copyFromBuilder(connections);
        }

        @Override
        public final Builder connections(Collection<IsolineConnection> connections) {
            this.connections = IsolineConnectionListCopier.copy(connections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(IsolineConnection... connections) {
            connections(Arrays.asList(connections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connections(Consumer<IsolineConnection.Builder>... connections) {
            connections(Stream.of(connections).map(c -> IsolineConnection.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getDistanceThreshold() {
            return distanceThreshold;
        }

        public final void setDistanceThreshold(Long distanceThreshold) {
            this.distanceThreshold = distanceThreshold;
        }

        @Override
        public final Builder distanceThreshold(Long distanceThreshold) {
            this.distanceThreshold = distanceThreshold;
            return this;
        }

        public final List<IsolineShapeGeometry.Builder> getGeometries() {
            List<IsolineShapeGeometry.Builder> result = IsolineShapeGeometryListCopier.copyToBuilder(this.geometries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGeometries(Collection<IsolineShapeGeometry.BuilderImpl> geometries) {
            this.geometries = IsolineShapeGeometryListCopier.copyFromBuilder(geometries);
        }

        @Override
        public final Builder geometries(Collection<IsolineShapeGeometry> geometries) {
            this.geometries = IsolineShapeGeometryListCopier.copy(geometries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geometries(IsolineShapeGeometry... geometries) {
            geometries(Arrays.asList(geometries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder geometries(Consumer<IsolineShapeGeometry.Builder>... geometries) {
            geometries(Stream.of(geometries).map(c -> IsolineShapeGeometry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Long getTimeThreshold() {
            return timeThreshold;
        }

        public final void setTimeThreshold(Long timeThreshold) {
            this.timeThreshold = timeThreshold;
        }

        @Override
        public final Builder timeThreshold(Long timeThreshold) {
            this.timeThreshold = timeThreshold;
            return this;
        }

        @Override
        public Isoline build() {
            return new Isoline(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
