/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Travel mode related options for the provided travel mode.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IsolineTravelModeOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<IsolineTravelModeOptions.Builder, IsolineTravelModeOptions> {
    private static final SdkField<IsolineCarOptions> CAR_FIELD = SdkField.<IsolineCarOptions> builder(MarshallingType.SDK_POJO)
            .memberName("Car").getter(getter(IsolineTravelModeOptions::car)).setter(setter(Builder::car))
            .constructor(IsolineCarOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Car").build()).build();

    private static final SdkField<IsolineScooterOptions> SCOOTER_FIELD = SdkField
            .<IsolineScooterOptions> builder(MarshallingType.SDK_POJO).memberName("Scooter")
            .getter(getter(IsolineTravelModeOptions::scooter)).setter(setter(Builder::scooter))
            .constructor(IsolineScooterOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scooter").build()).build();

    private static final SdkField<IsolineTruckOptions> TRUCK_FIELD = SdkField
            .<IsolineTruckOptions> builder(MarshallingType.SDK_POJO).memberName("Truck")
            .getter(getter(IsolineTravelModeOptions::truck)).setter(setter(Builder::truck))
            .constructor(IsolineTruckOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Truck").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAR_FIELD, SCOOTER_FIELD,
            TRUCK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IsolineCarOptions car;

    private final IsolineScooterOptions scooter;

    private final IsolineTruckOptions truck;

    private IsolineTravelModeOptions(BuilderImpl builder) {
        this.car = builder.car;
        this.scooter = builder.scooter;
        this.truck = builder.truck;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Car"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Car"
     */
    public final IsolineCarOptions car() {
        return car;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is <code>Scooter</code>
     * </p>
     * <note>
     * <p>
     * When travel mode is set to <code>Scooter</code>, then the avoidance option <code>ControlledAccessHighways</code>
     * defaults to <code>true</code>.
     * </p>
     * </note>
     * 
     * @return Travel mode options when the provided travel mode is <code>Scooter</code> </p> <note>
     *         <p>
     *         When travel mode is set to <code>Scooter</code>, then the avoidance option
     *         <code>ControlledAccessHighways</code> defaults to <code>true</code>.
     *         </p>
     */
    public final IsolineScooterOptions scooter() {
        return scooter;
    }

    /**
     * <p>
     * Travel mode options when the provided travel mode is "Truck"
     * </p>
     * 
     * @return Travel mode options when the provided travel mode is "Truck"
     */
    public final IsolineTruckOptions truck() {
        return truck;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(car());
        hashCode = 31 * hashCode + Objects.hashCode(scooter());
        hashCode = 31 * hashCode + Objects.hashCode(truck());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IsolineTravelModeOptions)) {
            return false;
        }
        IsolineTravelModeOptions other = (IsolineTravelModeOptions) obj;
        return Objects.equals(car(), other.car()) && Objects.equals(scooter(), other.scooter())
                && Objects.equals(truck(), other.truck());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IsolineTravelModeOptions").add("Car", car()).add("Scooter", scooter()).add("Truck", truck())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Car":
            return Optional.ofNullable(clazz.cast(car()));
        case "Scooter":
            return Optional.ofNullable(clazz.cast(scooter()));
        case "Truck":
            return Optional.ofNullable(clazz.cast(truck()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Car", CAR_FIELD);
        map.put("Scooter", SCOOTER_FIELD);
        map.put("Truck", TRUCK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IsolineTravelModeOptions, T> g) {
        return obj -> g.apply((IsolineTravelModeOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IsolineTravelModeOptions> {
        /**
         * <p>
         * Travel mode options when the provided travel mode is "Car"
         * </p>
         * 
         * @param car
         *        Travel mode options when the provided travel mode is "Car"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder car(IsolineCarOptions car);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Car"
         * </p>
         * This is a convenience method that creates an instance of the {@link IsolineCarOptions.Builder} avoiding the
         * need to create one manually via {@link IsolineCarOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IsolineCarOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #car(IsolineCarOptions)}.
         * 
         * @param car
         *        a consumer that will call methods on {@link IsolineCarOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #car(IsolineCarOptions)
         */
        default Builder car(Consumer<IsolineCarOptions.Builder> car) {
            return car(IsolineCarOptions.builder().applyMutation(car).build());
        }

        /**
         * <p>
         * Travel mode options when the provided travel mode is <code>Scooter</code>
         * </p>
         * <note>
         * <p>
         * When travel mode is set to <code>Scooter</code>, then the avoidance option
         * <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         * </p>
         * </note>
         * 
         * @param scooter
         *        Travel mode options when the provided travel mode is <code>Scooter</code> </p> <note>
         *        <p>
         *        When travel mode is set to <code>Scooter</code>, then the avoidance option
         *        <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scooter(IsolineScooterOptions scooter);

        /**
         * <p>
         * Travel mode options when the provided travel mode is <code>Scooter</code>
         * </p>
         * <note>
         * <p>
         * When travel mode is set to <code>Scooter</code>, then the avoidance option
         * <code>ControlledAccessHighways</code> defaults to <code>true</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link IsolineScooterOptions.Builder}
         * avoiding the need to create one manually via {@link IsolineScooterOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IsolineScooterOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #scooter(IsolineScooterOptions)}.
         * 
         * @param scooter
         *        a consumer that will call methods on {@link IsolineScooterOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scooter(IsolineScooterOptions)
         */
        default Builder scooter(Consumer<IsolineScooterOptions.Builder> scooter) {
            return scooter(IsolineScooterOptions.builder().applyMutation(scooter).build());
        }

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck"
         * </p>
         * 
         * @param truck
         *        Travel mode options when the provided travel mode is "Truck"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truck(IsolineTruckOptions truck);

        /**
         * <p>
         * Travel mode options when the provided travel mode is "Truck"
         * </p>
         * This is a convenience method that creates an instance of the {@link IsolineTruckOptions.Builder} avoiding the
         * need to create one manually via {@link IsolineTruckOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IsolineTruckOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #truck(IsolineTruckOptions)}.
         * 
         * @param truck
         *        a consumer that will call methods on {@link IsolineTruckOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #truck(IsolineTruckOptions)
         */
        default Builder truck(Consumer<IsolineTruckOptions.Builder> truck) {
            return truck(IsolineTruckOptions.builder().applyMutation(truck).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IsolineCarOptions car;

        private IsolineScooterOptions scooter;

        private IsolineTruckOptions truck;

        private BuilderImpl() {
        }

        private BuilderImpl(IsolineTravelModeOptions model) {
            car(model.car);
            scooter(model.scooter);
            truck(model.truck);
        }

        public final IsolineCarOptions.Builder getCar() {
            return car != null ? car.toBuilder() : null;
        }

        public final void setCar(IsolineCarOptions.BuilderImpl car) {
            this.car = car != null ? car.build() : null;
        }

        @Override
        public final Builder car(IsolineCarOptions car) {
            this.car = car;
            return this;
        }

        public final IsolineScooterOptions.Builder getScooter() {
            return scooter != null ? scooter.toBuilder() : null;
        }

        public final void setScooter(IsolineScooterOptions.BuilderImpl scooter) {
            this.scooter = scooter != null ? scooter.build() : null;
        }

        @Override
        public final Builder scooter(IsolineScooterOptions scooter) {
            this.scooter = scooter;
            return this;
        }

        public final IsolineTruckOptions.Builder getTruck() {
            return truck != null ? truck.toBuilder() : null;
        }

        public final void setTruck(IsolineTruckOptions.BuilderImpl truck) {
            this.truck = truck != null ? truck.build() : null;
        }

        @Override
        public final Builder truck(IsolineTruckOptions truck) {
            this.truck = truck;
            return this;
        }

        @Override
        public IsolineTravelModeOptions build() {
            return new IsolineTravelModeOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
