/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TracePoints snapped onto the road network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoadSnapSnappedTracePoint implements SdkPojo, Serializable,
        ToCopyableBuilder<RoadSnapSnappedTracePoint.Builder, RoadSnapSnappedTracePoint> {
    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("Confidence").getter(getter(RoadSnapSnappedTracePoint::confidence)).setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<List<Double>> ORIGINAL_POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("OriginalPosition")
            .getter(getter(RoadSnapSnappedTracePoint::originalPosition))
            .setter(setter(Builder::originalPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginalPosition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> SNAPPED_POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("SnappedPosition")
            .getter(getter(RoadSnapSnappedTracePoint::snappedPosition))
            .setter(setter(Builder::snappedPosition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnappedPosition").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIDENCE_FIELD,
            ORIGINAL_POSITION_FIELD, SNAPPED_POSITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double confidence;

    private final List<Double> originalPosition;

    private final List<Double> snappedPosition;

    private RoadSnapSnappedTracePoint(BuilderImpl builder) {
        this.confidence = builder.confidence;
        this.originalPosition = builder.originalPosition;
        this.snappedPosition = builder.snappedPosition;
    }

    /**
     * <p>
     * Confidence value for the correctness of this point match.
     * </p>
     * 
     * @return Confidence value for the correctness of this point match.
     */
    public final Double confidence() {
        return confidence;
    }

    /**
     * For responses, this returns true if the service returned a value for the OriginalPosition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOriginalPosition() {
        return originalPosition != null && !(originalPosition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position of the TracePoint provided within the request, at the same index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOriginalPosition} method.
     * </p>
     * 
     * @return Position of the TracePoint provided within the request, at the same index.
     */
    public final List<Double> originalPosition() {
        return originalPosition;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnappedPosition property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnappedPosition() {
        return snappedPosition != null && !(snappedPosition instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Snapped position of the TracePoint provided within the request, at the same index.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnappedPosition} method.
     * </p>
     * 
     * @return Snapped position of the TracePoint provided within the request, at the same index.
     */
    public final List<Double> snappedPosition() {
        return snappedPosition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(hasOriginalPosition() ? originalPosition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSnappedPosition() ? snappedPosition() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapSnappedTracePoint)) {
            return false;
        }
        RoadSnapSnappedTracePoint other = (RoadSnapSnappedTracePoint) obj;
        return Objects.equals(confidence(), other.confidence()) && hasOriginalPosition() == other.hasOriginalPosition()
                && Objects.equals(originalPosition(), other.originalPosition())
                && hasSnappedPosition() == other.hasSnappedPosition()
                && Objects.equals(snappedPosition(), other.snappedPosition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoadSnapSnappedTracePoint").add("Confidence", confidence())
                .add("OriginalPosition", originalPosition() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SnappedPosition", snappedPosition() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "OriginalPosition":
            return Optional.ofNullable(clazz.cast(originalPosition()));
        case "SnappedPosition":
            return Optional.ofNullable(clazz.cast(snappedPosition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("OriginalPosition", ORIGINAL_POSITION_FIELD);
        map.put("SnappedPosition", SNAPPED_POSITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapSnappedTracePoint, T> g) {
        return obj -> g.apply((RoadSnapSnappedTracePoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoadSnapSnappedTracePoint> {
        /**
         * <p>
         * Confidence value for the correctness of this point match.
         * </p>
         * 
         * @param confidence
         *        Confidence value for the correctness of this point match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Double confidence);

        /**
         * <p>
         * Position of the TracePoint provided within the request, at the same index.
         * </p>
         * 
         * @param originalPosition
         *        Position of the TracePoint provided within the request, at the same index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalPosition(Collection<Double> originalPosition);

        /**
         * <p>
         * Position of the TracePoint provided within the request, at the same index.
         * </p>
         * 
         * @param originalPosition
         *        Position of the TracePoint provided within the request, at the same index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalPosition(Double... originalPosition);

        /**
         * <p>
         * Snapped position of the TracePoint provided within the request, at the same index.
         * </p>
         * 
         * @param snappedPosition
         *        Snapped position of the TracePoint provided within the request, at the same index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedPosition(Collection<Double> snappedPosition);

        /**
         * <p>
         * Snapped position of the TracePoint provided within the request, at the same index.
         * </p>
         * 
         * @param snappedPosition
         *        Snapped position of the TracePoint provided within the request, at the same index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snappedPosition(Double... snappedPosition);
    }

    static final class BuilderImpl implements Builder {
        private Double confidence;

        private List<Double> originalPosition = DefaultSdkAutoConstructList.getInstance();

        private List<Double> snappedPosition = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapSnappedTracePoint model) {
            confidence(model.confidence);
            originalPosition(model.originalPosition);
            snappedPosition(model.snappedPosition);
        }

        public final Double getConfidence() {
            return confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Collection<Double> getOriginalPosition() {
            if (originalPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return originalPosition;
        }

        public final void setOriginalPosition(Collection<Double> originalPosition) {
            this.originalPosition = PositionCopier.copy(originalPosition);
        }

        @Override
        public final Builder originalPosition(Collection<Double> originalPosition) {
            this.originalPosition = PositionCopier.copy(originalPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder originalPosition(Double... originalPosition) {
            originalPosition(Arrays.asList(originalPosition));
            return this;
        }

        public final Collection<Double> getSnappedPosition() {
            if (snappedPosition instanceof SdkAutoConstructList) {
                return null;
            }
            return snappedPosition;
        }

        public final void setSnappedPosition(Collection<Double> snappedPosition) {
            this.snappedPosition = PositionCopier.copy(snappedPosition);
        }

        @Override
        public final Builder snappedPosition(Collection<Double> snappedPosition) {
            this.snappedPosition = PositionCopier.copy(snappedPosition);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snappedPosition(Double... snappedPosition) {
            snappedPosition(Arrays.asList(snappedPosition));
            return this;
        }

        @Override
        public RoadSnapSnappedTracePoint build() {
            return new RoadSnapSnappedTracePoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
