/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * TracePoint indices for which the provided notice code corresponds to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoadSnapTracePoint implements SdkPojo, Serializable,
        ToCopyableBuilder<RoadSnapTracePoint.Builder, RoadSnapTracePoint> {
    private static final SdkField<Double> HEADING_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Heading")
            .getter(getter(RoadSnapTracePoint::heading)).setter(setter(Builder::heading))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Heading").build()).build();

    private static final SdkField<List<Double>> POSITION_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("Position")
            .getter(getter(RoadSnapTracePoint::position))
            .setter(setter(Builder::position))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> SPEED_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Speed")
            .getter(getter(RoadSnapTracePoint::speed)).setter(setter(Builder::speed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Speed").build()).build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timestamp").getter(getter(RoadSnapTracePoint::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADING_FIELD, POSITION_FIELD,
            SPEED_FIELD, TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double heading;

    private final List<Double> position;

    private final Double speed;

    private final String timestamp;

    private RoadSnapTracePoint(BuilderImpl builder) {
        this.heading = builder.heading;
        this.position = builder.position;
        this.speed = builder.speed;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * GPS Heading at the position.
     * </p>
     * 
     * @return GPS Heading at the position.
     */
    public final Double heading() {
        return heading;
    }

    /**
     * For responses, this returns true if the service returned a value for the Position property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPosition() {
        return position != null && !(position instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Position defined as <code>[longitude, latitude]</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPosition} method.
     * </p>
     * 
     * @return Position defined as <code>[longitude, latitude]</code>.
     */
    public final List<Double> position() {
        return position;
    }

    /**
     * <p>
     * Speed at the specified trace point .
     * </p>
     * <p>
     * <b>Unit</b>: <code>KilometersPerHour</code>
     * </p>
     * 
     * @return Speed at the specified trace point .</p>
     *         <p>
     *         <b>Unit</b>: <code>KilometersPerHour</code>
     */
    public final Double speed() {
        return speed;
    }

    /**
     * <p>
     * Timestamp of the event.
     * </p>
     * 
     * @return Timestamp of the event.
     */
    public final String timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(heading());
        hashCode = 31 * hashCode + Objects.hashCode(hasPosition() ? position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(speed());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapTracePoint)) {
            return false;
        }
        RoadSnapTracePoint other = (RoadSnapTracePoint) obj;
        return Objects.equals(heading(), other.heading()) && hasPosition() == other.hasPosition()
                && Objects.equals(position(), other.position()) && Objects.equals(speed(), other.speed())
                && Objects.equals(timestamp(), other.timestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoadSnapTracePoint").add("Heading", heading())
                .add("Position", position() == null ? null : "*** Sensitive Data Redacted ***").add("Speed", speed())
                .add("Timestamp", timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Heading":
            return Optional.ofNullable(clazz.cast(heading()));
        case "Position":
            return Optional.ofNullable(clazz.cast(position()));
        case "Speed":
            return Optional.ofNullable(clazz.cast(speed()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Heading", HEADING_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("Speed", SPEED_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapTracePoint, T> g) {
        return obj -> g.apply((RoadSnapTracePoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoadSnapTracePoint> {
        /**
         * <p>
         * GPS Heading at the position.
         * </p>
         * 
         * @param heading
         *        GPS Heading at the position.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heading(Double heading);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Collection<Double> position);

        /**
         * <p>
         * Position defined as <code>[longitude, latitude]</code>.
         * </p>
         * 
         * @param position
         *        Position defined as <code>[longitude, latitude]</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder position(Double... position);

        /**
         * <p>
         * Speed at the specified trace point .
         * </p>
         * <p>
         * <b>Unit</b>: <code>KilometersPerHour</code>
         * </p>
         * 
         * @param speed
         *        Speed at the specified trace point .</p>
         *        <p>
         *        <b>Unit</b>: <code>KilometersPerHour</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder speed(Double speed);

        /**
         * <p>
         * Timestamp of the event.
         * </p>
         * 
         * @param timestamp
         *        Timestamp of the event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);
    }

    static final class BuilderImpl implements Builder {
        private Double heading;

        private List<Double> position = DefaultSdkAutoConstructList.getInstance();

        private Double speed;

        private String timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapTracePoint model) {
            heading(model.heading);
            position(model.position);
            speed(model.speed);
            timestamp(model.timestamp);
        }

        public final Double getHeading() {
            return heading;
        }

        public final void setHeading(Double heading) {
            this.heading = heading;
        }

        @Override
        public final Builder heading(Double heading) {
            this.heading = heading;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (position instanceof SdkAutoConstructList) {
                return null;
            }
            return position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double... position) {
            position(Arrays.asList(position));
            return this;
        }

        public final Double getSpeed() {
            return speed;
        }

        public final void setSpeed(Double speed) {
            this.speed = speed;
        }

        @Override
        public final Builder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public RoadSnapTracePoint build() {
            return new RoadSnapTracePoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
