/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Travel mode options when the provided travel mode is "Truck".
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoadSnapTruckOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RoadSnapTruckOptions.Builder, RoadSnapTruckOptions> {
    private static final SdkField<Long> GROSS_WEIGHT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("GrossWeight").getter(getter(RoadSnapTruckOptions::grossWeight)).setter(setter(Builder::grossWeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrossWeight").build()).build();

    private static final SdkField<List<String>> HAZARDOUS_CARGOS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HazardousCargos")
            .getter(getter(RoadSnapTruckOptions::hazardousCargosAsStrings))
            .setter(setter(Builder::hazardousCargosWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HazardousCargos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> HEIGHT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Height")
            .getter(getter(RoadSnapTruckOptions::height)).setter(setter(Builder::height))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Height").build()).build();

    private static final SdkField<Long> LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Length")
            .getter(getter(RoadSnapTruckOptions::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Length").build()).build();

    private static final SdkField<RoadSnapTrailerOptions> TRAILER_FIELD = SdkField
            .<RoadSnapTrailerOptions> builder(MarshallingType.SDK_POJO).memberName("Trailer")
            .getter(getter(RoadSnapTruckOptions::trailer)).setter(setter(Builder::trailer))
            .constructor(RoadSnapTrailerOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trailer").build()).build();

    private static final SdkField<String> TUNNEL_RESTRICTION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TunnelRestrictionCode").getter(getter(RoadSnapTruckOptions::tunnelRestrictionCode))
            .setter(setter(Builder::tunnelRestrictionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TunnelRestrictionCode").build())
            .build();

    private static final SdkField<Long> WIDTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Width")
            .getter(getter(RoadSnapTruckOptions::width)).setter(setter(Builder::width))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROSS_WEIGHT_FIELD,
            HAZARDOUS_CARGOS_FIELD, HEIGHT_FIELD, LENGTH_FIELD, TRAILER_FIELD, TUNNEL_RESTRICTION_CODE_FIELD, WIDTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long grossWeight;

    private final List<String> hazardousCargos;

    private final Long height;

    private final Long length;

    private final RoadSnapTrailerOptions trailer;

    private final String tunnelRestrictionCode;

    private final Long width;

    private RoadSnapTruckOptions(BuilderImpl builder) {
        this.grossWeight = builder.grossWeight;
        this.hazardousCargos = builder.hazardousCargos;
        this.height = builder.height;
        this.length = builder.length;
        this.trailer = builder.trailer;
        this.tunnelRestrictionCode = builder.tunnelRestrictionCode;
        this.width = builder.width;
    }

    /**
     * <p>
     * Gross weight of the vehicle including trailers, and goods at capacity.
     * </p>
     * <p>
     * <b>Unit</b>: <code>Kilograms</code>
     * </p>
     * 
     * @return Gross weight of the vehicle including trailers, and goods at capacity.</p>
     *         <p>
     *         <b>Unit</b>: <code>Kilograms</code>
     */
    public final Long grossWeight() {
        return grossWeight;
    }

    /**
     * <p>
     * List of Hazardous cargos contained in the vehicle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHazardousCargos} method.
     * </p>
     * 
     * @return List of Hazardous cargos contained in the vehicle.
     */
    public final List<RoadSnapHazardousCargoType> hazardousCargos() {
        return RoadSnapHazardousCargoTypeListCopier.copyStringToEnum(hazardousCargos);
    }

    /**
     * For responses, this returns true if the service returned a value for the HazardousCargos property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHazardousCargos() {
        return hazardousCargos != null && !(hazardousCargos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Hazardous cargos contained in the vehicle.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHazardousCargos} method.
     * </p>
     * 
     * @return List of Hazardous cargos contained in the vehicle.
     */
    public final List<String> hazardousCargosAsStrings() {
        return hazardousCargos;
    }

    /**
     * <p>
     * Height of the vehicle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>centimeters</code>
     * </p>
     * 
     * @return Height of the vehicle.</p>
     *         <p>
     *         <b>Unit</b>: <code>centimeters</code>
     */
    public final Long height() {
        return height;
    }

    /**
     * <p>
     * Length of the vehicle.
     * </p>
     * <p>
     * <b>Unit</b>: <code>centimeters</code>
     * </p>
     * 
     * @return Length of the vehicle.</p>
     *         <p>
     *         <b>Unit</b>: <code>centimeters</code>
     */
    public final Long length() {
        return length;
    }

    /**
     * <p>
     * Trailer options corresponding to the vehicle.
     * </p>
     * 
     * @return Trailer options corresponding to the vehicle.
     */
    public final RoadSnapTrailerOptions trailer() {
        return trailer;
    }

    /**
     * <p>
     * The tunnel restriction code.
     * </p>
     * <p>
     * Tunnel categories in this list indicate the restrictions which apply to certain tunnels in Great Britain. They
     * relate to the types of dangerous goods that can be transported through them.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Tunnel Category B</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Risk Level</i>: Limited risk
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Restrictions</i>: Few restrictions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i>Tunnel Category C</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Risk Level</i>: Medium risk
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Restrictions</i>: Some restrictions
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i>Tunnel Category D</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Risk Level</i>: High risk
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Restrictions</i>: Many restrictions occur
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <i>Tunnel Category E</i>
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Risk Level</i>: Very high risk
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>Restrictions</i>: Restricted tunnel
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * 
     * @return The tunnel restriction code.</p>
     *         <p>
     *         Tunnel categories in this list indicate the restrictions which apply to certain tunnels in Great Britain.
     *         They relate to the types of dangerous goods that can be transported through them.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Tunnel Category B</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Risk Level</i>: Limited risk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Restrictions</i>: Few restrictions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tunnel Category C</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Risk Level</i>: Medium risk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Restrictions</i>: Some restrictions
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tunnel Category D</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Risk Level</i>: High risk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Restrictions</i>: Many restrictions occur
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Tunnel Category E</i>
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>Risk Level</i>: Very high risk
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>Restrictions</i>: Restricted tunnel
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final String tunnelRestrictionCode() {
        return tunnelRestrictionCode;
    }

    /**
     * <p>
     * Width of the vehicle in centimenters.
     * </p>
     * 
     * @return Width of the vehicle in centimenters.
     */
    public final Long width() {
        return width;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(grossWeight());
        hashCode = 31 * hashCode + Objects.hashCode(hasHazardousCargos() ? hazardousCargosAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(height());
        hashCode = 31 * hashCode + Objects.hashCode(length());
        hashCode = 31 * hashCode + Objects.hashCode(trailer());
        hashCode = 31 * hashCode + Objects.hashCode(tunnelRestrictionCode());
        hashCode = 31 * hashCode + Objects.hashCode(width());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoadSnapTruckOptions)) {
            return false;
        }
        RoadSnapTruckOptions other = (RoadSnapTruckOptions) obj;
        return Objects.equals(grossWeight(), other.grossWeight()) && hasHazardousCargos() == other.hasHazardousCargos()
                && Objects.equals(hazardousCargosAsStrings(), other.hazardousCargosAsStrings())
                && Objects.equals(height(), other.height()) && Objects.equals(length(), other.length())
                && Objects.equals(trailer(), other.trailer())
                && Objects.equals(tunnelRestrictionCode(), other.tunnelRestrictionCode())
                && Objects.equals(width(), other.width());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RoadSnapTruckOptions").add("GrossWeight", grossWeight())
                .add("HazardousCargos", hasHazardousCargos() ? hazardousCargosAsStrings() : null).add("Height", height())
                .add("Length", length()).add("Trailer", trailer()).add("TunnelRestrictionCode", tunnelRestrictionCode())
                .add("Width", width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GrossWeight":
            return Optional.ofNullable(clazz.cast(grossWeight()));
        case "HazardousCargos":
            return Optional.ofNullable(clazz.cast(hazardousCargosAsStrings()));
        case "Height":
            return Optional.ofNullable(clazz.cast(height()));
        case "Length":
            return Optional.ofNullable(clazz.cast(length()));
        case "Trailer":
            return Optional.ofNullable(clazz.cast(trailer()));
        case "TunnelRestrictionCode":
            return Optional.ofNullable(clazz.cast(tunnelRestrictionCode()));
        case "Width":
            return Optional.ofNullable(clazz.cast(width()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GrossWeight", GROSS_WEIGHT_FIELD);
        map.put("HazardousCargos", HAZARDOUS_CARGOS_FIELD);
        map.put("Height", HEIGHT_FIELD);
        map.put("Length", LENGTH_FIELD);
        map.put("Trailer", TRAILER_FIELD);
        map.put("TunnelRestrictionCode", TUNNEL_RESTRICTION_CODE_FIELD);
        map.put("Width", WIDTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RoadSnapTruckOptions, T> g) {
        return obj -> g.apply((RoadSnapTruckOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoadSnapTruckOptions> {
        /**
         * <p>
         * Gross weight of the vehicle including trailers, and goods at capacity.
         * </p>
         * <p>
         * <b>Unit</b>: <code>Kilograms</code>
         * </p>
         * 
         * @param grossWeight
         *        Gross weight of the vehicle including trailers, and goods at capacity.</p>
         *        <p>
         *        <b>Unit</b>: <code>Kilograms</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grossWeight(Long grossWeight);

        /**
         * <p>
         * List of Hazardous cargos contained in the vehicle.
         * </p>
         * 
         * @param hazardousCargos
         *        List of Hazardous cargos contained in the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hazardousCargosWithStrings(Collection<String> hazardousCargos);

        /**
         * <p>
         * List of Hazardous cargos contained in the vehicle.
         * </p>
         * 
         * @param hazardousCargos
         *        List of Hazardous cargos contained in the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hazardousCargosWithStrings(String... hazardousCargos);

        /**
         * <p>
         * List of Hazardous cargos contained in the vehicle.
         * </p>
         * 
         * @param hazardousCargos
         *        List of Hazardous cargos contained in the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hazardousCargos(Collection<RoadSnapHazardousCargoType> hazardousCargos);

        /**
         * <p>
         * List of Hazardous cargos contained in the vehicle.
         * </p>
         * 
         * @param hazardousCargos
         *        List of Hazardous cargos contained in the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hazardousCargos(RoadSnapHazardousCargoType... hazardousCargos);

        /**
         * <p>
         * Height of the vehicle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>centimeters</code>
         * </p>
         * 
         * @param height
         *        Height of the vehicle.</p>
         *        <p>
         *        <b>Unit</b>: <code>centimeters</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder height(Long height);

        /**
         * <p>
         * Length of the vehicle.
         * </p>
         * <p>
         * <b>Unit</b>: <code>centimeters</code>
         * </p>
         * 
         * @param length
         *        Length of the vehicle.</p>
         *        <p>
         *        <b>Unit</b>: <code>centimeters</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Long length);

        /**
         * <p>
         * Trailer options corresponding to the vehicle.
         * </p>
         * 
         * @param trailer
         *        Trailer options corresponding to the vehicle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailer(RoadSnapTrailerOptions trailer);

        /**
         * <p>
         * Trailer options corresponding to the vehicle.
         * </p>
         * This is a convenience method that creates an instance of the {@link RoadSnapTrailerOptions.Builder} avoiding
         * the need to create one manually via {@link RoadSnapTrailerOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RoadSnapTrailerOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #trailer(RoadSnapTrailerOptions)}.
         * 
         * @param trailer
         *        a consumer that will call methods on {@link RoadSnapTrailerOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trailer(RoadSnapTrailerOptions)
         */
        default Builder trailer(Consumer<RoadSnapTrailerOptions.Builder> trailer) {
            return trailer(RoadSnapTrailerOptions.builder().applyMutation(trailer).build());
        }

        /**
         * <p>
         * The tunnel restriction code.
         * </p>
         * <p>
         * Tunnel categories in this list indicate the restrictions which apply to certain tunnels in Great Britain.
         * They relate to the types of dangerous goods that can be transported through them.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Tunnel Category B</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Risk Level</i>: Limited risk
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Restrictions</i>: Few restrictions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i>Tunnel Category C</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Risk Level</i>: Medium risk
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Restrictions</i>: Some restrictions
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i>Tunnel Category D</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Risk Level</i>: High risk
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Restrictions</i>: Many restrictions occur
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <i>Tunnel Category E</i>
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>Risk Level</i>: Very high risk
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>Restrictions</i>: Restricted tunnel
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param tunnelRestrictionCode
         *        The tunnel restriction code.</p>
         *        <p>
         *        Tunnel categories in this list indicate the restrictions which apply to certain tunnels in Great
         *        Britain. They relate to the types of dangerous goods that can be transported through them.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Tunnel Category B</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Risk Level</i>: Limited risk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Restrictions</i>: Few restrictions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tunnel Category C</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Risk Level</i>: Medium risk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Restrictions</i>: Some restrictions
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tunnel Category D</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Risk Level</i>: High risk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Restrictions</i>: Many restrictions occur
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Tunnel Category E</i>
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>Risk Level</i>: Very high risk
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>Restrictions</i>: Restricted tunnel
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnelRestrictionCode(String tunnelRestrictionCode);

        /**
         * <p>
         * Width of the vehicle in centimenters.
         * </p>
         * 
         * @param width
         *        Width of the vehicle in centimenters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder width(Long width);
    }

    static final class BuilderImpl implements Builder {
        private Long grossWeight;

        private List<String> hazardousCargos = DefaultSdkAutoConstructList.getInstance();

        private Long height;

        private Long length;

        private RoadSnapTrailerOptions trailer;

        private String tunnelRestrictionCode;

        private Long width;

        private BuilderImpl() {
        }

        private BuilderImpl(RoadSnapTruckOptions model) {
            grossWeight(model.grossWeight);
            hazardousCargosWithStrings(model.hazardousCargos);
            height(model.height);
            length(model.length);
            trailer(model.trailer);
            tunnelRestrictionCode(model.tunnelRestrictionCode);
            width(model.width);
        }

        public final Long getGrossWeight() {
            return grossWeight;
        }

        public final void setGrossWeight(Long grossWeight) {
            this.grossWeight = grossWeight;
        }

        @Override
        public final Builder grossWeight(Long grossWeight) {
            this.grossWeight = grossWeight;
            return this;
        }

        public final Collection<String> getHazardousCargos() {
            if (hazardousCargos instanceof SdkAutoConstructList) {
                return null;
            }
            return hazardousCargos;
        }

        public final void setHazardousCargos(Collection<String> hazardousCargos) {
            this.hazardousCargos = RoadSnapHazardousCargoTypeListCopier.copy(hazardousCargos);
        }

        @Override
        public final Builder hazardousCargosWithStrings(Collection<String> hazardousCargos) {
            this.hazardousCargos = RoadSnapHazardousCargoTypeListCopier.copy(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargosWithStrings(String... hazardousCargos) {
            hazardousCargosWithStrings(Arrays.asList(hazardousCargos));
            return this;
        }

        @Override
        public final Builder hazardousCargos(Collection<RoadSnapHazardousCargoType> hazardousCargos) {
            this.hazardousCargos = RoadSnapHazardousCargoTypeListCopier.copyEnumToString(hazardousCargos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hazardousCargos(RoadSnapHazardousCargoType... hazardousCargos) {
            hazardousCargos(Arrays.asList(hazardousCargos));
            return this;
        }

        public final Long getHeight() {
            return height;
        }

        public final void setHeight(Long height) {
            this.height = height;
        }

        @Override
        public final Builder height(Long height) {
            this.height = height;
            return this;
        }

        public final Long getLength() {
            return length;
        }

        public final void setLength(Long length) {
            this.length = length;
        }

        @Override
        public final Builder length(Long length) {
            this.length = length;
            return this;
        }

        public final RoadSnapTrailerOptions.Builder getTrailer() {
            return trailer != null ? trailer.toBuilder() : null;
        }

        public final void setTrailer(RoadSnapTrailerOptions.BuilderImpl trailer) {
            this.trailer = trailer != null ? trailer.build() : null;
        }

        @Override
        public final Builder trailer(RoadSnapTrailerOptions trailer) {
            this.trailer = trailer;
            return this;
        }

        public final String getTunnelRestrictionCode() {
            return tunnelRestrictionCode;
        }

        public final void setTunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
        }

        @Override
        public final Builder tunnelRestrictionCode(String tunnelRestrictionCode) {
            this.tunnelRestrictionCode = tunnelRestrictionCode;
            return this;
        }

        public final Long getWidth() {
            return width;
        }

        public final void setWidth(Long width) {
            this.width = width;
        }

        @Override
        public final Builder width(Long width) {
            this.width = width;
            return this;
        }

        @Override
        public RoadSnapTruckOptions build() {
            return new RoadSnapTruckOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
