/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The route.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Route implements SdkPojo, Serializable, ToCopyableBuilder<Route.Builder, Route> {
    private static final SdkField<List<RouteLeg>> LEGS_FIELD = SdkField
            .<List<RouteLeg>> builder(MarshallingType.LIST)
            .memberName("Legs")
            .getter(getter(Route::legs))
            .setter(setter(Builder::legs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Legs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteLeg> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteLeg::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteMajorRoadLabel>> MAJOR_ROAD_LABELS_FIELD = SdkField
            .<List<RouteMajorRoadLabel>> builder(MarshallingType.LIST)
            .memberName("MajorRoadLabels")
            .getter(getter(Route::majorRoadLabels))
            .setter(setter(Builder::majorRoadLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorRoadLabels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteMajorRoadLabel> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteMajorRoadLabel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RouteSummary> SUMMARY_FIELD = SdkField.<RouteSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Summary").getter(getter(Route::summary)).setter(setter(Builder::summary))
            .constructor(RouteSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEGS_FIELD,
            MAJOR_ROAD_LABELS_FIELD, SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RouteLeg> legs;

    private final List<RouteMajorRoadLabel> majorRoadLabels;

    private final RouteSummary summary;

    private Route(BuilderImpl builder) {
        this.legs = builder.legs;
        this.majorRoadLabels = builder.majorRoadLabels;
        this.summary = builder.summary;
    }

    /**
     * For responses, this returns true if the service returned a value for the Legs property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasLegs() {
        return legs != null && !(legs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A leg is a section of a route from one waypoint to the next. A leg could be of type Vehicle, Pedestrian or Ferry.
     * Legs of different types could occur together within a single route. For example, a car employing the use of a
     * Ferry will contain Vehicle legs corresponding to journey on land, and Ferry legs corresponding to the journey via
     * Ferry.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLegs} method.
     * </p>
     * 
     * @return A leg is a section of a route from one waypoint to the next. A leg could be of type Vehicle, Pedestrian
     *         or Ferry. Legs of different types could occur together within a single route. For example, a car
     *         employing the use of a Ferry will contain Vehicle legs corresponding to journey on land, and Ferry legs
     *         corresponding to the journey via Ferry.
     */
    public final List<RouteLeg> legs() {
        return legs;
    }

    /**
     * For responses, this returns true if the service returned a value for the MajorRoadLabels property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMajorRoadLabels() {
        return majorRoadLabels != null && !(majorRoadLabels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Important labels including names and route numbers that differentiate the current route from the alternatives
     * presented.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMajorRoadLabels} method.
     * </p>
     * 
     * @return Important labels including names and route numbers that differentiate the current route from the
     *         alternatives presented.
     */
    public final List<RouteMajorRoadLabel> majorRoadLabels() {
        return majorRoadLabels;
    }

    /**
     * <p>
     * Summarized details of the leg.
     * </p>
     * 
     * @return Summarized details of the leg.
     */
    public final RouteSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLegs() ? legs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMajorRoadLabels() ? majorRoadLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route)) {
            return false;
        }
        Route other = (Route) obj;
        return hasLegs() == other.hasLegs() && Objects.equals(legs(), other.legs())
                && hasMajorRoadLabels() == other.hasMajorRoadLabels()
                && Objects.equals(majorRoadLabels(), other.majorRoadLabels()) && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Route").add("Legs", hasLegs() ? legs() : null)
                .add("MajorRoadLabels", hasMajorRoadLabels() ? majorRoadLabels() : null).add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Legs":
            return Optional.ofNullable(clazz.cast(legs()));
        case "MajorRoadLabels":
            return Optional.ofNullable(clazz.cast(majorRoadLabels()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Legs", LEGS_FIELD);
        map.put("MajorRoadLabels", MAJOR_ROAD_LABELS_FIELD);
        map.put("Summary", SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route, T> g) {
        return obj -> g.apply((Route) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Route> {
        /**
         * <p>
         * A leg is a section of a route from one waypoint to the next. A leg could be of type Vehicle, Pedestrian or
         * Ferry. Legs of different types could occur together within a single route. For example, a car employing the
         * use of a Ferry will contain Vehicle legs corresponding to journey on land, and Ferry legs corresponding to
         * the journey via Ferry.
         * </p>
         * 
         * @param legs
         *        A leg is a section of a route from one waypoint to the next. A leg could be of type Vehicle,
         *        Pedestrian or Ferry. Legs of different types could occur together within a single route. For example,
         *        a car employing the use of a Ferry will contain Vehicle legs corresponding to journey on land, and
         *        Ferry legs corresponding to the journey via Ferry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legs(Collection<RouteLeg> legs);

        /**
         * <p>
         * A leg is a section of a route from one waypoint to the next. A leg could be of type Vehicle, Pedestrian or
         * Ferry. Legs of different types could occur together within a single route. For example, a car employing the
         * use of a Ferry will contain Vehicle legs corresponding to journey on land, and Ferry legs corresponding to
         * the journey via Ferry.
         * </p>
         * 
         * @param legs
         *        A leg is a section of a route from one waypoint to the next. A leg could be of type Vehicle,
         *        Pedestrian or Ferry. Legs of different types could occur together within a single route. For example,
         *        a car employing the use of a Ferry will contain Vehicle legs corresponding to journey on land, and
         *        Ferry legs corresponding to the journey via Ferry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder legs(RouteLeg... legs);

        /**
         * <p>
         * A leg is a section of a route from one waypoint to the next. A leg could be of type Vehicle, Pedestrian or
         * Ferry. Legs of different types could occur together within a single route. For example, a car employing the
         * use of a Ferry will contain Vehicle legs corresponding to journey on land, and Ferry legs corresponding to
         * the journey via Ferry.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteLeg.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.georoutes.model.RouteLeg#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteLeg.Builder#build()} is called immediately and
         * its result is passed to {@link #legs(List<RouteLeg>)}.
         * 
         * @param legs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteLeg.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #legs(java.util.Collection<RouteLeg>)
         */
        Builder legs(Consumer<RouteLeg.Builder>... legs);

        /**
         * <p>
         * Important labels including names and route numbers that differentiate the current route from the alternatives
         * presented.
         * </p>
         * 
         * @param majorRoadLabels
         *        Important labels including names and route numbers that differentiate the current route from the
         *        alternatives presented.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorRoadLabels(Collection<RouteMajorRoadLabel> majorRoadLabels);

        /**
         * <p>
         * Important labels including names and route numbers that differentiate the current route from the alternatives
         * presented.
         * </p>
         * 
         * @param majorRoadLabels
         *        Important labels including names and route numbers that differentiate the current route from the
         *        alternatives presented.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder majorRoadLabels(RouteMajorRoadLabel... majorRoadLabels);

        /**
         * <p>
         * Important labels including names and route numbers that differentiate the current route from the alternatives
         * presented.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteMajorRoadLabel.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteMajorRoadLabel#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteMajorRoadLabel.Builder#build()} is called
         * immediately and its result is passed to {@link #majorRoadLabels(List<RouteMajorRoadLabel>)}.
         * 
         * @param majorRoadLabels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteMajorRoadLabel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #majorRoadLabels(java.util.Collection<RouteMajorRoadLabel>)
         */
        Builder majorRoadLabels(Consumer<RouteMajorRoadLabel.Builder>... majorRoadLabels);

        /**
         * <p>
         * Summarized details of the leg.
         * </p>
         * 
         * @param summary
         *        Summarized details of the leg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(RouteSummary summary);

        /**
         * <p>
         * Summarized details of the leg.
         * </p>
         * This is a convenience method that creates an instance of the {@link RouteSummary.Builder} avoiding the need
         * to create one manually via {@link RouteSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RouteSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #summary(RouteSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link RouteSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(RouteSummary)
         */
        default Builder summary(Consumer<RouteSummary.Builder> summary) {
            return summary(RouteSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<RouteLeg> legs = DefaultSdkAutoConstructList.getInstance();

        private List<RouteMajorRoadLabel> majorRoadLabels = DefaultSdkAutoConstructList.getInstance();

        private RouteSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(Route model) {
            legs(model.legs);
            majorRoadLabels(model.majorRoadLabels);
            summary(model.summary);
        }

        public final List<RouteLeg.Builder> getLegs() {
            List<RouteLeg.Builder> result = RouteLegListCopier.copyToBuilder(this.legs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLegs(Collection<RouteLeg.BuilderImpl> legs) {
            this.legs = RouteLegListCopier.copyFromBuilder(legs);
        }

        @Override
        public final Builder legs(Collection<RouteLeg> legs) {
            this.legs = RouteLegListCopier.copy(legs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legs(RouteLeg... legs) {
            legs(Arrays.asList(legs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder legs(Consumer<RouteLeg.Builder>... legs) {
            legs(Stream.of(legs).map(c -> RouteLeg.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RouteMajorRoadLabel.Builder> getMajorRoadLabels() {
            List<RouteMajorRoadLabel.Builder> result = RouteMajorRoadLabelsListCopier.copyToBuilder(this.majorRoadLabels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMajorRoadLabels(Collection<RouteMajorRoadLabel.BuilderImpl> majorRoadLabels) {
            this.majorRoadLabels = RouteMajorRoadLabelsListCopier.copyFromBuilder(majorRoadLabels);
        }

        @Override
        public final Builder majorRoadLabels(Collection<RouteMajorRoadLabel> majorRoadLabels) {
            this.majorRoadLabels = RouteMajorRoadLabelsListCopier.copy(majorRoadLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder majorRoadLabels(RouteMajorRoadLabel... majorRoadLabels) {
            majorRoadLabels(Arrays.asList(majorRoadLabels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder majorRoadLabels(Consumer<RouteMajorRoadLabel.Builder>... majorRoadLabels) {
            majorRoadLabels(Stream.of(majorRoadLabels).map(c -> RouteMajorRoadLabel.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RouteSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(RouteSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(RouteSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public Route build() {
            return new Route(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
