/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.georoutes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies options for areas to avoid when calculating the route. This is a best-effort avoidance setting, meaning the
 * router will try to honor the avoidance preferences but may still include restricted areas if no feasible alternative
 * route exists. If avoidance options are not followed, the response will indicate that the avoidance criteria were
 * violated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RouteAvoidanceOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<RouteAvoidanceOptions.Builder, RouteAvoidanceOptions> {
    private static final SdkField<List<RouteAvoidanceArea>> AREAS_FIELD = SdkField
            .<List<RouteAvoidanceArea>> builder(MarshallingType.LIST)
            .memberName("Areas")
            .getter(getter(RouteAvoidanceOptions::areas))
            .setter(setter(Builder::areas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Areas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteAvoidanceArea> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteAvoidanceArea::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> CAR_SHUTTLE_TRAINS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CarShuttleTrains").getter(getter(RouteAvoidanceOptions::carShuttleTrains))
            .setter(setter(Builder::carShuttleTrains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarShuttleTrains").build()).build();

    private static final SdkField<Boolean> CONTROLLED_ACCESS_HIGHWAYS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ControlledAccessHighways").getter(getter(RouteAvoidanceOptions::controlledAccessHighways))
            .setter(setter(Builder::controlledAccessHighways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ControlledAccessHighways").build())
            .build();

    private static final SdkField<Boolean> DIRT_ROADS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DirtRoads").getter(getter(RouteAvoidanceOptions::dirtRoads)).setter(setter(Builder::dirtRoads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirtRoads").build()).build();

    private static final SdkField<Boolean> FERRIES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Ferries").getter(getter(RouteAvoidanceOptions::ferries)).setter(setter(Builder::ferries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ferries").build()).build();

    private static final SdkField<Boolean> SEASONAL_CLOSURE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SeasonalClosure").getter(getter(RouteAvoidanceOptions::seasonalClosure))
            .setter(setter(Builder::seasonalClosure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeasonalClosure").build()).build();

    private static final SdkField<Boolean> TOLL_ROADS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TollRoads").getter(getter(RouteAvoidanceOptions::tollRoads)).setter(setter(Builder::tollRoads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollRoads").build()).build();

    private static final SdkField<Boolean> TOLL_TRANSPONDERS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TollTransponders").getter(getter(RouteAvoidanceOptions::tollTransponders))
            .setter(setter(Builder::tollTransponders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TollTransponders").build()).build();

    private static final SdkField<List<String>> TRUCK_ROAD_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TruckRoadTypes")
            .getter(getter(RouteAvoidanceOptions::truckRoadTypes))
            .setter(setter(Builder::truckRoadTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TruckRoadTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> TUNNELS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Tunnels").getter(getter(RouteAvoidanceOptions::tunnels)).setter(setter(Builder::tunnels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tunnels").build()).build();

    private static final SdkField<Boolean> U_TURNS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("UTurns").getter(getter(RouteAvoidanceOptions::uTurns)).setter(setter(Builder::uTurns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UTurns").build()).build();

    private static final SdkField<List<RouteAvoidanceZoneCategory>> ZONE_CATEGORIES_FIELD = SdkField
            .<List<RouteAvoidanceZoneCategory>> builder(MarshallingType.LIST)
            .memberName("ZoneCategories")
            .getter(getter(RouteAvoidanceOptions::zoneCategories))
            .setter(setter(Builder::zoneCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteAvoidanceZoneCategory> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteAvoidanceZoneCategory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREAS_FIELD,
            CAR_SHUTTLE_TRAINS_FIELD, CONTROLLED_ACCESS_HIGHWAYS_FIELD, DIRT_ROADS_FIELD, FERRIES_FIELD, SEASONAL_CLOSURE_FIELD,
            TOLL_ROADS_FIELD, TOLL_TRANSPONDERS_FIELD, TRUCK_ROAD_TYPES_FIELD, TUNNELS_FIELD, U_TURNS_FIELD,
            ZONE_CATEGORIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RouteAvoidanceArea> areas;

    private final Boolean carShuttleTrains;

    private final Boolean controlledAccessHighways;

    private final Boolean dirtRoads;

    private final Boolean ferries;

    private final Boolean seasonalClosure;

    private final Boolean tollRoads;

    private final Boolean tollTransponders;

    private final List<String> truckRoadTypes;

    private final Boolean tunnels;

    private final Boolean uTurns;

    private final List<RouteAvoidanceZoneCategory> zoneCategories;

    private RouteAvoidanceOptions(BuilderImpl builder) {
        this.areas = builder.areas;
        this.carShuttleTrains = builder.carShuttleTrains;
        this.controlledAccessHighways = builder.controlledAccessHighways;
        this.dirtRoads = builder.dirtRoads;
        this.ferries = builder.ferries;
        this.seasonalClosure = builder.seasonalClosure;
        this.tollRoads = builder.tollRoads;
        this.tollTransponders = builder.tollTransponders;
        this.truckRoadTypes = builder.truckRoadTypes;
        this.tunnels = builder.tunnels;
        this.uTurns = builder.uTurns;
        this.zoneCategories = builder.zoneCategories;
    }

    /**
     * For responses, this returns true if the service returned a value for the Areas property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAreas() {
        return areas != null && !(areas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Areas to be avoided.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAreas} method.
     * </p>
     * 
     * @return Areas to be avoided.
     */
    public final List<RouteAvoidanceArea> areas() {
        return areas;
    }

    /**
     * <p>
     * Avoid car-shuttle-trains while calculating the route.
     * </p>
     * 
     * @return Avoid car-shuttle-trains while calculating the route.
     */
    public final Boolean carShuttleTrains() {
        return carShuttleTrains;
    }

    /**
     * <p>
     * Avoid controlled access highways while calculating the route.
     * </p>
     * 
     * @return Avoid controlled access highways while calculating the route.
     */
    public final Boolean controlledAccessHighways() {
        return controlledAccessHighways;
    }

    /**
     * <p>
     * Avoid dirt roads while calculating the route.
     * </p>
     * 
     * @return Avoid dirt roads while calculating the route.
     */
    public final Boolean dirtRoads() {
        return dirtRoads;
    }

    /**
     * <p>
     * Avoid ferries while calculating the route.
     * </p>
     * 
     * @return Avoid ferries while calculating the route.
     */
    public final Boolean ferries() {
        return ferries;
    }

    /**
     * <p>
     * Avoid roads that have seasonal closure while calculating the route.
     * </p>
     * 
     * @return Avoid roads that have seasonal closure while calculating the route.
     */
    public final Boolean seasonalClosure() {
        return seasonalClosure;
    }

    /**
     * <p>
     * Avoids roads where the specified toll transponders are the only mode of payment.
     * </p>
     * 
     * @return Avoids roads where the specified toll transponders are the only mode of payment.
     */
    public final Boolean tollRoads() {
        return tollRoads;
    }

    /**
     * <p>
     * Avoids roads where the specified toll transponders are the only mode of payment.
     * </p>
     * 
     * @return Avoids roads where the specified toll transponders are the only mode of payment.
     */
    public final Boolean tollTransponders() {
        return tollTransponders;
    }

    /**
     * For responses, this returns true if the service returned a value for the TruckRoadTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTruckRoadTypes() {
        return truckRoadTypes != null && !(truckRoadTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
     * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
     * </p>
     * <note>
     * <p>
     * There are currently no other supported values as of 26th April 2024.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTruckRoadTypes} method.
     * </p>
     * 
     * @return Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
     *         <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
     *         <p>
     *         There are currently no other supported values as of 26th April 2024.
     *         </p>
     */
    public final List<String> truckRoadTypes() {
        return truckRoadTypes;
    }

    /**
     * <p>
     * Avoid tunnels while calculating the route.
     * </p>
     * 
     * @return Avoid tunnels while calculating the route.
     */
    public final Boolean tunnels() {
        return tunnels;
    }

    /**
     * <p>
     * Avoid U-turns for calculation on highways and motorways.
     * </p>
     * 
     * @return Avoid U-turns for calculation on highways and motorways.
     */
    public final Boolean uTurns() {
        return uTurns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ZoneCategories property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasZoneCategories() {
        return zoneCategories != null && !(zoneCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Zone categories to be avoided.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasZoneCategories} method.
     * </p>
     * 
     * @return Zone categories to be avoided.
     */
    public final List<RouteAvoidanceZoneCategory> zoneCategories() {
        return zoneCategories;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAreas() ? areas() : null);
        hashCode = 31 * hashCode + Objects.hashCode(carShuttleTrains());
        hashCode = 31 * hashCode + Objects.hashCode(controlledAccessHighways());
        hashCode = 31 * hashCode + Objects.hashCode(dirtRoads());
        hashCode = 31 * hashCode + Objects.hashCode(ferries());
        hashCode = 31 * hashCode + Objects.hashCode(seasonalClosure());
        hashCode = 31 * hashCode + Objects.hashCode(tollRoads());
        hashCode = 31 * hashCode + Objects.hashCode(tollTransponders());
        hashCode = 31 * hashCode + Objects.hashCode(hasTruckRoadTypes() ? truckRoadTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(tunnels());
        hashCode = 31 * hashCode + Objects.hashCode(uTurns());
        hashCode = 31 * hashCode + Objects.hashCode(hasZoneCategories() ? zoneCategories() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteAvoidanceOptions)) {
            return false;
        }
        RouteAvoidanceOptions other = (RouteAvoidanceOptions) obj;
        return hasAreas() == other.hasAreas() && Objects.equals(areas(), other.areas())
                && Objects.equals(carShuttleTrains(), other.carShuttleTrains())
                && Objects.equals(controlledAccessHighways(), other.controlledAccessHighways())
                && Objects.equals(dirtRoads(), other.dirtRoads()) && Objects.equals(ferries(), other.ferries())
                && Objects.equals(seasonalClosure(), other.seasonalClosure()) && Objects.equals(tollRoads(), other.tollRoads())
                && Objects.equals(tollTransponders(), other.tollTransponders())
                && hasTruckRoadTypes() == other.hasTruckRoadTypes() && Objects.equals(truckRoadTypes(), other.truckRoadTypes())
                && Objects.equals(tunnels(), other.tunnels()) && Objects.equals(uTurns(), other.uTurns())
                && hasZoneCategories() == other.hasZoneCategories() && Objects.equals(zoneCategories(), other.zoneCategories());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RouteAvoidanceOptions").add("Areas", hasAreas() ? areas() : null)
                .add("CarShuttleTrains", carShuttleTrains()).add("ControlledAccessHighways", controlledAccessHighways())
                .add("DirtRoads", dirtRoads()).add("Ferries", ferries()).add("SeasonalClosure", seasonalClosure())
                .add("TollRoads", tollRoads()).add("TollTransponders", tollTransponders())
                .add("TruckRoadTypes", hasTruckRoadTypes() ? truckRoadTypes() : null).add("Tunnels", tunnels())
                .add("UTurns", uTurns()).add("ZoneCategories", hasZoneCategories() ? zoneCategories() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Areas":
            return Optional.ofNullable(clazz.cast(areas()));
        case "CarShuttleTrains":
            return Optional.ofNullable(clazz.cast(carShuttleTrains()));
        case "ControlledAccessHighways":
            return Optional.ofNullable(clazz.cast(controlledAccessHighways()));
        case "DirtRoads":
            return Optional.ofNullable(clazz.cast(dirtRoads()));
        case "Ferries":
            return Optional.ofNullable(clazz.cast(ferries()));
        case "SeasonalClosure":
            return Optional.ofNullable(clazz.cast(seasonalClosure()));
        case "TollRoads":
            return Optional.ofNullable(clazz.cast(tollRoads()));
        case "TollTransponders":
            return Optional.ofNullable(clazz.cast(tollTransponders()));
        case "TruckRoadTypes":
            return Optional.ofNullable(clazz.cast(truckRoadTypes()));
        case "Tunnels":
            return Optional.ofNullable(clazz.cast(tunnels()));
        case "UTurns":
            return Optional.ofNullable(clazz.cast(uTurns()));
        case "ZoneCategories":
            return Optional.ofNullable(clazz.cast(zoneCategories()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Areas", AREAS_FIELD);
        map.put("CarShuttleTrains", CAR_SHUTTLE_TRAINS_FIELD);
        map.put("ControlledAccessHighways", CONTROLLED_ACCESS_HIGHWAYS_FIELD);
        map.put("DirtRoads", DIRT_ROADS_FIELD);
        map.put("Ferries", FERRIES_FIELD);
        map.put("SeasonalClosure", SEASONAL_CLOSURE_FIELD);
        map.put("TollRoads", TOLL_ROADS_FIELD);
        map.put("TollTransponders", TOLL_TRANSPONDERS_FIELD);
        map.put("TruckRoadTypes", TRUCK_ROAD_TYPES_FIELD);
        map.put("Tunnels", TUNNELS_FIELD);
        map.put("UTurns", U_TURNS_FIELD);
        map.put("ZoneCategories", ZONE_CATEGORIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteAvoidanceOptions, T> g) {
        return obj -> g.apply((RouteAvoidanceOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RouteAvoidanceOptions> {
        /**
         * <p>
         * Areas to be avoided.
         * </p>
         * 
         * @param areas
         *        Areas to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areas(Collection<RouteAvoidanceArea> areas);

        /**
         * <p>
         * Areas to be avoided.
         * </p>
         * 
         * @param areas
         *        Areas to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder areas(RouteAvoidanceArea... areas);

        /**
         * <p>
         * Areas to be avoided.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceArea.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceArea#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceArea.Builder#build()} is called
         * immediately and its result is passed to {@link #areas(List<RouteAvoidanceArea>)}.
         * 
         * @param areas
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceArea.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #areas(java.util.Collection<RouteAvoidanceArea>)
         */
        Builder areas(Consumer<RouteAvoidanceArea.Builder>... areas);

        /**
         * <p>
         * Avoid car-shuttle-trains while calculating the route.
         * </p>
         * 
         * @param carShuttleTrains
         *        Avoid car-shuttle-trains while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder carShuttleTrains(Boolean carShuttleTrains);

        /**
         * <p>
         * Avoid controlled access highways while calculating the route.
         * </p>
         * 
         * @param controlledAccessHighways
         *        Avoid controlled access highways while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder controlledAccessHighways(Boolean controlledAccessHighways);

        /**
         * <p>
         * Avoid dirt roads while calculating the route.
         * </p>
         * 
         * @param dirtRoads
         *        Avoid dirt roads while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dirtRoads(Boolean dirtRoads);

        /**
         * <p>
         * Avoid ferries while calculating the route.
         * </p>
         * 
         * @param ferries
         *        Avoid ferries while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ferries(Boolean ferries);

        /**
         * <p>
         * Avoid roads that have seasonal closure while calculating the route.
         * </p>
         * 
         * @param seasonalClosure
         *        Avoid roads that have seasonal closure while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder seasonalClosure(Boolean seasonalClosure);

        /**
         * <p>
         * Avoids roads where the specified toll transponders are the only mode of payment.
         * </p>
         * 
         * @param tollRoads
         *        Avoids roads where the specified toll transponders are the only mode of payment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollRoads(Boolean tollRoads);

        /**
         * <p>
         * Avoids roads where the specified toll transponders are the only mode of payment.
         * </p>
         * 
         * @param tollTransponders
         *        Avoids roads where the specified toll transponders are the only mode of payment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tollTransponders(Boolean tollTransponders);

        /**
         * <p>
         * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
         * </p>
         * <note>
         * <p>
         * There are currently no other supported values as of 26th April 2024.
         * </p>
         * </note>
         * 
         * @param truckRoadTypes
         *        Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         *        <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
         *        <p>
         *        There are currently no other supported values as of 26th April 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckRoadTypes(Collection<String> truckRoadTypes);

        /**
         * <p>
         * Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         * <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.
         * </p>
         * <note>
         * <p>
         * There are currently no other supported values as of 26th April 2024.
         * </p>
         * </note>
         * 
         * @param truckRoadTypes
         *        Truck road type identifiers. <code>BK1</code> through <code>BK4</code> apply only to Sweden.
         *        <code>A2,A4,B2,B4,C,D,ET2,ET4</code> apply only to Mexico.</p> <note>
         *        <p>
         *        There are currently no other supported values as of 26th April 2024.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder truckRoadTypes(String... truckRoadTypes);

        /**
         * <p>
         * Avoid tunnels while calculating the route.
         * </p>
         * 
         * @param tunnels
         *        Avoid tunnels while calculating the route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tunnels(Boolean tunnels);

        /**
         * <p>
         * Avoid U-turns for calculation on highways and motorways.
         * </p>
         * 
         * @param uTurns
         *        Avoid U-turns for calculation on highways and motorways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uTurns(Boolean uTurns);

        /**
         * <p>
         * Zone categories to be avoided.
         * </p>
         * 
         * @param zoneCategories
         *        Zone categories to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneCategories(Collection<RouteAvoidanceZoneCategory> zoneCategories);

        /**
         * <p>
         * Zone categories to be avoided.
         * </p>
         * 
         * @param zoneCategories
         *        Zone categories to be avoided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneCategories(RouteAvoidanceZoneCategory... zoneCategories);

        /**
         * <p>
         * Zone categories to be avoided.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceZoneCategory.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceZoneCategory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceZoneCategory.Builder#build()} is called
         * immediately and its result is passed to {@link #zoneCategories(List<RouteAvoidanceZoneCategory>)}.
         * 
         * @param zoneCategories
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.georoutes.model.RouteAvoidanceZoneCategory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zoneCategories(java.util.Collection<RouteAvoidanceZoneCategory>)
         */
        Builder zoneCategories(Consumer<RouteAvoidanceZoneCategory.Builder>... zoneCategories);
    }

    static final class BuilderImpl implements Builder {
        private List<RouteAvoidanceArea> areas = DefaultSdkAutoConstructList.getInstance();

        private Boolean carShuttleTrains;

        private Boolean controlledAccessHighways;

        private Boolean dirtRoads;

        private Boolean ferries;

        private Boolean seasonalClosure;

        private Boolean tollRoads;

        private Boolean tollTransponders;

        private List<String> truckRoadTypes = DefaultSdkAutoConstructList.getInstance();

        private Boolean tunnels;

        private Boolean uTurns;

        private List<RouteAvoidanceZoneCategory> zoneCategories = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RouteAvoidanceOptions model) {
            areas(model.areas);
            carShuttleTrains(model.carShuttleTrains);
            controlledAccessHighways(model.controlledAccessHighways);
            dirtRoads(model.dirtRoads);
            ferries(model.ferries);
            seasonalClosure(model.seasonalClosure);
            tollRoads(model.tollRoads);
            tollTransponders(model.tollTransponders);
            truckRoadTypes(model.truckRoadTypes);
            tunnels(model.tunnels);
            uTurns(model.uTurns);
            zoneCategories(model.zoneCategories);
        }

        public final List<RouteAvoidanceArea.Builder> getAreas() {
            List<RouteAvoidanceArea.Builder> result = RouteAvoidanceAreaListCopier.copyToBuilder(this.areas);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAreas(Collection<RouteAvoidanceArea.BuilderImpl> areas) {
            this.areas = RouteAvoidanceAreaListCopier.copyFromBuilder(areas);
        }

        @Override
        public final Builder areas(Collection<RouteAvoidanceArea> areas) {
            this.areas = RouteAvoidanceAreaListCopier.copy(areas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder areas(RouteAvoidanceArea... areas) {
            areas(Arrays.asList(areas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder areas(Consumer<RouteAvoidanceArea.Builder>... areas) {
            areas(Stream.of(areas).map(c -> RouteAvoidanceArea.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCarShuttleTrains() {
            return carShuttleTrains;
        }

        public final void setCarShuttleTrains(Boolean carShuttleTrains) {
            this.carShuttleTrains = carShuttleTrains;
        }

        @Override
        public final Builder carShuttleTrains(Boolean carShuttleTrains) {
            this.carShuttleTrains = carShuttleTrains;
            return this;
        }

        public final Boolean getControlledAccessHighways() {
            return controlledAccessHighways;
        }

        public final void setControlledAccessHighways(Boolean controlledAccessHighways) {
            this.controlledAccessHighways = controlledAccessHighways;
        }

        @Override
        public final Builder controlledAccessHighways(Boolean controlledAccessHighways) {
            this.controlledAccessHighways = controlledAccessHighways;
            return this;
        }

        public final Boolean getDirtRoads() {
            return dirtRoads;
        }

        public final void setDirtRoads(Boolean dirtRoads) {
            this.dirtRoads = dirtRoads;
        }

        @Override
        public final Builder dirtRoads(Boolean dirtRoads) {
            this.dirtRoads = dirtRoads;
            return this;
        }

        public final Boolean getFerries() {
            return ferries;
        }

        public final void setFerries(Boolean ferries) {
            this.ferries = ferries;
        }

        @Override
        public final Builder ferries(Boolean ferries) {
            this.ferries = ferries;
            return this;
        }

        public final Boolean getSeasonalClosure() {
            return seasonalClosure;
        }

        public final void setSeasonalClosure(Boolean seasonalClosure) {
            this.seasonalClosure = seasonalClosure;
        }

        @Override
        public final Builder seasonalClosure(Boolean seasonalClosure) {
            this.seasonalClosure = seasonalClosure;
            return this;
        }

        public final Boolean getTollRoads() {
            return tollRoads;
        }

        public final void setTollRoads(Boolean tollRoads) {
            this.tollRoads = tollRoads;
        }

        @Override
        public final Builder tollRoads(Boolean tollRoads) {
            this.tollRoads = tollRoads;
            return this;
        }

        public final Boolean getTollTransponders() {
            return tollTransponders;
        }

        public final void setTollTransponders(Boolean tollTransponders) {
            this.tollTransponders = tollTransponders;
        }

        @Override
        public final Builder tollTransponders(Boolean tollTransponders) {
            this.tollTransponders = tollTransponders;
            return this;
        }

        public final Collection<String> getTruckRoadTypes() {
            if (truckRoadTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return truckRoadTypes;
        }

        public final void setTruckRoadTypes(Collection<String> truckRoadTypes) {
            this.truckRoadTypes = TruckRoadTypeListCopier.copy(truckRoadTypes);
        }

        @Override
        public final Builder truckRoadTypes(Collection<String> truckRoadTypes) {
            this.truckRoadTypes = TruckRoadTypeListCopier.copy(truckRoadTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder truckRoadTypes(String... truckRoadTypes) {
            truckRoadTypes(Arrays.asList(truckRoadTypes));
            return this;
        }

        public final Boolean getTunnels() {
            return tunnels;
        }

        public final void setTunnels(Boolean tunnels) {
            this.tunnels = tunnels;
        }

        @Override
        public final Builder tunnels(Boolean tunnels) {
            this.tunnels = tunnels;
            return this;
        }

        public final Boolean getUTurns() {
            return uTurns;
        }

        public final void setUTurns(Boolean uTurns) {
            this.uTurns = uTurns;
        }

        @Override
        public final Builder uTurns(Boolean uTurns) {
            this.uTurns = uTurns;
            return this;
        }

        public final List<RouteAvoidanceZoneCategory.Builder> getZoneCategories() {
            List<RouteAvoidanceZoneCategory.Builder> result = RouteAvoidanceZoneCategoryListCopier
                    .copyToBuilder(this.zoneCategories);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setZoneCategories(Collection<RouteAvoidanceZoneCategory.BuilderImpl> zoneCategories) {
            this.zoneCategories = RouteAvoidanceZoneCategoryListCopier.copyFromBuilder(zoneCategories);
        }

        @Override
        public final Builder zoneCategories(Collection<RouteAvoidanceZoneCategory> zoneCategories) {
            this.zoneCategories = RouteAvoidanceZoneCategoryListCopier.copy(zoneCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneCategories(RouteAvoidanceZoneCategory... zoneCategories) {
            zoneCategories(Arrays.asList(zoneCategories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneCategories(Consumer<RouteAvoidanceZoneCategory.Builder>... zoneCategories) {
            zoneCategories(Stream.of(zoneCategories).map(c -> RouteAvoidanceZoneCategory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RouteAvoidanceOptions build() {
            return new RouteAvoidanceOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
